/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.FxRateAsset;
import fpml.consolidated.asset.InstrumentType;
import fpml.consolidated.asset.meta.FxMeta;
import fpml.consolidated.shared.ClearanceSystem;
import fpml.consolidated.shared.ExchangeId;
import fpml.consolidated.shared.FxSpotRateSource;
import fpml.consolidated.shared.IdentifiedCurrency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.ProductReference;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Fx", builder=FxBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Fx", model="fpml", builder=FxBuilderImpl.class, version="1.1.0")
public interface Fx
extends FxRateAsset {
    public static final FxMeta metaData = new FxMeta();

    @Override
    public Fx build();

    @Override
    public FxBuilder toBuilder();

    public static FxBuilder builder() {
        return new FxBuilderImpl();
    }

    default public RosettaMetaData<? extends Fx> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Fx> getType() {
        return Fx.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSource"), processor, FxSpotRateSource.class, this.getRateSource(), new AttributeMeta[0]);
    }

    public static class FxBuilderImpl
    extends FxRateAsset.FxRateAssetBuilderImpl
    implements FxBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public FxBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public FxBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public FxBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public FxBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public FxBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public FxBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public FxBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public FxBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public FxBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public FxBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public FxBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public FxBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public FxBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair")
        @RuneAttribute(value="quotedCurrencyPair")
        public FxBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSource")
        @RuneAttribute(value="rateSource")
        public FxBuilder setRateSource(FxSpotRateSource _rateSource) {
            this.rateSource = _rateSource == null ? null : _rateSource.toBuilder();
            return this;
        }

        @Override
        public Fx build() {
            return new FxImpl(this);
        }

        @Override
        public FxBuilder toBuilder() {
            return this;
        }

        @Override
        public FxBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public FxBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxBuilder o = (FxBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "FxBuilder {} " + super.toString();
        }
    }

    public static interface FxBuilder
    extends Fx,
    FxRateAsset.FxRateAssetBuilder {
        @Override
        public FxBuilder setId(String var1);

        @Override
        public FxBuilder addInstrumentId(InstrumentId var1);

        @Override
        public FxBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public FxBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FxBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FxBuilder addInstrumentType(InstrumentType var1);

        @Override
        public FxBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public FxBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FxBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FxBuilder setDescription(String var1);

        @Override
        public FxBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public FxBuilder setExchangeId(ExchangeId var1);

        @Override
        public FxBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public FxBuilder setDefinition(ProductReference var1);

        @Override
        public FxBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        @Override
        public FxBuilder setRateSource(FxSpotRateSource var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, (RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, (RosettaModelObjectBuilder)this.getRateSource(), new AttributeMeta[0]);
        }

        @Override
        public FxBuilder prune();
    }

    public static class FxImpl
    extends FxRateAsset.FxRateAssetImpl
    implements Fx {
        protected FxImpl(FxBuilder builder) {
            super(builder);
        }

        @Override
        public Fx build() {
            return this;
        }

        @Override
        public FxBuilder toBuilder() {
            FxBuilder builder = Fx.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Fx {} " + super.toString();
        }
    }
}

