/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.asset.CommodityInformationSource;
import fpml.consolidated.asset.CommodityReferencePriceFrameworkModelSequence;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.asset.meta.CommodityReferencePriceFrameworkModelMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.ExchangeId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityReferencePriceFrameworkModel", builder=CommodityReferencePriceFrameworkModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityReferencePriceFrameworkModel", model="fpml", builder=CommodityReferencePriceFrameworkModelBuilderImpl.class, version="1.1.0")
public interface CommodityReferencePriceFrameworkModel
extends RosettaModelObject {
    public static final CommodityReferencePriceFrameworkModelMeta metaData = new CommodityReferencePriceFrameworkModelMeta();

    public CommodityReferencePriceFrameworkModelSequence getCommodityReferencePriceFrameworkModelSequence();

    public List<? extends CommodityClassification> getCommodityClassification();

    public QuantityUnit getUnit();

    public Currency getCurrency();

    public ExchangeId getExchangeId();

    public CommodityInformationSource getPublication();

    public CommodityReferencePriceFrameworkModel build();

    public CommodityReferencePriceFrameworkModelBuilder toBuilder();

    public static CommodityReferencePriceFrameworkModelBuilder builder() {
        return new CommodityReferencePriceFrameworkModelBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityReferencePriceFrameworkModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityReferencePriceFrameworkModel> getType() {
        return CommodityReferencePriceFrameworkModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("commodityReferencePriceFrameworkModelSequence"), processor, CommodityReferencePriceFrameworkModelSequence.class, this.getCommodityReferencePriceFrameworkModelSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publication"), processor, CommodityInformationSource.class, this.getPublication(), new AttributeMeta[0]);
    }

    public static class CommodityReferencePriceFrameworkModelBuilderImpl
    implements CommodityReferencePriceFrameworkModelBuilder {
        protected CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder commodityReferencePriceFrameworkModelSequence;
        protected List<CommodityClassification.CommodityClassificationBuilder> commodityClassification = new ArrayList<CommodityClassification.CommodityClassificationBuilder>();
        protected QuantityUnit.QuantityUnitBuilder unit;
        protected Currency.CurrencyBuilder currency;
        protected ExchangeId.ExchangeIdBuilder exchangeId;
        protected CommodityInformationSource.CommodityInformationSourceBuilder publication;

        @Override
        @RosettaAttribute(value="commodityReferencePriceFrameworkModelSequence")
        @RuneAttribute(value="commodityReferencePriceFrameworkModelSequence")
        public CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder getCommodityReferencePriceFrameworkModelSequence() {
            return this.commodityReferencePriceFrameworkModelSequence;
        }

        @Override
        public CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder getOrCreateCommodityReferencePriceFrameworkModelSequence() {
            CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder result = this.commodityReferencePriceFrameworkModelSequence != null ? this.commodityReferencePriceFrameworkModelSequence : (this.commodityReferencePriceFrameworkModelSequence = CommodityReferencePriceFrameworkModelSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public List<? extends CommodityClassification.CommodityClassificationBuilder> getCommodityClassification() {
            return this.commodityClassification;
        }

        @Override
        public CommodityClassification.CommodityClassificationBuilder getOrCreateCommodityClassification(int index) {
            if (this.commodityClassification == null) {
                this.commodityClassification = new ArrayList<CommodityClassification.CommodityClassificationBuilder>();
            }
            return (CommodityClassification.CommodityClassificationBuilder)this.getIndex(this.commodityClassification, index, () -> {
                CommodityClassification.CommodityClassificationBuilder newCommodityClassification = CommodityClassification.builder();
                return newCommodityClassification;
            });
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public QuantityUnit.QuantityUnitBuilder getUnit() {
            return this.unit;
        }

        @Override
        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit() {
            QuantityUnit.QuantityUnitBuilder result = this.unit != null ? this.unit : (this.unit = QuantityUnit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeId.ExchangeIdBuilder getExchangeId() {
            return this.exchangeId;
        }

        @Override
        public ExchangeId.ExchangeIdBuilder getOrCreateExchangeId() {
            ExchangeId.ExchangeIdBuilder result = this.exchangeId != null ? this.exchangeId : (this.exchangeId = ExchangeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="publication")
        @RuneAttribute(value="publication")
        public CommodityInformationSource.CommodityInformationSourceBuilder getPublication() {
            return this.publication;
        }

        @Override
        public CommodityInformationSource.CommodityInformationSourceBuilder getOrCreatePublication() {
            CommodityInformationSource.CommodityInformationSourceBuilder result = this.publication != null ? this.publication : (this.publication = CommodityInformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityReferencePriceFrameworkModelSequence")
        @RuneAttribute(value="commodityReferencePriceFrameworkModelSequence")
        public CommodityReferencePriceFrameworkModelBuilder setCommodityReferencePriceFrameworkModelSequence(CommodityReferencePriceFrameworkModelSequence _commodityReferencePriceFrameworkModelSequence) {
            this.commodityReferencePriceFrameworkModelSequence = _commodityReferencePriceFrameworkModelSequence == null ? null : _commodityReferencePriceFrameworkModelSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public CommodityReferencePriceFrameworkModelBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList<CommodityClassification.CommodityClassificationBuilder>() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public CommodityReferencePriceFrameworkModelBuilder setUnit(QuantityUnit _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public CommodityReferencePriceFrameworkModelBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public CommodityReferencePriceFrameworkModelBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="publication")
        @RuneAttribute(value="publication")
        public CommodityReferencePriceFrameworkModelBuilder setPublication(CommodityInformationSource _publication) {
            this.publication = _publication == null ? null : _publication.toBuilder();
            return this;
        }

        @Override
        public CommodityReferencePriceFrameworkModel build() {
            return new CommodityReferencePriceFrameworkModelImpl(this);
        }

        @Override
        public CommodityReferencePriceFrameworkModelBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityReferencePriceFrameworkModelBuilder prune() {
            if (this.commodityReferencePriceFrameworkModelSequence != null && !this.commodityReferencePriceFrameworkModelSequence.prune().hasData()) {
                this.commodityReferencePriceFrameworkModelSequence = null;
            }
            this.commodityClassification = this.commodityClassification.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.unit != null && !this.unit.prune().hasData()) {
                this.unit = null;
            }
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.exchangeId != null && !this.exchangeId.prune().hasData()) {
                this.exchangeId = null;
            }
            if (this.publication != null && !this.publication.prune().hasData()) {
                this.publication = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCommodityReferencePriceFrameworkModelSequence() != null && this.getCommodityReferencePriceFrameworkModelSequence().hasData()) {
                return true;
            }
            if (this.getCommodityClassification() != null && this.getCommodityClassification().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getUnit() != null && this.getUnit().hasData()) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getExchangeId() != null && this.getExchangeId().hasData()) {
                return true;
            }
            return this.getPublication() != null && this.getPublication().hasData();
        }

        public CommodityReferencePriceFrameworkModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityReferencePriceFrameworkModelBuilder o = (CommodityReferencePriceFrameworkModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityReferencePriceFrameworkModelSequence(), (RosettaModelObjectBuilder)o.getCommodityReferencePriceFrameworkModelSequence(), this::setCommodityReferencePriceFrameworkModelSequence);
            merger.mergeRosetta(this.getCommodityClassification(), o.getCommodityClassification(), this::getOrCreateCommodityClassification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnit(), (RosettaModelObjectBuilder)o.getUnit(), this::setUnit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeId(), (RosettaModelObjectBuilder)o.getExchangeId(), this::setExchangeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPublication(), (RosettaModelObjectBuilder)o.getPublication(), this::setPublication);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityReferencePriceFrameworkModel _that = this.getType().cast(o);
            if (!Objects.equals(this.commodityReferencePriceFrameworkModelSequence, _that.getCommodityReferencePriceFrameworkModelSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityClassification, _that.getCommodityClassification())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            return Objects.equals(this.publication, _that.getPublication());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityReferencePriceFrameworkModelSequence != null ? this.commodityReferencePriceFrameworkModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.commodityClassification != null ? this.commodityClassification.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.publication != null ? this.publication.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityReferencePriceFrameworkModelBuilder {commodityReferencePriceFrameworkModelSequence=" + this.commodityReferencePriceFrameworkModelSequence + ", commodityClassification=" + this.commodityClassification + ", unit=" + this.unit + ", currency=" + this.currency + ", exchangeId=" + this.exchangeId + ", publication=" + this.publication + '}';
        }
    }

    public static interface CommodityReferencePriceFrameworkModelBuilder
    extends CommodityReferencePriceFrameworkModel,
    RosettaModelObjectBuilder {
        public CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder getOrCreateCommodityReferencePriceFrameworkModelSequence();

        @Override
        public CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder getCommodityReferencePriceFrameworkModelSequence();

        public CommodityClassification.CommodityClassificationBuilder getOrCreateCommodityClassification(int var1);

        public List<? extends CommodityClassification.CommodityClassificationBuilder> getCommodityClassification();

        public QuantityUnit.QuantityUnitBuilder getOrCreateUnit();

        @Override
        public QuantityUnit.QuantityUnitBuilder getUnit();

        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public ExchangeId.ExchangeIdBuilder getOrCreateExchangeId();

        @Override
        public ExchangeId.ExchangeIdBuilder getExchangeId();

        public CommodityInformationSource.CommodityInformationSourceBuilder getOrCreatePublication();

        @Override
        public CommodityInformationSource.CommodityInformationSourceBuilder getPublication();

        public CommodityReferencePriceFrameworkModelBuilder setCommodityReferencePriceFrameworkModelSequence(CommodityReferencePriceFrameworkModelSequence var1);

        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(CommodityClassification var1);

        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(CommodityClassification var1, int var2);

        public CommodityReferencePriceFrameworkModelBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        public CommodityReferencePriceFrameworkModelBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        public CommodityReferencePriceFrameworkModelBuilder setUnit(QuantityUnit var1);

        public CommodityReferencePriceFrameworkModelBuilder setCurrency(Currency var1);

        public CommodityReferencePriceFrameworkModelBuilder setExchangeId(ExchangeId var1);

        public CommodityReferencePriceFrameworkModelBuilder setPublication(CommodityInformationSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("commodityReferencePriceFrameworkModelSequence"), processor, CommodityReferencePriceFrameworkModelSequence.CommodityReferencePriceFrameworkModelSequenceBuilder.class, this.getCommodityReferencePriceFrameworkModelSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, QuantityUnit.QuantityUnitBuilder.class, this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publication"), processor, CommodityInformationSource.CommodityInformationSourceBuilder.class, this.getPublication(), new AttributeMeta[0]);
        }

        public CommodityReferencePriceFrameworkModelBuilder prune();
    }

    public static class CommodityReferencePriceFrameworkModelImpl
    implements CommodityReferencePriceFrameworkModel {
        private final CommodityReferencePriceFrameworkModelSequence commodityReferencePriceFrameworkModelSequence;
        private final List<? extends CommodityClassification> commodityClassification;
        private final QuantityUnit unit;
        private final Currency currency;
        private final ExchangeId exchangeId;
        private final CommodityInformationSource publication;

        protected CommodityReferencePriceFrameworkModelImpl(CommodityReferencePriceFrameworkModelBuilder builder) {
            this.commodityReferencePriceFrameworkModelSequence = Optional.ofNullable(builder.getCommodityReferencePriceFrameworkModelSequence()).map(f -> f.build()).orElse(null);
            this.commodityClassification = Optional.ofNullable(builder.getCommodityClassification()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.unit = Optional.ofNullable(builder.getUnit()).map(f -> f.build()).orElse(null);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.exchangeId = Optional.ofNullable(builder.getExchangeId()).map(f -> f.build()).orElse(null);
            this.publication = Optional.ofNullable(builder.getPublication()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="commodityReferencePriceFrameworkModelSequence")
        @RuneAttribute(value="commodityReferencePriceFrameworkModelSequence")
        public CommodityReferencePriceFrameworkModelSequence getCommodityReferencePriceFrameworkModelSequence() {
            return this.commodityReferencePriceFrameworkModelSequence;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public List<? extends CommodityClassification> getCommodityClassification() {
            return this.commodityClassification;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public QuantityUnit getUnit() {
            return this.unit;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeId getExchangeId() {
            return this.exchangeId;
        }

        @Override
        @RosettaAttribute(value="publication")
        @RuneAttribute(value="publication")
        public CommodityInformationSource getPublication() {
            return this.publication;
        }

        @Override
        public CommodityReferencePriceFrameworkModel build() {
            return this;
        }

        @Override
        public CommodityReferencePriceFrameworkModelBuilder toBuilder() {
            CommodityReferencePriceFrameworkModelBuilder builder = CommodityReferencePriceFrameworkModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityReferencePriceFrameworkModelBuilder builder) {
            Optional.ofNullable(this.getCommodityReferencePriceFrameworkModelSequence()).ifPresent(builder::setCommodityReferencePriceFrameworkModelSequence);
            Optional.ofNullable(this.getCommodityClassification()).ifPresent(builder::setCommodityClassification);
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getExchangeId()).ifPresent(builder::setExchangeId);
            Optional.ofNullable(this.getPublication()).ifPresent(builder::setPublication);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityReferencePriceFrameworkModel _that = this.getType().cast(o);
            if (!Objects.equals(this.commodityReferencePriceFrameworkModelSequence, _that.getCommodityReferencePriceFrameworkModelSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.commodityClassification, _that.getCommodityClassification())) {
                return false;
            }
            if (!Objects.equals(this.unit, _that.getUnit())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            return Objects.equals(this.publication, _that.getPublication());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.commodityReferencePriceFrameworkModelSequence != null ? this.commodityReferencePriceFrameworkModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.commodityClassification != null ? this.commodityClassification.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.publication != null ? this.publication.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityReferencePriceFrameworkModel {commodityReferencePriceFrameworkModelSequence=" + this.commodityReferencePriceFrameworkModelSequence + ", commodityClassification=" + this.commodityClassification + ", unit=" + this.unit + ", currency=" + this.currency + ", exchangeId=" + this.exchangeId + ", publication=" + this.publication + '}';
        }
    }
}

