/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.meta.CashMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.InstrumentId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Cash", builder=CashBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Cash", model="fpml", builder=CashBuilderImpl.class, version="1.1.0")
public interface Cash
extends Asset {
    public static final CashMeta metaData = new CashMeta();

    public List<? extends InstrumentId> getInstrumentId();

    public String getDescription();

    public Currency getCurrency();

    @Override
    public Cash build();

    @Override
    public CashBuilder toBuilder();

    public static CashBuilder builder() {
        return new CashBuilderImpl();
    }

    default public RosettaMetaData<? extends Cash> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Cash> getType() {
        return Cash.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class CashBuilderImpl
    extends Asset.AssetBuilderImpl
    implements CashBuilder {
        protected List<InstrumentId.InstrumentIdBuilder> instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
        protected String description;
        protected Currency.CurrencyBuilder currency;

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int index) {
            if (this.instrumentId == null) {
                this.instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
            }
            return (InstrumentId.InstrumentIdBuilder)this.getIndex(this.instrumentId, index, () -> {
                InstrumentId.InstrumentIdBuilder newInstrumentId = InstrumentId.builder();
                return newInstrumentId;
            });
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CashBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public CashBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public CashBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public CashBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public CashBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList<InstrumentId.InstrumentIdBuilder>() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public CashBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public CashBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        public Cash build() {
            return new CashImpl(this);
        }

        @Override
        public CashBuilder toBuilder() {
            return this;
        }

        @Override
        public CashBuilder prune() {
            super.prune();
            this.instrumentId = this.instrumentId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInstrumentId() != null && this.getInstrumentId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDescription() != null) {
                return true;
            }
            return this.getCurrency() != null && this.getCurrency().hasData();
        }

        @Override
        public CashBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CashBuilder o = (CashBuilder)other;
            merger.mergeRosetta(this.getInstrumentId(), o.getInstrumentId(), this::getOrCreateInstrumentId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cash _that = (Cash)this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CashBuilder {instrumentId=" + this.instrumentId + ", description=" + this.description + ", currency=" + this.currency + '}' + " " + super.toString();
        }
    }

    public static interface CashBuilder
    extends Cash,
    Asset.AssetBuilder {
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int var1);

        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId();

        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        @Override
        public CashBuilder setId(String var1);

        public CashBuilder addInstrumentId(InstrumentId var1);

        public CashBuilder addInstrumentId(InstrumentId var1, int var2);

        public CashBuilder addInstrumentId(List<? extends InstrumentId> var1);

        public CashBuilder setInstrumentId(List<? extends InstrumentId> var1);

        public CashBuilder setDescription(String var1);

        public CashBuilder setCurrency(Currency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        @Override
        public CashBuilder prune();
    }

    public static class CashImpl
    extends Asset.AssetImpl
    implements Cash {
        private final List<? extends InstrumentId> instrumentId;
        private final String description;
        private final Currency currency;

        protected CashImpl(CashBuilder builder) {
            super(builder);
            this.instrumentId = Optional.ofNullable(builder.getInstrumentId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.description = builder.getDescription();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        public Cash build() {
            return this;
        }

        @Override
        public CashBuilder toBuilder() {
            CashBuilder builder = Cash.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInstrumentId()).ifPresent(builder::setInstrumentId);
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cash _that = (Cash)this.getType().cast(o);
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Cash {instrumentId=" + this.instrumentId + ", description=" + this.description + ", currency=" + this.currency + '}' + " " + super.toString();
        }
    }
}

