/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.accumulator;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.accumulator.meta.EquityForwardExpirationMeta;
import fpml.consolidated.eqd.EquityExpirationModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.Exercise;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityForwardExpiration", builder=EquityForwardExpirationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityForwardExpiration", model="fpml", builder=EquityForwardExpirationBuilderImpl.class, version="1.1.0")
public interface EquityForwardExpiration
extends Exercise {
    public static final EquityForwardExpirationMeta metaData = new EquityForwardExpirationMeta();

    public AdjustableOrRelativeDate getExpirationDate();

    public EquityExpirationModel getEquityExpirationModel();

    @Override
    public EquityForwardExpiration build();

    @Override
    public EquityForwardExpirationBuilder toBuilder();

    public static EquityForwardExpirationBuilder builder() {
        return new EquityForwardExpirationBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityForwardExpiration> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityForwardExpiration> getType() {
        return EquityForwardExpiration.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
    }

    public static class EquityForwardExpirationBuilderImpl
    extends Exercise.ExerciseBuilderImpl
    implements EquityForwardExpirationBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder expirationDate;
        protected EquityExpirationModel.EquityExpirationModelBuilder equityExpirationModel;

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.expirationDate != null ? this.expirationDate : (this.expirationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel() {
            EquityExpirationModel.EquityExpirationModelBuilder result = this.equityExpirationModel != null ? this.equityExpirationModel : (this.equityExpirationModel = EquityExpirationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityForwardExpirationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public EquityForwardExpirationBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityForwardExpirationBuilder setEquityExpirationModel(EquityExpirationModel _equityExpirationModel) {
            this.equityExpirationModel = _equityExpirationModel == null ? null : _equityExpirationModel.toBuilder();
            return this;
        }

        @Override
        public EquityForwardExpiration build() {
            return new EquityForwardExpirationImpl(this);
        }

        @Override
        public EquityForwardExpirationBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityForwardExpirationBuilder prune() {
            super.prune();
            if (this.expirationDate != null && !this.expirationDate.prune().hasData()) {
                this.expirationDate = null;
            }
            if (this.equityExpirationModel != null && !this.equityExpirationModel.prune().hasData()) {
                this.equityExpirationModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().hasData()) {
                return true;
            }
            return this.getEquityExpirationModel() != null && this.getEquityExpirationModel().hasData();
        }

        @Override
        public EquityForwardExpirationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityForwardExpirationBuilder o = (EquityForwardExpirationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationDate(), (RosettaModelObjectBuilder)o.getExpirationDate(), this::setExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityExpirationModel(), (RosettaModelObjectBuilder)o.getEquityExpirationModel(), this::setEquityExpirationModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityForwardExpiration _that = (EquityForwardExpiration)this.getType().cast(o);
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            return Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityForwardExpirationBuilder {expirationDate=" + this.expirationDate + ", equityExpirationModel=" + this.equityExpirationModel + '}' + " " + super.toString();
        }
    }

    public static interface EquityForwardExpirationBuilder
    extends EquityForwardExpiration,
    Exercise.ExerciseBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate();

        public EquityExpirationModel.EquityExpirationModelBuilder getOrCreateEquityExpirationModel();

        @Override
        public EquityExpirationModel.EquityExpirationModelBuilder getEquityExpirationModel();

        @Override
        public EquityForwardExpirationBuilder setId(String var1);

        public EquityForwardExpirationBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        public EquityForwardExpirationBuilder setEquityExpirationModel(EquityExpirationModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityExpirationModel"), processor, EquityExpirationModel.EquityExpirationModelBuilder.class, this.getEquityExpirationModel(), new AttributeMeta[0]);
        }

        @Override
        public EquityForwardExpirationBuilder prune();
    }

    public static class EquityForwardExpirationImpl
    extends Exercise.ExerciseImpl
    implements EquityForwardExpiration {
        private final AdjustableOrRelativeDate expirationDate;
        private final EquityExpirationModel equityExpirationModel;

        protected EquityForwardExpirationImpl(EquityForwardExpirationBuilder builder) {
            super(builder);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).map(f -> f.build()).orElse(null);
            this.equityExpirationModel = Optional.ofNullable(builder.getEquityExpirationModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expirationDate", isRequired=true)
        @RuneAttribute(value="expirationDate", isRequired=true)
        public AdjustableOrRelativeDate getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="equityExpirationModel", isRequired=true)
        @RuneAttribute(value="equityExpirationModel", isRequired=true)
        public EquityExpirationModel getEquityExpirationModel() {
            return this.equityExpirationModel;
        }

        @Override
        public EquityForwardExpiration build() {
            return this;
        }

        @Override
        public EquityForwardExpirationBuilder toBuilder() {
            EquityForwardExpirationBuilder builder = EquityForwardExpiration.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityForwardExpirationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getEquityExpirationModel()).ifPresent(builder::setEquityExpirationModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityForwardExpiration _that = (EquityForwardExpiration)this.getType().cast(o);
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            return Objects.equals(this.equityExpirationModel, _that.getEquityExpirationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.equityExpirationModel != null ? this.equityExpirationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityForwardExpiration {expirationDate=" + this.expirationDate + ", equityExpirationModel=" + this.equityExpirationModel + '}' + " " + super.toString();
        }
    }
}

