/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.SettlementPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SettlementPayoutBasket")
@ImplementedBy(value=Default.class)
public interface SettlementPayoutBasket
extends Validator<SettlementPayout> {
    public static final String NAME = "SettlementPayoutBasket";
    public static final String DEFINITION = "if underlier -> Observable -> Basket exists then (underlier -> Observable -> Basket -> basketConstituent extract Asset exists ) all = True";

    public static class NoOp
    implements SettlementPayoutBasket {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementPayout settlementPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SettlementPayoutBasket {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementPayout settlementPayout) {
            ComparisonResult result = this.executeDataRule(settlementPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SettlementPayoutBasket.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementPayout", (RosettaPath)path, (String)SettlementPayoutBasket.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SettlementPayoutBasket.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementPayout", (RosettaPath)path, (String)SettlementPayoutBasket.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SettlementPayout settlementPayout) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementPayout).map("getUnderlier", _settlementPayout -> _settlementPayout.getUnderlier()).map("getObservable", underlier -> underlier.getObservable()).map("Type coercion", referenceWithMetaObservable0 -> referenceWithMetaObservable0 == null ? null : referenceWithMetaObservable0.getValue()).map("getBasket", observable -> observable.getBasket())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)settlementPayout).map("getUnderlier", _settlementPayout -> _settlementPayout.getUnderlier()).map("getObservable", underlier -> underlier.getObservable()).map("Type coercion", referenceWithMetaObservable1 -> referenceWithMetaObservable1 == null ? null : referenceWithMetaObservable1.getValue()).map("getBasket", observable -> observable.getBasket()).mapC("getBasketConstituent", basket -> basket.getBasketConstituent()).mapItem(item -> ExpressionOperators.exists((Mapper)item.map("Type coercion", fieldWithMetaBasketConstituent -> fieldWithMetaBasketConstituent == null ? null : fieldWithMetaBasketConstituent.getValue()).map("getAsset", basketConstituent -> basketConstituent.getAsset())).asMapper()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

