/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProductChoice")
@ImplementedBy(value=Default.class)
public interface ProductChoice
extends Validator<Product> {
    public static final String NAME = "ProductChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements ProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Product product) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Product product) {
            ComparisonResult result = this.executeDataRule(product);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == ProductChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Product product) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)product), Arrays.asList("TransferableProduct", "NonTransferableProduct"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

