/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiverEnum;
import cdm.product.template.meta.StrikeMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Strike", builder=StrikeBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="Strike", model="cdm", builder=StrikeBuilderImpl.class, version="7.0.0-dev.52")
public interface Strike
extends RosettaModelObject,
GlobalKey {
    public static final StrikeMeta metaData = new StrikeMeta();

    public BigDecimal getStrikeRate();

    public PayerReceiverEnum getBuyer();

    public PayerReceiverEnum getSeller();

    public MetaFields getMeta();

    public Strike build();

    public StrikeBuilder toBuilder();

    public static StrikeBuilder builder() {
        return new StrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends Strike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Strike> getType() {
        return Strike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class StrikeBuilderImpl
    implements StrikeBuilder {
        protected BigDecimal strikeRate;
        protected PayerReceiverEnum buyer;
        protected PayerReceiverEnum seller;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public StrikeBuilder setStrikeRate(BigDecimal _strikeRate) {
            this.strikeRate = _strikeRate == null ? null : _strikeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public StrikeBuilder setBuyer(PayerReceiverEnum _buyer) {
            this.buyer = _buyer == null ? null : _buyer;
            return this;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public StrikeBuilder setSeller(PayerReceiverEnum _seller) {
            this.seller = _seller == null ? null : _seller;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public StrikeBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Strike build() {
            return new StrikeImpl(this);
        }

        @Override
        public StrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public StrikeBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrikeRate() != null) {
                return true;
            }
            if (this.getBuyer() != null) {
                return true;
            }
            return this.getSeller() != null;
        }

        public StrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StrikeBuilder o = (StrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getStrikeRate(), (Object)o.getStrikeRate(), this::setStrikeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBuyer(), (Object)o.getBuyer(), this::setBuyer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeller(), (Object)o.getSeller(), this::setSeller, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikeRate, _that.getStrikeRate())) {
                return false;
            }
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            if (!Objects.equals((Object)this.seller, (Object)_that.getSeller())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StrikeBuilder {strikeRate=" + this.strikeRate + ", buyer=" + (Object)((Object)this.buyer) + ", seller=" + (Object)((Object)this.seller) + ", meta=" + this.meta + '}';
        }
    }

    public static interface StrikeBuilder
    extends Strike,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public StrikeBuilder setStrikeRate(BigDecimal var1);

        public StrikeBuilder setBuyer(PayerReceiverEnum var1);

        public StrikeBuilder setSeller(PayerReceiverEnum var1);

        public StrikeBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public StrikeBuilder prune();
    }

    public static class StrikeImpl
    implements Strike {
        private final BigDecimal strikeRate;
        private final PayerReceiverEnum buyer;
        private final PayerReceiverEnum seller;
        private final MetaFields meta;

        protected StrikeImpl(StrikeBuilder builder) {
            this.strikeRate = builder.getStrikeRate();
            this.buyer = builder.getBuyer();
            this.seller = builder.getSeller();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strikeRate", isRequired=true)
        @RuneAttribute(value="strikeRate", isRequired=true)
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Strike build() {
            return this;
        }

        @Override
        public StrikeBuilder toBuilder() {
            StrikeBuilder builder = Strike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrikeBuilder builder) {
            Optional.ofNullable(this.getStrikeRate()).ifPresent(builder::setStrikeRate);
            Optional.ofNullable(this.getBuyer()).ifPresent(builder::setBuyer);
            Optional.ofNullable(this.getSeller()).ifPresent(builder::setSeller);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikeRate, _that.getStrikeRate())) {
                return false;
            }
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            if (!Objects.equals((Object)this.seller, (Object)_that.getSeller())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Strike {strikeRate=" + this.strikeRate + ", buyer=" + (Object)((Object)this.buyer) + ", seller=" + (Object)((Object)this.seller) + ", meta=" + this.meta + '}';
        }
    }
}

