/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.AssetPayout;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.SettlementPayout;
import cdm.product.template.meta.PayoutMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Payout", builder=PayoutBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="Payout", model="cdm", builder=PayoutBuilderImpl.class, version="7.0.0-dev.52")
public interface Payout
extends RosettaModelObject,
GlobalKey {
    public static final PayoutMeta metaData = new PayoutMeta();

    public AssetPayout getAssetPayout();

    public CommodityPayout getCommodityPayout();

    public CreditDefaultPayout getCreditDefaultPayout();

    public FixedPricePayout getFixedPricePayout();

    public InterestRatePayout getInterestRatePayout();

    public OptionPayout getOptionPayout();

    public PerformancePayout getPerformancePayout();

    public SettlementPayout getSettlementPayout();

    public MetaFields getMeta();

    public Payout build();

    public PayoutBuilder toBuilder();

    public static PayoutBuilder builder() {
        return new PayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends Payout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Payout> getType() {
        return Payout.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("AssetPayout"), processor, AssetPayout.class, this.getAssetPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("CommodityPayout"), processor, CommodityPayout.class, this.getCommodityPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("CreditDefaultPayout"), processor, CreditDefaultPayout.class, this.getCreditDefaultPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("FixedPricePayout"), processor, FixedPricePayout.class, this.getFixedPricePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("InterestRatePayout"), processor, InterestRatePayout.class, this.getInterestRatePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("OptionPayout"), processor, OptionPayout.class, this.getOptionPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("PerformancePayout"), processor, PerformancePayout.class, this.getPerformancePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("SettlementPayout"), processor, SettlementPayout.class, this.getSettlementPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PayoutBuilderImpl
    implements PayoutBuilder {
        protected AssetPayout.AssetPayoutBuilder assetPayout;
        protected CommodityPayout.CommodityPayoutBuilder commodityPayout;
        protected CreditDefaultPayout.CreditDefaultPayoutBuilder creditDefaultPayout;
        protected FixedPricePayout.FixedPricePayoutBuilder fixedPricePayout;
        protected InterestRatePayout.InterestRatePayoutBuilder interestRatePayout;
        protected OptionPayout.OptionPayoutBuilder optionPayout;
        protected PerformancePayout.PerformancePayoutBuilder performancePayout;
        protected SettlementPayout.SettlementPayoutBuilder settlementPayout;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="AssetPayout")
        @RuneAttribute(value="AssetPayout")
        public AssetPayout.AssetPayoutBuilder getAssetPayout() {
            return this.assetPayout;
        }

        @Override
        public AssetPayout.AssetPayoutBuilder getOrCreateAssetPayout() {
            AssetPayout.AssetPayoutBuilder result = this.assetPayout != null ? this.assetPayout : (this.assetPayout = AssetPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="CommodityPayout")
        @RuneAttribute(value="CommodityPayout")
        public CommodityPayout.CommodityPayoutBuilder getCommodityPayout() {
            return this.commodityPayout;
        }

        @Override
        public CommodityPayout.CommodityPayoutBuilder getOrCreateCommodityPayout() {
            CommodityPayout.CommodityPayoutBuilder result = this.commodityPayout != null ? this.commodityPayout : (this.commodityPayout = CommodityPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="CreditDefaultPayout")
        @RuneAttribute(value="CreditDefaultPayout")
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getCreditDefaultPayout() {
            return this.creditDefaultPayout;
        }

        @Override
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getOrCreateCreditDefaultPayout() {
            CreditDefaultPayout.CreditDefaultPayoutBuilder result = this.creditDefaultPayout != null ? this.creditDefaultPayout : (this.creditDefaultPayout = CreditDefaultPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="FixedPricePayout")
        @RuneAttribute(value="FixedPricePayout")
        public FixedPricePayout.FixedPricePayoutBuilder getFixedPricePayout() {
            return this.fixedPricePayout;
        }

        @Override
        public FixedPricePayout.FixedPricePayoutBuilder getOrCreateFixedPricePayout() {
            FixedPricePayout.FixedPricePayoutBuilder result = this.fixedPricePayout != null ? this.fixedPricePayout : (this.fixedPricePayout = FixedPricePayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="InterestRatePayout")
        @RuneAttribute(value="InterestRatePayout")
        public InterestRatePayout.InterestRatePayoutBuilder getInterestRatePayout() {
            return this.interestRatePayout;
        }

        @Override
        public InterestRatePayout.InterestRatePayoutBuilder getOrCreateInterestRatePayout() {
            InterestRatePayout.InterestRatePayoutBuilder result = this.interestRatePayout != null ? this.interestRatePayout : (this.interestRatePayout = InterestRatePayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="OptionPayout")
        @RuneAttribute(value="OptionPayout")
        public OptionPayout.OptionPayoutBuilder getOptionPayout() {
            return this.optionPayout;
        }

        @Override
        public OptionPayout.OptionPayoutBuilder getOrCreateOptionPayout() {
            OptionPayout.OptionPayoutBuilder result = this.optionPayout != null ? this.optionPayout : (this.optionPayout = OptionPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="PerformancePayout")
        @RuneAttribute(value="PerformancePayout")
        public PerformancePayout.PerformancePayoutBuilder getPerformancePayout() {
            return this.performancePayout;
        }

        @Override
        public PerformancePayout.PerformancePayoutBuilder getOrCreatePerformancePayout() {
            PerformancePayout.PerformancePayoutBuilder result = this.performancePayout != null ? this.performancePayout : (this.performancePayout = PerformancePayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="SettlementPayout")
        @RuneAttribute(value="SettlementPayout")
        public SettlementPayout.SettlementPayoutBuilder getSettlementPayout() {
            return this.settlementPayout;
        }

        @Override
        public SettlementPayout.SettlementPayoutBuilder getOrCreateSettlementPayout() {
            SettlementPayout.SettlementPayoutBuilder result = this.settlementPayout != null ? this.settlementPayout : (this.settlementPayout = SettlementPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="AssetPayout")
        @RuneAttribute(value="AssetPayout")
        public PayoutBuilder setAssetPayout(AssetPayout _assetPayout) {
            this.assetPayout = _assetPayout == null ? null : _assetPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="CommodityPayout")
        @RuneAttribute(value="CommodityPayout")
        public PayoutBuilder setCommodityPayout(CommodityPayout _commodityPayout) {
            this.commodityPayout = _commodityPayout == null ? null : _commodityPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="CreditDefaultPayout")
        @RuneAttribute(value="CreditDefaultPayout")
        public PayoutBuilder setCreditDefaultPayout(CreditDefaultPayout _creditDefaultPayout) {
            this.creditDefaultPayout = _creditDefaultPayout == null ? null : _creditDefaultPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="FixedPricePayout")
        @RuneAttribute(value="FixedPricePayout")
        public PayoutBuilder setFixedPricePayout(FixedPricePayout _fixedPricePayout) {
            this.fixedPricePayout = _fixedPricePayout == null ? null : _fixedPricePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="InterestRatePayout")
        @RuneAttribute(value="InterestRatePayout")
        public PayoutBuilder setInterestRatePayout(InterestRatePayout _interestRatePayout) {
            this.interestRatePayout = _interestRatePayout == null ? null : _interestRatePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="OptionPayout")
        @RuneAttribute(value="OptionPayout")
        public PayoutBuilder setOptionPayout(OptionPayout _optionPayout) {
            this.optionPayout = _optionPayout == null ? null : _optionPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="PerformancePayout")
        @RuneAttribute(value="PerformancePayout")
        public PayoutBuilder setPerformancePayout(PerformancePayout _performancePayout) {
            this.performancePayout = _performancePayout == null ? null : _performancePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="SettlementPayout")
        @RuneAttribute(value="SettlementPayout")
        public PayoutBuilder setSettlementPayout(SettlementPayout _settlementPayout) {
            this.settlementPayout = _settlementPayout == null ? null : _settlementPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PayoutBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Payout build() {
            return new PayoutImpl(this);
        }

        @Override
        public PayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public PayoutBuilder prune() {
            if (this.assetPayout != null && !this.assetPayout.prune().hasData()) {
                this.assetPayout = null;
            }
            if (this.commodityPayout != null && !this.commodityPayout.prune().hasData()) {
                this.commodityPayout = null;
            }
            if (this.creditDefaultPayout != null && !this.creditDefaultPayout.prune().hasData()) {
                this.creditDefaultPayout = null;
            }
            if (this.fixedPricePayout != null && !this.fixedPricePayout.prune().hasData()) {
                this.fixedPricePayout = null;
            }
            if (this.interestRatePayout != null && !this.interestRatePayout.prune().hasData()) {
                this.interestRatePayout = null;
            }
            if (this.optionPayout != null && !this.optionPayout.prune().hasData()) {
                this.optionPayout = null;
            }
            if (this.performancePayout != null && !this.performancePayout.prune().hasData()) {
                this.performancePayout = null;
            }
            if (this.settlementPayout != null && !this.settlementPayout.prune().hasData()) {
                this.settlementPayout = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAssetPayout() != null && this.getAssetPayout().hasData()) {
                return true;
            }
            if (this.getCommodityPayout() != null && this.getCommodityPayout().hasData()) {
                return true;
            }
            if (this.getCreditDefaultPayout() != null && this.getCreditDefaultPayout().hasData()) {
                return true;
            }
            if (this.getFixedPricePayout() != null && this.getFixedPricePayout().hasData()) {
                return true;
            }
            if (this.getInterestRatePayout() != null && this.getInterestRatePayout().hasData()) {
                return true;
            }
            if (this.getOptionPayout() != null && this.getOptionPayout().hasData()) {
                return true;
            }
            if (this.getPerformancePayout() != null && this.getPerformancePayout().hasData()) {
                return true;
            }
            return this.getSettlementPayout() != null && this.getSettlementPayout().hasData();
        }

        public PayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PayoutBuilder o = (PayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssetPayout(), (RosettaModelObjectBuilder)o.getAssetPayout(), this::setAssetPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityPayout(), (RosettaModelObjectBuilder)o.getCommodityPayout(), this::setCommodityPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditDefaultPayout(), (RosettaModelObjectBuilder)o.getCreditDefaultPayout(), this::setCreditDefaultPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPricePayout(), (RosettaModelObjectBuilder)o.getFixedPricePayout(), this::setFixedPricePayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestRatePayout(), (RosettaModelObjectBuilder)o.getInterestRatePayout(), this::setInterestRatePayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionPayout(), (RosettaModelObjectBuilder)o.getOptionPayout(), this::setOptionPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPerformancePayout(), (RosettaModelObjectBuilder)o.getPerformancePayout(), this::setPerformancePayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPayout(), (RosettaModelObjectBuilder)o.getSettlementPayout(), this::setSettlementPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Payout _that = this.getType().cast(o);
            if (!Objects.equals(this.assetPayout, _that.getAssetPayout())) {
                return false;
            }
            if (!Objects.equals(this.commodityPayout, _that.getCommodityPayout())) {
                return false;
            }
            if (!Objects.equals(this.creditDefaultPayout, _that.getCreditDefaultPayout())) {
                return false;
            }
            if (!Objects.equals(this.fixedPricePayout, _that.getFixedPricePayout())) {
                return false;
            }
            if (!Objects.equals(this.interestRatePayout, _that.getInterestRatePayout())) {
                return false;
            }
            if (!Objects.equals(this.optionPayout, _that.getOptionPayout())) {
                return false;
            }
            if (!Objects.equals(this.performancePayout, _that.getPerformancePayout())) {
                return false;
            }
            if (!Objects.equals(this.settlementPayout, _that.getSettlementPayout())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetPayout != null ? this.assetPayout.hashCode() : 0);
            _result = 31 * _result + (this.commodityPayout != null ? this.commodityPayout.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultPayout != null ? this.creditDefaultPayout.hashCode() : 0);
            _result = 31 * _result + (this.fixedPricePayout != null ? this.fixedPricePayout.hashCode() : 0);
            _result = 31 * _result + (this.interestRatePayout != null ? this.interestRatePayout.hashCode() : 0);
            _result = 31 * _result + (this.optionPayout != null ? this.optionPayout.hashCode() : 0);
            _result = 31 * _result + (this.performancePayout != null ? this.performancePayout.hashCode() : 0);
            _result = 31 * _result + (this.settlementPayout != null ? this.settlementPayout.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PayoutBuilder {AssetPayout=" + this.assetPayout + ", CommodityPayout=" + this.commodityPayout + ", CreditDefaultPayout=" + this.creditDefaultPayout + ", FixedPricePayout=" + this.fixedPricePayout + ", InterestRatePayout=" + this.interestRatePayout + ", OptionPayout=" + this.optionPayout + ", PerformancePayout=" + this.performancePayout + ", SettlementPayout=" + this.settlementPayout + ", meta=" + this.meta + '}';
        }
    }

    public static interface PayoutBuilder
    extends Payout,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AssetPayout.AssetPayoutBuilder getOrCreateAssetPayout();

        @Override
        public AssetPayout.AssetPayoutBuilder getAssetPayout();

        public CommodityPayout.CommodityPayoutBuilder getOrCreateCommodityPayout();

        @Override
        public CommodityPayout.CommodityPayoutBuilder getCommodityPayout();

        public CreditDefaultPayout.CreditDefaultPayoutBuilder getOrCreateCreditDefaultPayout();

        @Override
        public CreditDefaultPayout.CreditDefaultPayoutBuilder getCreditDefaultPayout();

        public FixedPricePayout.FixedPricePayoutBuilder getOrCreateFixedPricePayout();

        @Override
        public FixedPricePayout.FixedPricePayoutBuilder getFixedPricePayout();

        public InterestRatePayout.InterestRatePayoutBuilder getOrCreateInterestRatePayout();

        @Override
        public InterestRatePayout.InterestRatePayoutBuilder getInterestRatePayout();

        public OptionPayout.OptionPayoutBuilder getOrCreateOptionPayout();

        @Override
        public OptionPayout.OptionPayoutBuilder getOptionPayout();

        public PerformancePayout.PerformancePayoutBuilder getOrCreatePerformancePayout();

        @Override
        public PerformancePayout.PerformancePayoutBuilder getPerformancePayout();

        public SettlementPayout.SettlementPayoutBuilder getOrCreateSettlementPayout();

        @Override
        public SettlementPayout.SettlementPayoutBuilder getSettlementPayout();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public PayoutBuilder setAssetPayout(AssetPayout var1);

        public PayoutBuilder setCommodityPayout(CommodityPayout var1);

        public PayoutBuilder setCreditDefaultPayout(CreditDefaultPayout var1);

        public PayoutBuilder setFixedPricePayout(FixedPricePayout var1);

        public PayoutBuilder setInterestRatePayout(InterestRatePayout var1);

        public PayoutBuilder setOptionPayout(OptionPayout var1);

        public PayoutBuilder setPerformancePayout(PerformancePayout var1);

        public PayoutBuilder setSettlementPayout(SettlementPayout var1);

        public PayoutBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("AssetPayout"), processor, AssetPayout.AssetPayoutBuilder.class, this.getAssetPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("CommodityPayout"), processor, CommodityPayout.CommodityPayoutBuilder.class, this.getCommodityPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("CreditDefaultPayout"), processor, CreditDefaultPayout.CreditDefaultPayoutBuilder.class, this.getCreditDefaultPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("FixedPricePayout"), processor, FixedPricePayout.FixedPricePayoutBuilder.class, this.getFixedPricePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("InterestRatePayout"), processor, InterestRatePayout.InterestRatePayoutBuilder.class, this.getInterestRatePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("OptionPayout"), processor, OptionPayout.OptionPayoutBuilder.class, this.getOptionPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("PerformancePayout"), processor, PerformancePayout.PerformancePayoutBuilder.class, this.getPerformancePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("SettlementPayout"), processor, SettlementPayout.SettlementPayoutBuilder.class, this.getSettlementPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public PayoutBuilder prune();
    }

    public static class PayoutImpl
    implements Payout {
        private final AssetPayout assetPayout;
        private final CommodityPayout commodityPayout;
        private final CreditDefaultPayout creditDefaultPayout;
        private final FixedPricePayout fixedPricePayout;
        private final InterestRatePayout interestRatePayout;
        private final OptionPayout optionPayout;
        private final PerformancePayout performancePayout;
        private final SettlementPayout settlementPayout;
        private final MetaFields meta;

        protected PayoutImpl(PayoutBuilder builder) {
            this.assetPayout = Optional.ofNullable(builder.getAssetPayout()).map(f -> f.build()).orElse(null);
            this.commodityPayout = Optional.ofNullable(builder.getCommodityPayout()).map(f -> f.build()).orElse(null);
            this.creditDefaultPayout = Optional.ofNullable(builder.getCreditDefaultPayout()).map(f -> f.build()).orElse(null);
            this.fixedPricePayout = Optional.ofNullable(builder.getFixedPricePayout()).map(f -> f.build()).orElse(null);
            this.interestRatePayout = Optional.ofNullable(builder.getInterestRatePayout()).map(f -> f.build()).orElse(null);
            this.optionPayout = Optional.ofNullable(builder.getOptionPayout()).map(f -> f.build()).orElse(null);
            this.performancePayout = Optional.ofNullable(builder.getPerformancePayout()).map(f -> f.build()).orElse(null);
            this.settlementPayout = Optional.ofNullable(builder.getSettlementPayout()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="AssetPayout")
        @RuneAttribute(value="AssetPayout")
        public AssetPayout getAssetPayout() {
            return this.assetPayout;
        }

        @Override
        @RosettaAttribute(value="CommodityPayout")
        @RuneAttribute(value="CommodityPayout")
        public CommodityPayout getCommodityPayout() {
            return this.commodityPayout;
        }

        @Override
        @RosettaAttribute(value="CreditDefaultPayout")
        @RuneAttribute(value="CreditDefaultPayout")
        public CreditDefaultPayout getCreditDefaultPayout() {
            return this.creditDefaultPayout;
        }

        @Override
        @RosettaAttribute(value="FixedPricePayout")
        @RuneAttribute(value="FixedPricePayout")
        public FixedPricePayout getFixedPricePayout() {
            return this.fixedPricePayout;
        }

        @Override
        @RosettaAttribute(value="InterestRatePayout")
        @RuneAttribute(value="InterestRatePayout")
        public InterestRatePayout getInterestRatePayout() {
            return this.interestRatePayout;
        }

        @Override
        @RosettaAttribute(value="OptionPayout")
        @RuneAttribute(value="OptionPayout")
        public OptionPayout getOptionPayout() {
            return this.optionPayout;
        }

        @Override
        @RosettaAttribute(value="PerformancePayout")
        @RuneAttribute(value="PerformancePayout")
        public PerformancePayout getPerformancePayout() {
            return this.performancePayout;
        }

        @Override
        @RosettaAttribute(value="SettlementPayout")
        @RuneAttribute(value="SettlementPayout")
        public SettlementPayout getSettlementPayout() {
            return this.settlementPayout;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Payout build() {
            return this;
        }

        @Override
        public PayoutBuilder toBuilder() {
            PayoutBuilder builder = Payout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PayoutBuilder builder) {
            Optional.ofNullable(this.getAssetPayout()).ifPresent(builder::setAssetPayout);
            Optional.ofNullable(this.getCommodityPayout()).ifPresent(builder::setCommodityPayout);
            Optional.ofNullable(this.getCreditDefaultPayout()).ifPresent(builder::setCreditDefaultPayout);
            Optional.ofNullable(this.getFixedPricePayout()).ifPresent(builder::setFixedPricePayout);
            Optional.ofNullable(this.getInterestRatePayout()).ifPresent(builder::setInterestRatePayout);
            Optional.ofNullable(this.getOptionPayout()).ifPresent(builder::setOptionPayout);
            Optional.ofNullable(this.getPerformancePayout()).ifPresent(builder::setPerformancePayout);
            Optional.ofNullable(this.getSettlementPayout()).ifPresent(builder::setSettlementPayout);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Payout _that = this.getType().cast(o);
            if (!Objects.equals(this.assetPayout, _that.getAssetPayout())) {
                return false;
            }
            if (!Objects.equals(this.commodityPayout, _that.getCommodityPayout())) {
                return false;
            }
            if (!Objects.equals(this.creditDefaultPayout, _that.getCreditDefaultPayout())) {
                return false;
            }
            if (!Objects.equals(this.fixedPricePayout, _that.getFixedPricePayout())) {
                return false;
            }
            if (!Objects.equals(this.interestRatePayout, _that.getInterestRatePayout())) {
                return false;
            }
            if (!Objects.equals(this.optionPayout, _that.getOptionPayout())) {
                return false;
            }
            if (!Objects.equals(this.performancePayout, _that.getPerformancePayout())) {
                return false;
            }
            if (!Objects.equals(this.settlementPayout, _that.getSettlementPayout())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetPayout != null ? this.assetPayout.hashCode() : 0);
            _result = 31 * _result + (this.commodityPayout != null ? this.commodityPayout.hashCode() : 0);
            _result = 31 * _result + (this.creditDefaultPayout != null ? this.creditDefaultPayout.hashCode() : 0);
            _result = 31 * _result + (this.fixedPricePayout != null ? this.fixedPricePayout.hashCode() : 0);
            _result = 31 * _result + (this.interestRatePayout != null ? this.interestRatePayout.hashCode() : 0);
            _result = 31 * _result + (this.optionPayout != null ? this.optionPayout.hashCode() : 0);
            _result = 31 * _result + (this.performancePayout != null ? this.performancePayout.hashCode() : 0);
            _result = 31 * _result + (this.settlementPayout != null ? this.settlementPayout.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Payout {AssetPayout=" + this.assetPayout + ", CommodityPayout=" + this.commodityPayout + ", CreditDefaultPayout=" + this.creditDefaultPayout + ", FixedPricePayout=" + this.fixedPricePayout + ", InterestRatePayout=" + this.interestRatePayout + ", OptionPayout=" + this.optionPayout + ", PerformancePayout=" + this.performancePayout + ", SettlementPayout=" + this.settlementPayout + ", meta=" + this.meta + '}';
        }
    }
}

