/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="DeliveryMethodEnum")
public enum DeliveryMethodEnum {
    DELIVERY_VERSUS_PAYMENT("DeliveryVersusPayment", null),
    FREE_OF_PAYMENT("FreeOfPayment", null),
    PRE_DELIVERY("PreDelivery", null),
    PRE_PAYMENT("PrePayment", null);

    private static Map<String, DeliveryMethodEnum> values;
    private final String rosettaName;
    private final String displayName;

    private DeliveryMethodEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static DeliveryMethodEnum fromDisplayName(String name) {
        DeliveryMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, DeliveryMethodEnum> map = new ConcurrentHashMap<String, DeliveryMethodEnum>();
        for (DeliveryMethodEnum instance : DeliveryMethodEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

