/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.DayTypeEnum;
import cdm.product.asset.DayDistributionEnum;
import cdm.product.common.schedule.Lag;
import cdm.product.common.schedule.meta.ParametricDatesMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ParametricDates", builder=ParametricDatesBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ParametricDates", model="cdm", builder=ParametricDatesBuilderImpl.class, version="7.0.0-dev.52")
public interface ParametricDates
extends RosettaModelObject {
    public static final ParametricDatesMeta metaData = new ParametricDatesMeta();

    public DayTypeEnum getDayType();

    public DayDistributionEnum getDayDistribution();

    public List<DayOfWeekEnum> getDayOfWeek();

    public BigDecimal getDayFrequency();

    public Lag getLag();

    public BusinessCenters getBusinessCenters();

    public ParametricDates build();

    public ParametricDatesBuilder toBuilder();

    public static ParametricDatesBuilder builder() {
        return new ParametricDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends ParametricDates> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ParametricDates> getType() {
        return ParametricDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayDistribution"), DayDistributionEnum.class, (Object)this.getDayDistribution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayFrequency"), BigDecimal.class, (Object)this.getDayFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lag"), processor, Lag.class, this.getLag(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.class, this.getBusinessCenters(), new AttributeMeta[0]);
    }

    public static class ParametricDatesBuilderImpl
    implements ParametricDatesBuilder {
        protected DayTypeEnum dayType;
        protected DayDistributionEnum dayDistribution;
        protected List<DayOfWeekEnum> dayOfWeek = new ArrayList<DayOfWeekEnum>();
        protected BigDecimal dayFrequency;
        protected Lag.LagBuilder lag;
        protected BusinessCenters.BusinessCentersBuilder businessCenters;

        @Override
        @RosettaAttribute(value="dayType", isRequired=true)
        @RuneAttribute(value="dayType", isRequired=true)
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        @RosettaAttribute(value="dayDistribution")
        @RuneAttribute(value="dayDistribution")
        public DayDistributionEnum getDayDistribution() {
            return this.dayDistribution;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="dayFrequency")
        @RuneAttribute(value="dayFrequency")
        public BigDecimal getDayFrequency() {
            return this.dayFrequency;
        }

        @Override
        @RosettaAttribute(value="lag")
        @RuneAttribute(value="lag")
        public Lag.LagBuilder getLag() {
            return this.lag;
        }

        @Override
        public Lag.LagBuilder getOrCreateLag() {
            Lag.LagBuilder result = this.lag != null ? this.lag : (this.lag = Lag.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessCenters", isRequired=true)
        @RuneAttribute(value="businessCenters", isRequired=true)
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters() {
            BusinessCenters.BusinessCentersBuilder result = this.businessCenters != null ? this.businessCenters : (this.businessCenters = BusinessCenters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayType", isRequired=true)
        @RuneAttribute(value="dayType", isRequired=true)
        public ParametricDatesBuilder setDayType(DayTypeEnum _dayType) {
            this.dayType = _dayType == null ? null : _dayType;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayDistribution")
        @RuneAttribute(value="dayDistribution")
        public ParametricDatesBuilder setDayDistribution(DayDistributionEnum _dayDistribution) {
            this.dayDistribution = _dayDistribution == null ? null : _dayDistribution;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum _dayOfWeek) {
            if (_dayOfWeek != null) {
                this.dayOfWeek.add(_dayOfWeek);
            }
            return this;
        }

        @Override
        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum _dayOfWeek, int idx) {
            this.getIndex(this.dayOfWeek, idx, () -> _dayOfWeek);
            return this;
        }

        @Override
        public ParametricDatesBuilder addDayOfWeek(List<DayOfWeekEnum> dayOfWeeks) {
            if (dayOfWeeks != null) {
                for (DayOfWeekEnum toAdd : dayOfWeeks) {
                    this.dayOfWeek.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dayOfWeek")
        public ParametricDatesBuilder setDayOfWeek(List<DayOfWeekEnum> dayOfWeeks) {
            this.dayOfWeek = dayOfWeeks == null ? new ArrayList<DayOfWeekEnum>() : (List)dayOfWeeks.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dayFrequency")
        @RuneAttribute(value="dayFrequency")
        public ParametricDatesBuilder setDayFrequency(BigDecimal _dayFrequency) {
            this.dayFrequency = _dayFrequency == null ? null : _dayFrequency;
            return this;
        }

        @Override
        @RosettaAttribute(value="lag")
        @RuneAttribute(value="lag")
        public ParametricDatesBuilder setLag(Lag _lag) {
            this.lag = _lag == null ? null : _lag.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenters", isRequired=true)
        @RuneAttribute(value="businessCenters", isRequired=true)
        public ParametricDatesBuilder setBusinessCenters(BusinessCenters _businessCenters) {
            this.businessCenters = _businessCenters == null ? null : _businessCenters.toBuilder();
            return this;
        }

        @Override
        public ParametricDates build() {
            return new ParametricDatesImpl(this);
        }

        @Override
        public ParametricDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public ParametricDatesBuilder prune() {
            if (this.lag != null && !this.lag.prune().hasData()) {
                this.lag = null;
            }
            if (this.businessCenters != null && !this.businessCenters.prune().hasData()) {
                this.businessCenters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDayType() != null) {
                return true;
            }
            if (this.getDayDistribution() != null) {
                return true;
            }
            if (this.getDayOfWeek() != null && !this.getDayOfWeek().isEmpty()) {
                return true;
            }
            if (this.getDayFrequency() != null) {
                return true;
            }
            if (this.getLag() != null && this.getLag().hasData()) {
                return true;
            }
            return this.getBusinessCenters() != null && this.getBusinessCenters().hasData();
        }

        public ParametricDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ParametricDatesBuilder o = (ParametricDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLag(), (RosettaModelObjectBuilder)o.getLag(), this::setLag);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenters(), (RosettaModelObjectBuilder)o.getBusinessCenters(), this::setBusinessCenters);
            merger.mergeBasic((Object)this.getDayType(), (Object)o.getDayType(), this::setDayType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayDistribution(), (Object)o.getDayDistribution(), this::setDayDistribution, new AttributeMeta[0]);
            merger.mergeBasic(this.getDayOfWeek(), o.getDayOfWeek(), this::addDayOfWeek);
            merger.mergeBasic((Object)this.getDayFrequency(), (Object)o.getDayFrequency(), this::setDayFrequency, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricDates _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayDistribution, (Object)_that.getDayDistribution())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.dayFrequency, _that.getDayFrequency())) {
                return false;
            }
            if (!Objects.equals(this.lag, _that.getLag())) {
                return false;
            }
            return Objects.equals(this.businessCenters, _that.getBusinessCenters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayDistribution != null ? ((Object)((Object)this.dayDistribution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayFrequency != null ? this.dayFrequency.hashCode() : 0);
            _result = 31 * _result + (this.lag != null ? this.lag.hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricDatesBuilder {dayType=" + (Object)((Object)this.dayType) + ", dayDistribution=" + (Object)((Object)this.dayDistribution) + ", dayOfWeek=" + this.dayOfWeek + ", dayFrequency=" + this.dayFrequency + ", lag=" + this.lag + ", businessCenters=" + this.businessCenters + '}';
        }
    }

    public static interface ParametricDatesBuilder
    extends ParametricDates,
    RosettaModelObjectBuilder {
        public Lag.LagBuilder getOrCreateLag();

        @Override
        public Lag.LagBuilder getLag();

        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters();

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters();

        public ParametricDatesBuilder setDayType(DayTypeEnum var1);

        public ParametricDatesBuilder setDayDistribution(DayDistributionEnum var1);

        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum var1);

        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum var1, int var2);

        public ParametricDatesBuilder addDayOfWeek(List<DayOfWeekEnum> var1);

        public ParametricDatesBuilder setDayOfWeek(List<DayOfWeekEnum> var1);

        public ParametricDatesBuilder setDayFrequency(BigDecimal var1);

        public ParametricDatesBuilder setLag(Lag var1);

        public ParametricDatesBuilder setBusinessCenters(BusinessCenters var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayDistribution"), DayDistributionEnum.class, (Object)this.getDayDistribution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayFrequency"), BigDecimal.class, (Object)this.getDayFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lag"), processor, Lag.LagBuilder.class, this.getLag(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getBusinessCenters(), new AttributeMeta[0]);
        }

        public ParametricDatesBuilder prune();
    }

    public static class ParametricDatesImpl
    implements ParametricDates {
        private final DayTypeEnum dayType;
        private final DayDistributionEnum dayDistribution;
        private final List<DayOfWeekEnum> dayOfWeek;
        private final BigDecimal dayFrequency;
        private final Lag lag;
        private final BusinessCenters businessCenters;

        protected ParametricDatesImpl(ParametricDatesBuilder builder) {
            this.dayType = builder.getDayType();
            this.dayDistribution = builder.getDayDistribution();
            this.dayOfWeek = Optional.ofNullable(builder.getDayOfWeek()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.dayFrequency = builder.getDayFrequency();
            this.lag = Optional.ofNullable(builder.getLag()).map(f -> f.build()).orElse(null);
            this.businessCenters = Optional.ofNullable(builder.getBusinessCenters()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dayType", isRequired=true)
        @RuneAttribute(value="dayType", isRequired=true)
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        @RosettaAttribute(value="dayDistribution")
        @RuneAttribute(value="dayDistribution")
        public DayDistributionEnum getDayDistribution() {
            return this.dayDistribution;
        }

        @Override
        @RosettaAttribute(value="dayOfWeek")
        @RuneAttribute(value="dayOfWeek")
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        @RosettaAttribute(value="dayFrequency")
        @RuneAttribute(value="dayFrequency")
        public BigDecimal getDayFrequency() {
            return this.dayFrequency;
        }

        @Override
        @RosettaAttribute(value="lag")
        @RuneAttribute(value="lag")
        public Lag getLag() {
            return this.lag;
        }

        @Override
        @RosettaAttribute(value="businessCenters", isRequired=true)
        @RuneAttribute(value="businessCenters", isRequired=true)
        public BusinessCenters getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public ParametricDates build() {
            return this;
        }

        @Override
        public ParametricDatesBuilder toBuilder() {
            ParametricDatesBuilder builder = ParametricDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ParametricDatesBuilder builder) {
            Optional.ofNullable(this.getDayType()).ifPresent(builder::setDayType);
            Optional.ofNullable(this.getDayDistribution()).ifPresent(builder::setDayDistribution);
            Optional.ofNullable(this.getDayOfWeek()).ifPresent(builder::setDayOfWeek);
            Optional.ofNullable(this.getDayFrequency()).ifPresent(builder::setDayFrequency);
            Optional.ofNullable(this.getLag()).ifPresent(builder::setLag);
            Optional.ofNullable(this.getBusinessCenters()).ifPresent(builder::setBusinessCenters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricDates _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayDistribution, (Object)_that.getDayDistribution())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals(this.dayFrequency, _that.getDayFrequency())) {
                return false;
            }
            if (!Objects.equals(this.lag, _that.getLag())) {
                return false;
            }
            return Objects.equals(this.businessCenters, _that.getBusinessCenters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayDistribution != null ? ((Object)((Object)this.dayDistribution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayFrequency != null ? this.dayFrequency.hashCode() : 0);
            _result = 31 * _result + (this.lag != null ? this.lag.hashCode() : 0);
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricDates {dayType=" + (Object)((Object)this.dayType) + ", dayDistribution=" + (Object)((Object)this.dayDistribution) + ", dayOfWeek=" + this.dayOfWeek + ", dayFrequency=" + this.dayFrequency + ", lag=" + this.lag + ", businessCenters=" + this.businessCenters + '}';
        }
    }
}

