/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessDayAdjustments;
import cdm.product.common.schedule.ObservationDate;
import cdm.product.common.schedule.meta.ObservationScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ObservationSchedule", builder=ObservationScheduleBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ObservationSchedule", model="cdm", builder=ObservationScheduleBuilderImpl.class, version="7.0.0-dev.52")
public interface ObservationSchedule
extends RosettaModelObject {
    public static final ObservationScheduleMeta metaData = new ObservationScheduleMeta();

    public List<? extends ObservationDate> getObservationDate();

    public BusinessDayAdjustments getDateAdjustments();

    public ObservationSchedule build();

    public ObservationScheduleBuilder toBuilder();

    public static ObservationScheduleBuilder builder() {
        return new ObservationScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends ObservationSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ObservationSchedule> getType() {
        return ObservationSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observationDate"), processor, ObservationDate.class, this.getObservationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
    }

    public static class ObservationScheduleBuilderImpl
    implements ObservationScheduleBuilder {
        protected List<ObservationDate.ObservationDateBuilder> observationDate = new ArrayList<ObservationDate.ObservationDateBuilder>();
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;

        @Override
        @RosettaAttribute(value="observationDate")
        @RuneAttribute(value="observationDate")
        public List<? extends ObservationDate.ObservationDateBuilder> getObservationDate() {
            return this.observationDate;
        }

        @Override
        public ObservationDate.ObservationDateBuilder getOrCreateObservationDate(int index) {
            if (this.observationDate == null) {
                this.observationDate = new ArrayList<ObservationDate.ObservationDateBuilder>();
            }
            return (ObservationDate.ObservationDateBuilder)this.getIndex(this.observationDate, index, () -> {
                ObservationDate.ObservationDateBuilder newObservationDate = ObservationDate.builder();
                return newObservationDate;
            });
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationDate")
        @RuneAttribute(value="observationDate")
        public ObservationScheduleBuilder addObservationDate(ObservationDate _observationDate) {
            if (_observationDate != null) {
                this.observationDate.add(_observationDate.toBuilder());
            }
            return this;
        }

        @Override
        public ObservationScheduleBuilder addObservationDate(ObservationDate _observationDate, int idx) {
            this.getIndex(this.observationDate, idx, () -> _observationDate.toBuilder());
            return this;
        }

        @Override
        public ObservationScheduleBuilder addObservationDate(List<? extends ObservationDate> observationDates) {
            if (observationDates != null) {
                for (ObservationDate observationDate : observationDates) {
                    this.observationDate.add(observationDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationDate")
        public ObservationScheduleBuilder setObservationDate(List<? extends ObservationDate> observationDates) {
            this.observationDate = observationDates == null ? new ArrayList<ObservationDate.ObservationDateBuilder>() : (List)observationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public ObservationScheduleBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        public ObservationSchedule build() {
            return new ObservationScheduleImpl(this);
        }

        @Override
        public ObservationScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationScheduleBuilder prune() {
            this.observationDate = this.observationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservationDate() != null && this.getObservationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDateAdjustments() != null && this.getDateAdjustments().hasData();
        }

        public ObservationScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationScheduleBuilder o = (ObservationScheduleBuilder)other;
            merger.mergeRosetta(this.getObservationDate(), o.getObservationDate(), this::getOrCreateObservationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSchedule _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            return Objects.equals(this.dateAdjustments, _that.getDateAdjustments());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationScheduleBuilder {observationDate=" + this.observationDate + ", dateAdjustments=" + this.dateAdjustments + '}';
        }
    }

    public static interface ObservationScheduleBuilder
    extends ObservationSchedule,
    RosettaModelObjectBuilder {
        public ObservationDate.ObservationDateBuilder getOrCreateObservationDate(int var1);

        public List<? extends ObservationDate.ObservationDateBuilder> getObservationDate();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public ObservationScheduleBuilder addObservationDate(ObservationDate var1);

        public ObservationScheduleBuilder addObservationDate(ObservationDate var1, int var2);

        public ObservationScheduleBuilder addObservationDate(List<? extends ObservationDate> var1);

        public ObservationScheduleBuilder setObservationDate(List<? extends ObservationDate> var1);

        public ObservationScheduleBuilder setDateAdjustments(BusinessDayAdjustments var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observationDate"), processor, ObservationDate.ObservationDateBuilder.class, this.getObservationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
        }

        public ObservationScheduleBuilder prune();
    }

    public static class ObservationScheduleImpl
    implements ObservationSchedule {
        private final List<? extends ObservationDate> observationDate;
        private final BusinessDayAdjustments dateAdjustments;

        protected ObservationScheduleImpl(ObservationScheduleBuilder builder) {
            this.observationDate = Optional.ofNullable(builder.getObservationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observationDate")
        @RuneAttribute(value="observationDate")
        public List<? extends ObservationDate> getObservationDate() {
            return this.observationDate;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public ObservationSchedule build() {
            return this;
        }

        @Override
        public ObservationScheduleBuilder toBuilder() {
            ObservationScheduleBuilder builder = ObservationSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationScheduleBuilder builder) {
            Optional.ofNullable(this.getObservationDate()).ifPresent(builder::setObservationDate);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSchedule _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            return Objects.equals(this.dateAdjustments, _that.getDateAdjustments());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationSchedule {observationDate=" + this.observationDate + ", dateAdjustments=" + this.dateAdjustments + '}';
        }
    }
}

