/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.CollateralValuationTreatment;
import cdm.product.collateral.ConcentrationLimit;
import cdm.product.collateral.meta.CollateralTreatmentMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralTreatment", builder=CollateralTreatmentBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CollateralTreatment", model="cdm", builder=CollateralTreatmentBuilderImpl.class, version="7.0.0-dev.52")
public interface CollateralTreatment
extends RosettaModelObject {
    public static final CollateralTreatmentMeta metaData = new CollateralTreatmentMeta();

    public CollateralValuationTreatment getValuationTreatment();

    public List<? extends ConcentrationLimit> getConcentrationLimit();

    public Boolean getIsIncluded();

    public CollateralTreatment build();

    public CollateralTreatmentBuilder toBuilder();

    public static CollateralTreatmentBuilder builder() {
        return new CollateralTreatmentBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralTreatment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralTreatment> getType() {
        return CollateralTreatment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationTreatment"), processor, CollateralValuationTreatment.class, this.getValuationTreatment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("concentrationLimit"), processor, ConcentrationLimit.class, this.getConcentrationLimit(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isIncluded"), Boolean.class, (Object)this.getIsIncluded(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralTreatmentBuilderImpl
    implements CollateralTreatmentBuilder {
        protected CollateralValuationTreatment.CollateralValuationTreatmentBuilder valuationTreatment;
        protected List<ConcentrationLimit.ConcentrationLimitBuilder> concentrationLimit = new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>();
        protected Boolean isIncluded;

        @Override
        @RosettaAttribute(value="valuationTreatment")
        @RuneAttribute(value="valuationTreatment")
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getValuationTreatment() {
            return this.valuationTreatment;
        }

        @Override
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getOrCreateValuationTreatment() {
            CollateralValuationTreatment.CollateralValuationTreatmentBuilder result = this.valuationTreatment != null ? this.valuationTreatment : (this.valuationTreatment = CollateralValuationTreatment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="concentrationLimit")
        @RuneAttribute(value="concentrationLimit")
        public List<? extends ConcentrationLimit.ConcentrationLimitBuilder> getConcentrationLimit() {
            return this.concentrationLimit;
        }

        @Override
        public ConcentrationLimit.ConcentrationLimitBuilder getOrCreateConcentrationLimit(int index) {
            if (this.concentrationLimit == null) {
                this.concentrationLimit = new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>();
            }
            return (ConcentrationLimit.ConcentrationLimitBuilder)this.getIndex(this.concentrationLimit, index, () -> {
                ConcentrationLimit.ConcentrationLimitBuilder newConcentrationLimit = ConcentrationLimit.builder();
                return newConcentrationLimit;
            });
        }

        @Override
        @RosettaAttribute(value="isIncluded", isRequired=true)
        @RuneAttribute(value="isIncluded", isRequired=true)
        public Boolean getIsIncluded() {
            return this.isIncluded;
        }

        @Override
        @RosettaAttribute(value="valuationTreatment")
        @RuneAttribute(value="valuationTreatment")
        public CollateralTreatmentBuilder setValuationTreatment(CollateralValuationTreatment _valuationTreatment) {
            this.valuationTreatment = _valuationTreatment == null ? null : _valuationTreatment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="concentrationLimit")
        @RuneAttribute(value="concentrationLimit")
        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit _concentrationLimit) {
            if (_concentrationLimit != null) {
                this.concentrationLimit.add(_concentrationLimit.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit _concentrationLimit, int idx) {
            this.getIndex(this.concentrationLimit, idx, () -> _concentrationLimit.toBuilder());
            return this;
        }

        @Override
        public CollateralTreatmentBuilder addConcentrationLimit(List<? extends ConcentrationLimit> concentrationLimits) {
            if (concentrationLimits != null) {
                for (ConcentrationLimit concentrationLimit : concentrationLimits) {
                    this.concentrationLimit.add(concentrationLimit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="concentrationLimit")
        public CollateralTreatmentBuilder setConcentrationLimit(List<? extends ConcentrationLimit> concentrationLimits) {
            this.concentrationLimit = concentrationLimits == null ? new ArrayList<ConcentrationLimit.ConcentrationLimitBuilder>() : (List)concentrationLimits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isIncluded", isRequired=true)
        @RuneAttribute(value="isIncluded", isRequired=true)
        public CollateralTreatmentBuilder setIsIncluded(Boolean _isIncluded) {
            this.isIncluded = _isIncluded == null ? null : _isIncluded;
            return this;
        }

        @Override
        public CollateralTreatment build() {
            return new CollateralTreatmentImpl(this);
        }

        @Override
        public CollateralTreatmentBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralTreatmentBuilder prune() {
            if (this.valuationTreatment != null && !this.valuationTreatment.prune().hasData()) {
                this.valuationTreatment = null;
            }
            this.concentrationLimit = this.concentrationLimit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getValuationTreatment() != null && this.getValuationTreatment().hasData()) {
                return true;
            }
            if (this.getConcentrationLimit() != null && this.getConcentrationLimit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getIsIncluded() != null;
        }

        public CollateralTreatmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralTreatmentBuilder o = (CollateralTreatmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationTreatment(), (RosettaModelObjectBuilder)o.getValuationTreatment(), this::setValuationTreatment);
            merger.mergeRosetta(this.getConcentrationLimit(), o.getConcentrationLimit(), this::getOrCreateConcentrationLimit);
            merger.mergeBasic((Object)this.getIsIncluded(), (Object)o.getIsIncluded(), this::setIsIncluded, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralTreatment _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationTreatment, _that.getValuationTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.concentrationLimit, _that.getConcentrationLimit())) {
                return false;
            }
            return Objects.equals(this.isIncluded, _that.getIsIncluded());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationTreatment != null ? this.valuationTreatment.hashCode() : 0);
            _result = 31 * _result + (this.concentrationLimit != null ? this.concentrationLimit.hashCode() : 0);
            _result = 31 * _result + (this.isIncluded != null ? this.isIncluded.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralTreatmentBuilder {valuationTreatment=" + this.valuationTreatment + ", concentrationLimit=" + this.concentrationLimit + ", isIncluded=" + this.isIncluded + '}';
        }
    }

    public static interface CollateralTreatmentBuilder
    extends CollateralTreatment,
    RosettaModelObjectBuilder {
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getOrCreateValuationTreatment();

        @Override
        public CollateralValuationTreatment.CollateralValuationTreatmentBuilder getValuationTreatment();

        public ConcentrationLimit.ConcentrationLimitBuilder getOrCreateConcentrationLimit(int var1);

        public List<? extends ConcentrationLimit.ConcentrationLimitBuilder> getConcentrationLimit();

        public CollateralTreatmentBuilder setValuationTreatment(CollateralValuationTreatment var1);

        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit var1);

        public CollateralTreatmentBuilder addConcentrationLimit(ConcentrationLimit var1, int var2);

        public CollateralTreatmentBuilder addConcentrationLimit(List<? extends ConcentrationLimit> var1);

        public CollateralTreatmentBuilder setConcentrationLimit(List<? extends ConcentrationLimit> var1);

        public CollateralTreatmentBuilder setIsIncluded(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationTreatment"), processor, CollateralValuationTreatment.CollateralValuationTreatmentBuilder.class, this.getValuationTreatment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("concentrationLimit"), processor, ConcentrationLimit.ConcentrationLimitBuilder.class, this.getConcentrationLimit(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isIncluded"), Boolean.class, (Object)this.getIsIncluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralTreatmentBuilder prune();
    }

    public static class CollateralTreatmentImpl
    implements CollateralTreatment {
        private final CollateralValuationTreatment valuationTreatment;
        private final List<? extends ConcentrationLimit> concentrationLimit;
        private final Boolean isIncluded;

        protected CollateralTreatmentImpl(CollateralTreatmentBuilder builder) {
            this.valuationTreatment = Optional.ofNullable(builder.getValuationTreatment()).map(f -> f.build()).orElse(null);
            this.concentrationLimit = Optional.ofNullable(builder.getConcentrationLimit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.isIncluded = builder.getIsIncluded();
        }

        @Override
        @RosettaAttribute(value="valuationTreatment")
        @RuneAttribute(value="valuationTreatment")
        public CollateralValuationTreatment getValuationTreatment() {
            return this.valuationTreatment;
        }

        @Override
        @RosettaAttribute(value="concentrationLimit")
        @RuneAttribute(value="concentrationLimit")
        public List<? extends ConcentrationLimit> getConcentrationLimit() {
            return this.concentrationLimit;
        }

        @Override
        @RosettaAttribute(value="isIncluded", isRequired=true)
        @RuneAttribute(value="isIncluded", isRequired=true)
        public Boolean getIsIncluded() {
            return this.isIncluded;
        }

        @Override
        public CollateralTreatment build() {
            return this;
        }

        @Override
        public CollateralTreatmentBuilder toBuilder() {
            CollateralTreatmentBuilder builder = CollateralTreatment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralTreatmentBuilder builder) {
            Optional.ofNullable(this.getValuationTreatment()).ifPresent(builder::setValuationTreatment);
            Optional.ofNullable(this.getConcentrationLimit()).ifPresent(builder::setConcentrationLimit);
            Optional.ofNullable(this.getIsIncluded()).ifPresent(builder::setIsIncluded);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralTreatment _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationTreatment, _that.getValuationTreatment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.concentrationLimit, _that.getConcentrationLimit())) {
                return false;
            }
            return Objects.equals(this.isIncluded, _that.getIsIncluded());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationTreatment != null ? this.valuationTreatment.hashCode() : 0);
            _result = 31 * _result + (this.concentrationLimit != null ? this.concentrationLimit.hashCode() : 0);
            _result = 31 * _result + (this.isIncluded != null ? this.isIncluded.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralTreatment {valuationTreatment=" + this.valuationTreatment + ", concentrationLimit=" + this.concentrationLimit + ", isIncluded=" + this.isIncluded + '}';
        }
    }
}

