/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.common.functions;

import cdm.base.datetime.TimeZone;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.observable.common.TimeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveTimeZoneFromTimeTypeDefault.class)
public abstract class ResolveTimeZoneFromTimeType
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TimeZone evaluate(AssetIdentifier assetIdentifier, TimeTypeEnum timeType, DeterminationMethodEnum determinationMethod) {
        TimeZone time;
        TimeZone.TimeZoneBuilder timeBuilder = this.doEvaluate(assetIdentifier, timeType, determinationMethod);
        if (timeBuilder == null) {
            time = null;
        } else {
            time = timeBuilder.build();
            this.objectValidator.validate(TimeZone.class, (RosettaModelObject)time);
        }
        return time;
    }

    protected abstract TimeZone.TimeZoneBuilder doEvaluate(AssetIdentifier var1, TimeTypeEnum var2, DeterminationMethodEnum var3);

    public static class ResolveTimeZoneFromTimeTypeDefault
    extends ResolveTimeZoneFromTimeType {
        @Override
        protected TimeZone.TimeZoneBuilder doEvaluate(AssetIdentifier assetIdentifier, TimeTypeEnum timeType, DeterminationMethodEnum determinationMethod) {
            TimeZone.TimeZoneBuilder time = TimeZone.builder();
            return this.assignOutput(time, assetIdentifier, timeType, determinationMethod);
        }

        protected TimeZone.TimeZoneBuilder assignOutput(TimeZone.TimeZoneBuilder time, AssetIdentifier assetIdentifier, TimeTypeEnum timeType, DeterminationMethodEnum determinationMethod) {
            return Optional.ofNullable(time).map(o -> o.prune()).orElse(null);
        }
    }
}

