/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.observable.asset.InterpolationMethodEnum;
import cdm.observable.asset.QuotationSideEnum;
import cdm.observable.asset.SwapCurveValuation;
import cdm.observable.asset.meta.MakeWholeAmountMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MakeWholeAmount", builder=MakeWholeAmountBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="MakeWholeAmount", model="cdm", builder=MakeWholeAmountBuilderImpl.class, version="7.0.0-dev.52")
public interface MakeWholeAmount
extends SwapCurveValuation {
    public static final MakeWholeAmountMeta metaData = new MakeWholeAmountMeta();

    public InterpolationMethodEnum getInterpolationMethod();

    public FieldWithMetaDate getEarlyCallDate();

    @Override
    public MakeWholeAmount build();

    @Override
    public MakeWholeAmountBuilder toBuilder();

    public static MakeWholeAmountBuilder builder() {
        return new MakeWholeAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends MakeWholeAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MakeWholeAmount> getType() {
        return MakeWholeAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interpolationMethod"), InterpolationMethodEnum.class, (Object)this.getInterpolationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyCallDate"), processor, FieldWithMetaDate.class, this.getEarlyCallDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
    }

    public static class MakeWholeAmountBuilderImpl
    extends SwapCurveValuation.SwapCurveValuationBuilderImpl
    implements MakeWholeAmountBuilder {
        protected InterpolationMethodEnum interpolationMethod;
        protected FieldWithMetaDate.FieldWithMetaDateBuilder earlyCallDate;

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate", isRequired=true)
        @RuneAttribute(value="earlyCallDate", isRequired=true)
        public FieldWithMetaDate.FieldWithMetaDateBuilder getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateEarlyCallDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.earlyCallDate != null ? this.earlyCallDate : (this.earlyCallDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public MakeWholeAmountBuilder setFloatingRateIndex(FloatingRateIndexEnum _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor")
        @RuneAttribute(value="indexTenor")
        public MakeWholeAmountBuilder setIndexTenor(Period _indexTenor) {
            this.indexTenor = _indexTenor == null ? null : _indexTenor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spread", isRequired=true)
        @RuneAttribute(value="spread", isRequired=true)
        public MakeWholeAmountBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public MakeWholeAmountBuilder setSide(QuotationSideEnum _side) {
            this.side = _side == null ? null : _side;
            return this;
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethodEnum _interpolationMethod) {
            this.interpolationMethod = _interpolationMethod == null ? null : _interpolationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate", isRequired=true)
        @RuneAttribute(value="earlyCallDate", isRequired=true)
        public MakeWholeAmountBuilder setEarlyCallDate(FieldWithMetaDate _earlyCallDate) {
            this.earlyCallDate = _earlyCallDate == null ? null : _earlyCallDate.toBuilder();
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setEarlyCallDateValue(Date _earlyCallDate) {
            this.getOrCreateEarlyCallDate().setValue(_earlyCallDate);
            return this;
        }

        @Override
        public MakeWholeAmount build() {
            return new MakeWholeAmountImpl(this);
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder prune() {
            super.prune();
            if (this.earlyCallDate != null && !this.earlyCallDate.prune().hasData()) {
                this.earlyCallDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInterpolationMethod() != null) {
                return true;
            }
            return this.getEarlyCallDate() != null;
        }

        @Override
        public MakeWholeAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MakeWholeAmountBuilder o = (MakeWholeAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyCallDate(), (RosettaModelObjectBuilder)o.getEarlyCallDate(), this::setEarlyCallDate);
            merger.mergeBasic((Object)this.getInterpolationMethod(), (Object)o.getInterpolationMethod(), this::setInterpolationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals((Object)this.interpolationMethod, (Object)_that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.earlyCallDate, _that.getEarlyCallDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interpolationMethod != null ? ((Object)((Object)this.interpolationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmountBuilder {interpolationMethod=" + (Object)((Object)this.interpolationMethod) + ", earlyCallDate=" + this.earlyCallDate + '}' + " " + super.toString();
        }
    }

    public static interface MakeWholeAmountBuilder
    extends MakeWholeAmount,
    SwapCurveValuation.SwapCurveValuationBuilder {
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateEarlyCallDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getEarlyCallDate();

        @Override
        public MakeWholeAmountBuilder setFloatingRateIndex(FloatingRateIndexEnum var1);

        @Override
        public MakeWholeAmountBuilder setIndexTenor(Period var1);

        @Override
        public MakeWholeAmountBuilder setSpread(BigDecimal var1);

        @Override
        public MakeWholeAmountBuilder setSide(QuotationSideEnum var1);

        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethodEnum var1);

        public MakeWholeAmountBuilder setEarlyCallDate(FieldWithMetaDate var1);

        public MakeWholeAmountBuilder setEarlyCallDateValue(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("floatingRateIndex"), FloatingRateIndexEnum.class, (Object)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getIndexTenor(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("side"), QuotationSideEnum.class, (Object)this.getSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interpolationMethod"), InterpolationMethodEnum.class, (Object)this.getInterpolationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyCallDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getEarlyCallDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        }

        @Override
        public MakeWholeAmountBuilder prune();
    }

    public static class MakeWholeAmountImpl
    extends SwapCurveValuation.SwapCurveValuationImpl
    implements MakeWholeAmount {
        private final InterpolationMethodEnum interpolationMethod;
        private final FieldWithMetaDate earlyCallDate;

        protected MakeWholeAmountImpl(MakeWholeAmountBuilder builder) {
            super(builder);
            this.interpolationMethod = builder.getInterpolationMethod();
            this.earlyCallDate = Optional.ofNullable(builder.getEarlyCallDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        @RosettaAttribute(value="earlyCallDate", isRequired=true)
        @RuneAttribute(value="earlyCallDate", isRequired=true)
        public FieldWithMetaDate getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public MakeWholeAmount build() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            MakeWholeAmountBuilder builder = MakeWholeAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MakeWholeAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
            Optional.ofNullable(this.getEarlyCallDate()).ifPresent(builder::setEarlyCallDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals((Object)this.interpolationMethod, (Object)_that.getInterpolationMethod())) {
                return false;
            }
            return Objects.equals(this.earlyCallDate, _that.getEarlyCallDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interpolationMethod != null ? ((Object)((Object)this.interpolationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmount {interpolationMethod=" + (Object)((Object)this.interpolationMethod) + ", earlyCallDate=" + this.earlyCallDate + '}' + " " + super.toString();
        }
    }
}

