/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.functions.AdjustableDatesResolution;
import cdm.base.datetime.functions.AdjustableOrAdjustedOrRelativeDateResolution;
import cdm.base.datetime.functions.ConvertToAdjustableOrAdjustedOrRelativeDate;
import cdm.base.datetime.functions.DateDifferenceYears;
import cdm.event.common.Trade;
import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.functions.AuxiliarEffectiveDate;
import cdm.margin.schedule.functions.AuxiliarTerminationDate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.OptionExerciseStyleEnum;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import cdm.product.template.Underlier;
import cdm.product.template.functions.UnderlierForOptionOrForwardProduct;
import cdm.product.template.util.ProductDeepPathUtil;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=StandardizedScheduleDurationDefault.class)
public abstract class StandardizedScheduleDuration
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected AdjustableDatesResolution adjustableDatesResolution;
    @Inject
    protected AdjustableOrAdjustedOrRelativeDateResolution adjustableOrAdjustedOrRelativeDateResolution;
    @Inject
    protected AuxiliarEffectiveDate auxiliarEffectiveDate;
    @Inject
    protected AuxiliarTerminationDate auxiliarTerminationDate;
    @Inject
    protected ConvertToAdjustableOrAdjustedOrRelativeDate convertToAdjustableOrAdjustedOrRelativeDate;
    @Inject
    protected DateDifferenceYears dateDifferenceYears;
    @Inject
    protected ProductDeepPathUtil productDeepPathUtil;
    @Inject
    protected UnderlierForOptionOrForwardProduct underlierForOptionOrForwardProduct;

    public BigDecimal evaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
        BigDecimal durationInYears = this.doEvaluate(trade, assetClass, productClass);
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)durationInYears)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)durationInYears), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "Ensure duration is greater than 0.");
        return durationInYears;
    }

    protected abstract BigDecimal doEvaluate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends NonTransferableProduct> product(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<? extends Underlier> underlier(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<Date> transactionEffectiveDate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<Date> transactionTerminationDate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<BigDecimal> transactionTenorInYears(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<Date> underlyingTransactionEffectiveDate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<Date> underlyingTransactionTerminationDate(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<BigDecimal> underlyingTransactionTenorInYears(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<Date> optionExpiry(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<BigDecimal> timeToOptionExpiryInYears(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<BigDecimal> genericDurationInYears(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    protected abstract MapperS<BigDecimal> auxiliarDurationInYears(Trade var1, StandardizedScheduleAssetClassEnum var2, StandardizedScheduleProductClassEnum var3);

    public static class StandardizedScheduleDurationDefault
    extends StandardizedScheduleDuration {
        @Override
        protected BigDecimal doEvaluate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            BigDecimal durationInYears = null;
            return this.assignOutput(durationInYears, trade, assetClass, productClass);
        }

        protected BigDecimal assignOutput(BigDecimal durationInYears, Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            durationInYears = ExpressionOperators.exists(this.genericDurationInYears(trade, assetClass, productClass)).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)this.genericDurationInYears(trade, assetClass, productClass).get() : (BigDecimal)this.auxiliarDurationInYears(trade, assetClass, productClass).get();
            return durationInYears;
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> product(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return this.product(trade, assetClass, productClass).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }

        @Override
        protected MapperS<? extends Underlier> underlier(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.underlierForOptionOrForwardProduct.evaluate((NonTransferableProduct)this.product(trade, assetClass, productClass).get()));
        }

        @Override
        protected MapperS<Date> transactionEffectiveDate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)this.economicTerms(trade, assetClass, productClass).map("getEffectiveDate", _economicTerms -> _economicTerms.getEffectiveDate()).get())));
        }

        @Override
        protected MapperS<Date> transactionTerminationDate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)this.economicTerms(trade, assetClass, productClass).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()).get())));
        }

        @Override
        protected MapperS<BigDecimal> transactionTenorInYears(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.exists(this.transactionEffectiveDate(trade, assetClass, productClass)).and(ExpressionOperators.exists(this.transactionTerminationDate(trade, assetClass, productClass))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.dateDifferenceYears.evaluate((Date)this.transactionEffectiveDate(trade, assetClass, productClass).get(), (Date)this.transactionTerminationDate(trade, assetClass, productClass).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<Date> underlyingTransactionEffectiveDate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)this.underlier(trade, assetClass, productClass).map("getProduct", _underlier -> _underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).map("getEffectiveDate", _economicTerms -> _economicTerms.getEffectiveDate()).get())));
        }

        @Override
        protected MapperS<Date> underlyingTransactionTerminationDate(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)this.underlier(trade, assetClass, productClass).map("getProduct", _underlier -> _underlier.getProduct()).map("chooseEconomicTerms", _product -> this.productDeepPathUtil.chooseEconomicTerms((Product)_product)).map("getTerminationDate", _economicTerms -> _economicTerms.getTerminationDate()).get())));
        }

        @Override
        protected MapperS<BigDecimal> underlyingTransactionTenorInYears(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.exists(this.underlyingTransactionEffectiveDate(trade, assetClass, productClass)).and(ExpressionOperators.exists(this.underlyingTransactionTerminationDate(trade, assetClass, productClass))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.dateDifferenceYears.evaluate((Date)this.underlyingTransactionEffectiveDate(trade, assetClass, productClass).get(), (Date)this.underlyingTransactionTerminationDate(trade, assetClass, productClass).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<Date> optionExpiry(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            MapperS thenArg = MapperS.of((Object)((OptionPayout)this.economicTerms(trade, assetClass, productClass).mapC("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms());
            return thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getStyle", exerciseTerms -> exerciseTerms.getStyle()), (Mapper)MapperS.of((Object)((Object)OptionExerciseStyleEnum.AMERICAN)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)item.mapC("getExpirationDate", exerciseTerms -> exerciseTerms.getExpirationDate()).get())));
                }
                if (ExpressionOperators.areEqual((Mapper)item.map("getStyle", exerciseTerms -> exerciseTerms.getStyle()), (Mapper)MapperS.of((Object)((Object)OptionExerciseStyleEnum.EUROPEAN)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.mapC("getExpirationDate", exerciseTerms -> exerciseTerms.getExpirationDate()).max(_item -> MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)_item.get())))).mapSingleToItem(_item -> MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate(this.convertToAdjustableOrAdjustedOrRelativeDate.evaluate((AdjustableOrRelativeDate)_item.get()))));
                }
                if (ExpressionOperators.areEqual((Mapper)item.map("getStyle", exerciseTerms -> exerciseTerms.getStyle()), (Mapper)MapperS.of((Object)((Object)OptionExerciseStyleEnum.BERMUDA)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.exists((Mapper)item.map("getExerciseDates", exerciseTerms -> exerciseTerms.getExerciseDates()).map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperC.of(this.adjustableDatesResolution.evaluate((AdjustableDates)item.map("getExerciseDates", exerciseTerms -> exerciseTerms.getExerciseDates()).map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates()).get())).max(_item -> _item).mapSingleToItem(_item -> _item);
                    }
                    return MapperS.ofNull();
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<BigDecimal> timeToOptionExpiryInYears(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.exists(this.transactionEffectiveDate(trade, assetClass, productClass)).and(ExpressionOperators.exists(this.optionExpiry(trade, assetClass, productClass))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.dateDifferenceYears.evaluate((Date)this.transactionEffectiveDate(trade, assetClass, productClass).get(), (Date)this.optionExpiry(trade, assetClass, productClass).get()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<BigDecimal> genericDurationInYears(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.INTEREST_RATES)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleAssetClassEnum.CREDIT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAP_WITH_CALLABLE_BERMUDAN_RIGHT_TO_ENTER_EXIT_SWAPS)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CROSS_CURRENCY_SWAP)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.FORWARD_RATE_AGREEMENT)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SINGLE_NAME_CREDIT_DEFAULT_SWAP)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_CDS)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.INDEX_TRANCHE)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.CREDIT_NTH_TO_DEFAULT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return this.transactionTenorInYears(trade, assetClass, productClass);
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.SWAPTION_STRADDLE)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.exists(this.timeToOptionExpiryInYears(trade, assetClass, productClass)).and(ExpressionOperators.exists(this.underlyingTransactionTenorInYears(trade, assetClass, productClass))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperMaths.add(this.timeToOptionExpiryInYears(trade, assetClass, productClass), this.underlyingTransactionTenorInYears(trade, assetClass, productClass));
                    }
                    if (ExpressionOperators.exists(this.timeToOptionExpiryInYears(trade, assetClass, productClass)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return this.timeToOptionExpiryInYears(trade, assetClass, productClass);
                    }
                    if (ExpressionOperators.exists(this.underlyingTransactionTenorInYears(trade, assetClass, productClass)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return this.underlyingTransactionTenorInYears(trade, assetClass, productClass);
                    }
                    return MapperS.ofNull();
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)productClass)), (Mapper)MapperS.of((Object)((Object)StandardizedScheduleProductClassEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return this.timeToOptionExpiryInYears(trade, assetClass, productClass);
                }
                return MapperS.ofNull();
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<BigDecimal> auxiliarDurationInYears(Trade trade, StandardizedScheduleAssetClassEnum assetClass, StandardizedScheduleProductClassEnum productClass) {
            return MapperS.of((Object)this.dateDifferenceYears.evaluate(this.auxiliarEffectiveDate.evaluate(trade), this.auxiliarTerminationDate.evaluate(trade)));
        }
    }
}

