/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.transaction.validation.datarule;

import cdm.legaldocumentation.transaction.Clause;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ClauseChoice0")
@ImplementedBy(value=Default.class)
public interface ClauseChoice0
extends Validator<Clause> {
    public static final String NAME = "ClauseChoice0";
    public static final String DEFINITION = "optional choice terms, subcomponents";

    public static class NoOp
    implements ClauseChoice0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Clause clause) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ClauseChoice0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Clause clause) {
            ComparisonResult result = this.executeDataRule(clause);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ClauseChoice0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Clause", (RosettaPath)path, (String)ClauseChoice0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ClauseChoice0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Clause", (RosettaPath)path, (String)ClauseChoice0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Clause clause) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)clause), Arrays.asList("terms", "subcomponents"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

