/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.transaction.additionalterms;

import cdm.base.datetime.AdjustedRelativeDateOffset;
import cdm.base.math.Quantity;
import cdm.legaldocumentation.transaction.additionalterms.EscrowArrangement;
import cdm.legaldocumentation.transaction.additionalterms.meta.IlliquidityMeta;
import cdm.observable.asset.SettlementRateOption;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Illiquidity", builder=IlliquidityBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="Illiquidity", model="cdm", builder=IlliquidityBuilderImpl.class, version="7.0.0-dev.52")
public interface Illiquidity
extends RosettaModelObject {
    public static final IlliquidityMeta metaData = new IlliquidityMeta();

    public Boolean getIlliquidityIsApplicable();

    public EscrowArrangement getEscrowArrangement();

    public Quantity getMinimumAmount();

    public SettlementRateOption getFallbackReferencePrice();

    public AdjustedRelativeDateOffset getIlliquidityValuationDate();

    public Illiquidity build();

    public IlliquidityBuilder toBuilder();

    public static IlliquidityBuilder builder() {
        return new IlliquidityBuilderImpl();
    }

    default public RosettaMetaData<? extends Illiquidity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Illiquidity> getType() {
        return Illiquidity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("illiquidityIsApplicable"), Boolean.class, (Object)this.getIlliquidityIsApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("escrowArrangement"), processor, EscrowArrangement.class, this.getEscrowArrangement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumAmount"), processor, Quantity.class, this.getMinimumAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fallbackReferencePrice"), processor, SettlementRateOption.class, this.getFallbackReferencePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("illiquidityValuationDate"), processor, AdjustedRelativeDateOffset.class, this.getIlliquidityValuationDate(), new AttributeMeta[0]);
    }

    public static class IlliquidityBuilderImpl
    implements IlliquidityBuilder {
        protected Boolean illiquidityIsApplicable;
        protected EscrowArrangement.EscrowArrangementBuilder escrowArrangement;
        protected Quantity.QuantityBuilder minimumAmount;
        protected SettlementRateOption.SettlementRateOptionBuilder fallbackReferencePrice;
        protected AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder illiquidityValuationDate;

        @Override
        @RosettaAttribute(value="illiquidityIsApplicable", isRequired=true)
        @RuneAttribute(value="illiquidityIsApplicable", isRequired=true)
        public Boolean getIlliquidityIsApplicable() {
            return this.illiquidityIsApplicable;
        }

        @Override
        @RosettaAttribute(value="escrowArrangement")
        @RuneAttribute(value="escrowArrangement")
        public EscrowArrangement.EscrowArrangementBuilder getEscrowArrangement() {
            return this.escrowArrangement;
        }

        @Override
        public EscrowArrangement.EscrowArrangementBuilder getOrCreateEscrowArrangement() {
            EscrowArrangement.EscrowArrangementBuilder result = this.escrowArrangement != null ? this.escrowArrangement : (this.escrowArrangement = EscrowArrangement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumAmount")
        @RuneAttribute(value="minimumAmount")
        public Quantity.QuantityBuilder getMinimumAmount() {
            return this.minimumAmount;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateMinimumAmount() {
            Quantity.QuantityBuilder result = this.minimumAmount != null ? this.minimumAmount : (this.minimumAmount = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public SettlementRateOption.SettlementRateOptionBuilder getFallbackReferencePrice() {
            return this.fallbackReferencePrice;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateFallbackReferencePrice() {
            SettlementRateOption.SettlementRateOptionBuilder result = this.fallbackReferencePrice != null ? this.fallbackReferencePrice : (this.fallbackReferencePrice = SettlementRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="illiquidityValuationDate")
        @RuneAttribute(value="illiquidityValuationDate")
        public AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder getIlliquidityValuationDate() {
            return this.illiquidityValuationDate;
        }

        @Override
        public AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder getOrCreateIlliquidityValuationDate() {
            AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder result = this.illiquidityValuationDate != null ? this.illiquidityValuationDate : (this.illiquidityValuationDate = AdjustedRelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="illiquidityIsApplicable", isRequired=true)
        @RuneAttribute(value="illiquidityIsApplicable", isRequired=true)
        public IlliquidityBuilder setIlliquidityIsApplicable(Boolean _illiquidityIsApplicable) {
            this.illiquidityIsApplicable = _illiquidityIsApplicable == null ? null : _illiquidityIsApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="escrowArrangement")
        @RuneAttribute(value="escrowArrangement")
        public IlliquidityBuilder setEscrowArrangement(EscrowArrangement _escrowArrangement) {
            this.escrowArrangement = _escrowArrangement == null ? null : _escrowArrangement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumAmount")
        @RuneAttribute(value="minimumAmount")
        public IlliquidityBuilder setMinimumAmount(Quantity _minimumAmount) {
            this.minimumAmount = _minimumAmount == null ? null : _minimumAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public IlliquidityBuilder setFallbackReferencePrice(SettlementRateOption _fallbackReferencePrice) {
            this.fallbackReferencePrice = _fallbackReferencePrice == null ? null : _fallbackReferencePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="illiquidityValuationDate")
        @RuneAttribute(value="illiquidityValuationDate")
        public IlliquidityBuilder setIlliquidityValuationDate(AdjustedRelativeDateOffset _illiquidityValuationDate) {
            this.illiquidityValuationDate = _illiquidityValuationDate == null ? null : _illiquidityValuationDate.toBuilder();
            return this;
        }

        @Override
        public Illiquidity build() {
            return new IlliquidityImpl(this);
        }

        @Override
        public IlliquidityBuilder toBuilder() {
            return this;
        }

        @Override
        public IlliquidityBuilder prune() {
            if (this.escrowArrangement != null && !this.escrowArrangement.prune().hasData()) {
                this.escrowArrangement = null;
            }
            if (this.minimumAmount != null && !this.minimumAmount.prune().hasData()) {
                this.minimumAmount = null;
            }
            if (this.fallbackReferencePrice != null && !this.fallbackReferencePrice.prune().hasData()) {
                this.fallbackReferencePrice = null;
            }
            if (this.illiquidityValuationDate != null && !this.illiquidityValuationDate.prune().hasData()) {
                this.illiquidityValuationDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIlliquidityIsApplicable() != null) {
                return true;
            }
            if (this.getEscrowArrangement() != null && this.getEscrowArrangement().hasData()) {
                return true;
            }
            if (this.getMinimumAmount() != null && this.getMinimumAmount().hasData()) {
                return true;
            }
            if (this.getFallbackReferencePrice() != null && this.getFallbackReferencePrice().hasData()) {
                return true;
            }
            return this.getIlliquidityValuationDate() != null && this.getIlliquidityValuationDate().hasData();
        }

        public IlliquidityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IlliquidityBuilder o = (IlliquidityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEscrowArrangement(), (RosettaModelObjectBuilder)o.getEscrowArrangement(), this::setEscrowArrangement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumAmount(), (RosettaModelObjectBuilder)o.getMinimumAmount(), this::setMinimumAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFallbackReferencePrice(), (RosettaModelObjectBuilder)o.getFallbackReferencePrice(), this::setFallbackReferencePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIlliquidityValuationDate(), (RosettaModelObjectBuilder)o.getIlliquidityValuationDate(), this::setIlliquidityValuationDate);
            merger.mergeBasic((Object)this.getIlliquidityIsApplicable(), (Object)o.getIlliquidityIsApplicable(), this::setIlliquidityIsApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Illiquidity _that = this.getType().cast(o);
            if (!Objects.equals(this.illiquidityIsApplicable, _that.getIlliquidityIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.escrowArrangement, _that.getEscrowArrangement())) {
                return false;
            }
            if (!Objects.equals(this.minimumAmount, _that.getMinimumAmount())) {
                return false;
            }
            if (!Objects.equals(this.fallbackReferencePrice, _that.getFallbackReferencePrice())) {
                return false;
            }
            return Objects.equals(this.illiquidityValuationDate, _that.getIlliquidityValuationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.illiquidityIsApplicable != null ? this.illiquidityIsApplicable.hashCode() : 0);
            _result = 31 * _result + (this.escrowArrangement != null ? this.escrowArrangement.hashCode() : 0);
            _result = 31 * _result + (this.minimumAmount != null ? this.minimumAmount.hashCode() : 0);
            _result = 31 * _result + (this.fallbackReferencePrice != null ? this.fallbackReferencePrice.hashCode() : 0);
            _result = 31 * _result + (this.illiquidityValuationDate != null ? this.illiquidityValuationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IlliquidityBuilder {illiquidityIsApplicable=" + this.illiquidityIsApplicable + ", escrowArrangement=" + this.escrowArrangement + ", minimumAmount=" + this.minimumAmount + ", fallbackReferencePrice=" + this.fallbackReferencePrice + ", illiquidityValuationDate=" + this.illiquidityValuationDate + '}';
        }
    }

    public static interface IlliquidityBuilder
    extends Illiquidity,
    RosettaModelObjectBuilder {
        public EscrowArrangement.EscrowArrangementBuilder getOrCreateEscrowArrangement();

        @Override
        public EscrowArrangement.EscrowArrangementBuilder getEscrowArrangement();

        public Quantity.QuantityBuilder getOrCreateMinimumAmount();

        @Override
        public Quantity.QuantityBuilder getMinimumAmount();

        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateFallbackReferencePrice();

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getFallbackReferencePrice();

        public AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder getOrCreateIlliquidityValuationDate();

        @Override
        public AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder getIlliquidityValuationDate();

        public IlliquidityBuilder setIlliquidityIsApplicable(Boolean var1);

        public IlliquidityBuilder setEscrowArrangement(EscrowArrangement var1);

        public IlliquidityBuilder setMinimumAmount(Quantity var1);

        public IlliquidityBuilder setFallbackReferencePrice(SettlementRateOption var1);

        public IlliquidityBuilder setIlliquidityValuationDate(AdjustedRelativeDateOffset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("illiquidityIsApplicable"), Boolean.class, (Object)this.getIlliquidityIsApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("escrowArrangement"), processor, EscrowArrangement.EscrowArrangementBuilder.class, this.getEscrowArrangement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumAmount"), processor, Quantity.QuantityBuilder.class, this.getMinimumAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fallbackReferencePrice"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getFallbackReferencePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("illiquidityValuationDate"), processor, AdjustedRelativeDateOffset.AdjustedRelativeDateOffsetBuilder.class, this.getIlliquidityValuationDate(), new AttributeMeta[0]);
        }

        public IlliquidityBuilder prune();
    }

    public static class IlliquidityImpl
    implements Illiquidity {
        private final Boolean illiquidityIsApplicable;
        private final EscrowArrangement escrowArrangement;
        private final Quantity minimumAmount;
        private final SettlementRateOption fallbackReferencePrice;
        private final AdjustedRelativeDateOffset illiquidityValuationDate;

        protected IlliquidityImpl(IlliquidityBuilder builder) {
            this.illiquidityIsApplicable = builder.getIlliquidityIsApplicable();
            this.escrowArrangement = Optional.ofNullable(builder.getEscrowArrangement()).map(f -> f.build()).orElse(null);
            this.minimumAmount = Optional.ofNullable(builder.getMinimumAmount()).map(f -> f.build()).orElse(null);
            this.fallbackReferencePrice = Optional.ofNullable(builder.getFallbackReferencePrice()).map(f -> f.build()).orElse(null);
            this.illiquidityValuationDate = Optional.ofNullable(builder.getIlliquidityValuationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="illiquidityIsApplicable", isRequired=true)
        @RuneAttribute(value="illiquidityIsApplicable", isRequired=true)
        public Boolean getIlliquidityIsApplicable() {
            return this.illiquidityIsApplicable;
        }

        @Override
        @RosettaAttribute(value="escrowArrangement")
        @RuneAttribute(value="escrowArrangement")
        public EscrowArrangement getEscrowArrangement() {
            return this.escrowArrangement;
        }

        @Override
        @RosettaAttribute(value="minimumAmount")
        @RuneAttribute(value="minimumAmount")
        public Quantity getMinimumAmount() {
            return this.minimumAmount;
        }

        @Override
        @RosettaAttribute(value="fallbackReferencePrice")
        @RuneAttribute(value="fallbackReferencePrice")
        public SettlementRateOption getFallbackReferencePrice() {
            return this.fallbackReferencePrice;
        }

        @Override
        @RosettaAttribute(value="illiquidityValuationDate")
        @RuneAttribute(value="illiquidityValuationDate")
        public AdjustedRelativeDateOffset getIlliquidityValuationDate() {
            return this.illiquidityValuationDate;
        }

        @Override
        public Illiquidity build() {
            return this;
        }

        @Override
        public IlliquidityBuilder toBuilder() {
            IlliquidityBuilder builder = Illiquidity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IlliquidityBuilder builder) {
            Optional.ofNullable(this.getIlliquidityIsApplicable()).ifPresent(builder::setIlliquidityIsApplicable);
            Optional.ofNullable(this.getEscrowArrangement()).ifPresent(builder::setEscrowArrangement);
            Optional.ofNullable(this.getMinimumAmount()).ifPresent(builder::setMinimumAmount);
            Optional.ofNullable(this.getFallbackReferencePrice()).ifPresent(builder::setFallbackReferencePrice);
            Optional.ofNullable(this.getIlliquidityValuationDate()).ifPresent(builder::setIlliquidityValuationDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Illiquidity _that = this.getType().cast(o);
            if (!Objects.equals(this.illiquidityIsApplicable, _that.getIlliquidityIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.escrowArrangement, _that.getEscrowArrangement())) {
                return false;
            }
            if (!Objects.equals(this.minimumAmount, _that.getMinimumAmount())) {
                return false;
            }
            if (!Objects.equals(this.fallbackReferencePrice, _that.getFallbackReferencePrice())) {
                return false;
            }
            return Objects.equals(this.illiquidityValuationDate, _that.getIlliquidityValuationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.illiquidityIsApplicable != null ? this.illiquidityIsApplicable.hashCode() : 0);
            _result = 31 * _result + (this.escrowArrangement != null ? this.escrowArrangement.hashCode() : 0);
            _result = 31 * _result + (this.minimumAmount != null ? this.minimumAmount.hashCode() : 0);
            _result = 31 * _result + (this.fallbackReferencePrice != null ? this.fallbackReferencePrice.hashCode() : 0);
            _result = 31 * _result + (this.illiquidityValuationDate != null ? this.illiquidityValuationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Illiquidity {illiquidityIsApplicable=" + this.illiquidityIsApplicable + ", escrowArrangement=" + this.escrowArrangement + ", minimumAmount=" + this.minimumAmount + ", fallbackReferencePrice=" + this.fallbackReferencePrice + ", illiquidityValuationDate=" + this.illiquidityValuationDate + '}';
        }
    }
}

