/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.ValuationTime;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ValuationTimeDayAndTime")
@ImplementedBy(value=Default.class)
public interface ValuationTimeDayAndTime
extends Validator<ValuationTime> {
    public static final String NAME = "ValuationTimeDayAndTime";
    public static final String DEFINITION = "if day exists then time exists else time is absent and item -> location is absent and hourminutetime is absent and timezone is absent";

    public static class NoOp
    implements ValuationTimeDayAndTime {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationTime valuationTime) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ValuationTimeDayAndTime {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuationTime valuationTime) {
            ComparisonResult result = this.executeDataRule(valuationTime);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ValuationTimeDayAndTime.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationTime", (RosettaPath)path, (String)ValuationTimeDayAndTime.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ValuationTimeDayAndTime.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationTime", (RosettaPath)path, (String)ValuationTimeDayAndTime.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ValuationTime valuationTime) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationTime).map("getDay", _valuationTime -> _valuationTime.getDay())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationTime).map("getTime", _valuationTime -> _valuationTime.getTime()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)valuationTime).map("getTime", _valuationTime -> _valuationTime.getTime())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)valuationTime).mapC("getLocation", _valuationTime -> _valuationTime.getLocation()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)valuationTime).map("getHourminutetime", _valuationTime -> _valuationTime.getHourminutetime()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)valuationTime).map("getTimezone", _valuationTime -> _valuationTime.getTimezone())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

