/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.CollateralValueMethod;
import cdm.legaldocumentation.csa.ValueCashEnum;
import cdm.legaldocumentation.csa.ValueSecuritiesEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CollateralValueMethodOtherValues")
@ImplementedBy(value=Default.class)
public interface CollateralValueMethodOtherValues
extends Validator<CollateralValueMethod> {
    public static final String NAME = "CollateralValueMethodOtherValues";
    public static final String DEFINITION = "if cashCollateral = ValueCashEnum -> Other or securitiesCollateral = ValueSecuritiesEnum -> Other then additionalLanguage exists";

    public static class NoOp
    implements CollateralValueMethodOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralValueMethod collateralValueMethod) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CollateralValueMethodOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralValueMethod collateralValueMethod) {
            ComparisonResult result = this.executeDataRule(collateralValueMethod);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CollateralValueMethodOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralValueMethod", (RosettaPath)path, (String)CollateralValueMethodOtherValues.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CollateralValueMethodOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralValueMethod", (RosettaPath)path, (String)CollateralValueMethodOtherValues.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CollateralValueMethod collateralValueMethod) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)collateralValueMethod).map("getCashCollateral", _collateralValueMethod -> _collateralValueMethod.getCashCollateral()), (Mapper)MapperS.of((Object)((Object)ValueCashEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)collateralValueMethod).map("getSecuritiesCollateral", _collateralValueMethod -> _collateralValueMethod.getSecuritiesCollateral()), (Mapper)MapperS.of((Object)((Object)ValueSecuritiesEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)collateralValueMethod).map("getAdditionalLanguage", _collateralValueMethod -> _collateralValueMethod.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

