/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ValueSecuritiesEnum")
public enum ValueSecuritiesEnum {
    BID_PRICE_PERCENTAGE("BidPricePercentage", "Securities - Bid Price multiplied by Valuation Percentage"),
    BID_PRICE_PERCENTAGE_LESS_HAIRCUT("BidPricePercentageLessHaircut", "Securities - Bid Price multiplied by (Valuation Percentage - FX Haircut)"),
    MID_PRICE_PERCENTAGE("MidPricePercentage", "Securities - Mid Price multiplied by Valuation Percentage"),
    MID_PRICE_PERCENTAGE_LESS_HAIRCUT("MidPricePercentageLessHaircut", "Securities - Mid Price multiplied by (Valuation Percentage - FX Haircut)"),
    OTHER("Other", null);

    private static Map<String, ValueSecuritiesEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ValueSecuritiesEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ValueSecuritiesEnum fromDisplayName(String name) {
        ValueSecuritiesEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ValueSecuritiesEnum> map = new ConcurrentHashMap<String, ValueSecuritiesEnum>();
        for (ValueSecuritiesEnum instance : ValueSecuritiesEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

