/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ValuationTimeDayEnum")
public enum ValuationTimeDayEnum {
    PREVIOUS_LOCAL_BUSINESS_DAY("PreviousLocalBusinessDay", "Previous Local Business Day"),
    PREVIOUS_LOCAL_BUSINESS_DAY_MARKET("PreviousLocalBusinessDayMarket", "Previous Local Business Day (Relevant Market)"),
    PREVIOUS_LOCAL_BUSINESS_DAY_CITY_OF_AGENT("PreviousLocalBusinessDayCityOfAgent", "Previous Local Business Day (City of Valuation Agent)"),
    VALUATION_DATE("ValuationDate", "Valuation Date"),
    AS_SELECTED("AsSelected", "As Selected");

    private static Map<String, ValuationTimeDayEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ValuationTimeDayEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ValuationTimeDayEnum fromDisplayName(String name) {
        ValuationTimeDayEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ValuationTimeDayEnum> map = new ConcurrentHashMap<String, ValuationTimeDayEnum>();
        for (ValuationTimeDayEnum instance : ValuationTimeDayEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

