/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.AmendmentEffectiveDate;
import cdm.legaldocumentation.csa.TerminationCurrencyElection;
import cdm.legaldocumentation.csa.meta.TerminationCurrencyAmendmentMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TerminationCurrencyAmendment", builder=TerminationCurrencyAmendmentBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="TerminationCurrencyAmendment", model="cdm", builder=TerminationCurrencyAmendmentBuilderImpl.class, version="7.0.0-dev.52")
public interface TerminationCurrencyAmendment
extends RosettaModelObject {
    public static final TerminationCurrencyAmendmentMeta metaData = new TerminationCurrencyAmendmentMeta();

    public Boolean getIsApplicable();

    public AmendmentEffectiveDate getEffectiveDate();

    public List<? extends TerminationCurrencyElection> getPartyElection();

    public TerminationCurrencyAmendment build();

    public TerminationCurrencyAmendmentBuilder toBuilder();

    public static TerminationCurrencyAmendmentBuilder builder() {
        return new TerminationCurrencyAmendmentBuilderImpl();
    }

    default public RosettaMetaData<? extends TerminationCurrencyAmendment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TerminationCurrencyAmendment> getType() {
        return TerminationCurrencyAmendment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AmendmentEffectiveDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyElection"), processor, TerminationCurrencyElection.class, this.getPartyElection(), new AttributeMeta[0]);
    }

    public static class TerminationCurrencyAmendmentBuilderImpl
    implements TerminationCurrencyAmendmentBuilder {
        protected Boolean isApplicable;
        protected AmendmentEffectiveDate.AmendmentEffectiveDateBuilder effectiveDate;
        protected List<TerminationCurrencyElection.TerminationCurrencyElectionBuilder> partyElection = new ArrayList<TerminationCurrencyElection.TerminationCurrencyElectionBuilder>();

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AmendmentEffectiveDate.AmendmentEffectiveDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AmendmentEffectiveDate.AmendmentEffectiveDateBuilder getOrCreateEffectiveDate() {
            AmendmentEffectiveDate.AmendmentEffectiveDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AmendmentEffectiveDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public List<? extends TerminationCurrencyElection.TerminationCurrencyElectionBuilder> getPartyElection() {
            return this.partyElection;
        }

        @Override
        public TerminationCurrencyElection.TerminationCurrencyElectionBuilder getOrCreatePartyElection(int index) {
            if (this.partyElection == null) {
                this.partyElection = new ArrayList<TerminationCurrencyElection.TerminationCurrencyElectionBuilder>();
            }
            return (TerminationCurrencyElection.TerminationCurrencyElectionBuilder)this.getIndex(this.partyElection, index, () -> {
                TerminationCurrencyElection.TerminationCurrencyElectionBuilder newPartyElection = TerminationCurrencyElection.builder();
                return newPartyElection;
            });
        }

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public TerminationCurrencyAmendmentBuilder setIsApplicable(Boolean _isApplicable) {
            this.isApplicable = _isApplicable == null ? null : _isApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public TerminationCurrencyAmendmentBuilder setEffectiveDate(AmendmentEffectiveDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public TerminationCurrencyAmendmentBuilder addPartyElection(TerminationCurrencyElection _partyElection) {
            if (_partyElection != null) {
                this.partyElection.add(_partyElection.toBuilder());
            }
            return this;
        }

        @Override
        public TerminationCurrencyAmendmentBuilder addPartyElection(TerminationCurrencyElection _partyElection, int idx) {
            this.getIndex(this.partyElection, idx, () -> _partyElection.toBuilder());
            return this;
        }

        @Override
        public TerminationCurrencyAmendmentBuilder addPartyElection(List<? extends TerminationCurrencyElection> partyElections) {
            if (partyElections != null) {
                for (TerminationCurrencyElection terminationCurrencyElection : partyElections) {
                    this.partyElection.add(terminationCurrencyElection.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyElection")
        public TerminationCurrencyAmendmentBuilder setPartyElection(List<? extends TerminationCurrencyElection> partyElections) {
            this.partyElection = partyElections == null ? new ArrayList<TerminationCurrencyElection.TerminationCurrencyElectionBuilder>() : (List)partyElections.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TerminationCurrencyAmendment build() {
            return new TerminationCurrencyAmendmentImpl(this);
        }

        @Override
        public TerminationCurrencyAmendmentBuilder toBuilder() {
            return this;
        }

        @Override
        public TerminationCurrencyAmendmentBuilder prune() {
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            this.partyElection = this.partyElection.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIsApplicable() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            return this.getPartyElection() != null && this.getPartyElection().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TerminationCurrencyAmendmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TerminationCurrencyAmendmentBuilder o = (TerminationCurrencyAmendmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta(this.getPartyElection(), o.getPartyElection(), this::getOrCreatePartyElection);
            merger.mergeBasic((Object)this.getIsApplicable(), (Object)o.getIsApplicable(), this::setIsApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TerminationCurrencyAmendment _that = this.getType().cast(o);
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return ListEquals.listEquals(this.partyElection, _that.getPartyElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.partyElection != null ? this.partyElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TerminationCurrencyAmendmentBuilder {isApplicable=" + this.isApplicable + ", effectiveDate=" + this.effectiveDate + ", partyElection=" + this.partyElection + '}';
        }
    }

    public static interface TerminationCurrencyAmendmentBuilder
    extends TerminationCurrencyAmendment,
    RosettaModelObjectBuilder {
        public AmendmentEffectiveDate.AmendmentEffectiveDateBuilder getOrCreateEffectiveDate();

        @Override
        public AmendmentEffectiveDate.AmendmentEffectiveDateBuilder getEffectiveDate();

        public TerminationCurrencyElection.TerminationCurrencyElectionBuilder getOrCreatePartyElection(int var1);

        public List<? extends TerminationCurrencyElection.TerminationCurrencyElectionBuilder> getPartyElection();

        public TerminationCurrencyAmendmentBuilder setIsApplicable(Boolean var1);

        public TerminationCurrencyAmendmentBuilder setEffectiveDate(AmendmentEffectiveDate var1);

        public TerminationCurrencyAmendmentBuilder addPartyElection(TerminationCurrencyElection var1);

        public TerminationCurrencyAmendmentBuilder addPartyElection(TerminationCurrencyElection var1, int var2);

        public TerminationCurrencyAmendmentBuilder addPartyElection(List<? extends TerminationCurrencyElection> var1);

        public TerminationCurrencyAmendmentBuilder setPartyElection(List<? extends TerminationCurrencyElection> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AmendmentEffectiveDate.AmendmentEffectiveDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyElection"), processor, TerminationCurrencyElection.TerminationCurrencyElectionBuilder.class, this.getPartyElection(), new AttributeMeta[0]);
        }

        public TerminationCurrencyAmendmentBuilder prune();
    }

    public static class TerminationCurrencyAmendmentImpl
    implements TerminationCurrencyAmendment {
        private final Boolean isApplicable;
        private final AmendmentEffectiveDate effectiveDate;
        private final List<? extends TerminationCurrencyElection> partyElection;

        protected TerminationCurrencyAmendmentImpl(TerminationCurrencyAmendmentBuilder builder) {
            this.isApplicable = builder.getIsApplicable();
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.partyElection = Optional.ofNullable(builder.getPartyElection()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AmendmentEffectiveDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="partyElection")
        @RuneAttribute(value="partyElection")
        public List<? extends TerminationCurrencyElection> getPartyElection() {
            return this.partyElection;
        }

        @Override
        public TerminationCurrencyAmendment build() {
            return this;
        }

        @Override
        public TerminationCurrencyAmendmentBuilder toBuilder() {
            TerminationCurrencyAmendmentBuilder builder = TerminationCurrencyAmendment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TerminationCurrencyAmendmentBuilder builder) {
            Optional.ofNullable(this.getIsApplicable()).ifPresent(builder::setIsApplicable);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPartyElection()).ifPresent(builder::setPartyElection);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TerminationCurrencyAmendment _that = this.getType().cast(o);
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return ListEquals.listEquals(this.partyElection, _that.getPartyElection());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.partyElection != null ? this.partyElection.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TerminationCurrencyAmendment {isApplicable=" + this.isApplicable + ", effectiveDate=" + this.effectiveDate + ", partyElection=" + this.partyElection + '}';
        }
    }
}

