/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.legaldocumentation.csa.meta.PostingObligationsElectionMeta;
import cdm.product.collateral.EligibleCollateralCriteria;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PostingObligationsElection", builder=PostingObligationsElectionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="PostingObligationsElection", model="cdm", builder=PostingObligationsElectionBuilderImpl.class, version="7.0.0-dev.52")
public interface PostingObligationsElection
extends RosettaModelObject {
    public static final PostingObligationsElectionMeta metaData = new PostingObligationsElectionMeta();

    public CounterpartyRoleEnum getParty();

    public Boolean getAsPermitted();

    public List<? extends EligibleCollateralCriteria> getEligibleCollateral();

    public String getExcludedCollateral();

    public String getAdditionalLanguage();

    public PostingObligationsElection build();

    public PostingObligationsElectionBuilder toBuilder();

    public static PostingObligationsElectionBuilder builder() {
        return new PostingObligationsElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends PostingObligationsElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PostingObligationsElection> getType() {
        return PostingObligationsElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("asPermitted"), Boolean.class, (Object)this.getAsPermitted(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eligibleCollateral"), processor, EligibleCollateralCriteria.class, this.getEligibleCollateral(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excludedCollateral"), String.class, (Object)this.getExcludedCollateral(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PostingObligationsElectionBuilderImpl
    implements PostingObligationsElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected Boolean asPermitted;
        protected List<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> eligibleCollateral = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
        protected String excludedCollateral;
        protected String additionalLanguage;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="asPermitted", isRequired=true)
        @RuneAttribute(value="asPermitted", isRequired=true)
        public Boolean getAsPermitted() {
            return this.asPermitted;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getEligibleCollateral() {
            return this.eligibleCollateral;
        }

        @Override
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateEligibleCollateral(int index) {
            if (this.eligibleCollateral == null) {
                this.eligibleCollateral = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
            }
            return (EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder)this.getIndex(this.eligibleCollateral, index, () -> {
                EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder newEligibleCollateral = EligibleCollateralCriteria.builder();
                return newEligibleCollateral;
            });
        }

        @Override
        @RosettaAttribute(value="excludedCollateral")
        @RuneAttribute(value="excludedCollateral")
        public String getExcludedCollateral() {
            return this.excludedCollateral;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public PostingObligationsElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="asPermitted", isRequired=true)
        @RuneAttribute(value="asPermitted", isRequired=true)
        public PostingObligationsElectionBuilder setAsPermitted(Boolean _asPermitted) {
            this.asPermitted = _asPermitted == null ? null : _asPermitted;
            return this;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public PostingObligationsElectionBuilder addEligibleCollateral(EligibleCollateralCriteria _eligibleCollateral) {
            if (_eligibleCollateral != null) {
                this.eligibleCollateral.add(_eligibleCollateral.toBuilder());
            }
            return this;
        }

        @Override
        public PostingObligationsElectionBuilder addEligibleCollateral(EligibleCollateralCriteria _eligibleCollateral, int idx) {
            this.getIndex(this.eligibleCollateral, idx, () -> _eligibleCollateral.toBuilder());
            return this;
        }

        @Override
        public PostingObligationsElectionBuilder addEligibleCollateral(List<? extends EligibleCollateralCriteria> eligibleCollaterals) {
            if (eligibleCollaterals != null) {
                for (EligibleCollateralCriteria eligibleCollateralCriteria : eligibleCollaterals) {
                    this.eligibleCollateral.add(eligibleCollateralCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eligibleCollateral")
        public PostingObligationsElectionBuilder setEligibleCollateral(List<? extends EligibleCollateralCriteria> eligibleCollaterals) {
            this.eligibleCollateral = eligibleCollaterals == null ? new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>() : (List)eligibleCollaterals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="excludedCollateral")
        @RuneAttribute(value="excludedCollateral")
        public PostingObligationsElectionBuilder setExcludedCollateral(String _excludedCollateral) {
            this.excludedCollateral = _excludedCollateral == null ? null : _excludedCollateral;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public PostingObligationsElectionBuilder setAdditionalLanguage(String _additionalLanguage) {
            this.additionalLanguage = _additionalLanguage == null ? null : _additionalLanguage;
            return this;
        }

        @Override
        public PostingObligationsElection build() {
            return new PostingObligationsElectionImpl(this);
        }

        @Override
        public PostingObligationsElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public PostingObligationsElectionBuilder prune() {
            this.eligibleCollateral = this.eligibleCollateral.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getAsPermitted() != null) {
                return true;
            }
            if (this.getEligibleCollateral() != null && this.getEligibleCollateral().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExcludedCollateral() != null) {
                return true;
            }
            return this.getAdditionalLanguage() != null;
        }

        public PostingObligationsElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PostingObligationsElectionBuilder o = (PostingObligationsElectionBuilder)other;
            merger.mergeRosetta(this.getEligibleCollateral(), o.getEligibleCollateral(), this::getOrCreateEligibleCollateral);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAsPermitted(), (Object)o.getAsPermitted(), this::setAsPermitted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcludedCollateral(), (Object)o.getExcludedCollateral(), this::setExcludedCollateral, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalLanguage(), (Object)o.getAdditionalLanguage(), this::setAdditionalLanguage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PostingObligationsElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.asPermitted, _that.getAsPermitted())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCollateral, _that.getEligibleCollateral())) {
                return false;
            }
            if (!Objects.equals(this.excludedCollateral, _that.getExcludedCollateral())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.asPermitted != null ? this.asPermitted.hashCode() : 0);
            _result = 31 * _result + (this.eligibleCollateral != null ? this.eligibleCollateral.hashCode() : 0);
            _result = 31 * _result + (this.excludedCollateral != null ? this.excludedCollateral.hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PostingObligationsElectionBuilder {party=" + (Object)((Object)this.party) + ", asPermitted=" + this.asPermitted + ", eligibleCollateral=" + this.eligibleCollateral + ", excludedCollateral=" + this.excludedCollateral + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }

    public static interface PostingObligationsElectionBuilder
    extends PostingObligationsElection,
    RosettaModelObjectBuilder {
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateEligibleCollateral(int var1);

        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getEligibleCollateral();

        public PostingObligationsElectionBuilder setParty(CounterpartyRoleEnum var1);

        public PostingObligationsElectionBuilder setAsPermitted(Boolean var1);

        public PostingObligationsElectionBuilder addEligibleCollateral(EligibleCollateralCriteria var1);

        public PostingObligationsElectionBuilder addEligibleCollateral(EligibleCollateralCriteria var1, int var2);

        public PostingObligationsElectionBuilder addEligibleCollateral(List<? extends EligibleCollateralCriteria> var1);

        public PostingObligationsElectionBuilder setEligibleCollateral(List<? extends EligibleCollateralCriteria> var1);

        public PostingObligationsElectionBuilder setExcludedCollateral(String var1);

        public PostingObligationsElectionBuilder setAdditionalLanguage(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("asPermitted"), Boolean.class, (Object)this.getAsPermitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eligibleCollateral"), processor, EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder.class, this.getEligibleCollateral(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excludedCollateral"), String.class, (Object)this.getExcludedCollateral(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalLanguage"), String.class, (Object)this.getAdditionalLanguage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PostingObligationsElectionBuilder prune();
    }

    public static class PostingObligationsElectionImpl
    implements PostingObligationsElection {
        private final CounterpartyRoleEnum party;
        private final Boolean asPermitted;
        private final List<? extends EligibleCollateralCriteria> eligibleCollateral;
        private final String excludedCollateral;
        private final String additionalLanguage;

        protected PostingObligationsElectionImpl(PostingObligationsElectionBuilder builder) {
            this.party = builder.getParty();
            this.asPermitted = builder.getAsPermitted();
            this.eligibleCollateral = Optional.ofNullable(builder.getEligibleCollateral()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.excludedCollateral = builder.getExcludedCollateral();
            this.additionalLanguage = builder.getAdditionalLanguage();
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="asPermitted", isRequired=true)
        @RuneAttribute(value="asPermitted", isRequired=true)
        public Boolean getAsPermitted() {
            return this.asPermitted;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public List<? extends EligibleCollateralCriteria> getEligibleCollateral() {
            return this.eligibleCollateral;
        }

        @Override
        @RosettaAttribute(value="excludedCollateral")
        @RuneAttribute(value="excludedCollateral")
        public String getExcludedCollateral() {
            return this.excludedCollateral;
        }

        @Override
        @RosettaAttribute(value="additionalLanguage")
        @RuneAttribute(value="additionalLanguage")
        public String getAdditionalLanguage() {
            return this.additionalLanguage;
        }

        @Override
        public PostingObligationsElection build() {
            return this;
        }

        @Override
        public PostingObligationsElectionBuilder toBuilder() {
            PostingObligationsElectionBuilder builder = PostingObligationsElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PostingObligationsElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getAsPermitted()).ifPresent(builder::setAsPermitted);
            Optional.ofNullable(this.getEligibleCollateral()).ifPresent(builder::setEligibleCollateral);
            Optional.ofNullable(this.getExcludedCollateral()).ifPresent(builder::setExcludedCollateral);
            Optional.ofNullable(this.getAdditionalLanguage()).ifPresent(builder::setAdditionalLanguage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PostingObligationsElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.asPermitted, _that.getAsPermitted())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCollateral, _that.getEligibleCollateral())) {
                return false;
            }
            if (!Objects.equals(this.excludedCollateral, _that.getExcludedCollateral())) {
                return false;
            }
            return Objects.equals(this.additionalLanguage, _that.getAdditionalLanguage());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.asPermitted != null ? this.asPermitted.hashCode() : 0);
            _result = 31 * _result + (this.eligibleCollateral != null ? this.eligibleCollateral.hashCode() : 0);
            _result = 31 * _result + (this.excludedCollateral != null ? this.excludedCollateral.hashCode() : 0);
            _result = 31 * _result + (this.additionalLanguage != null ? this.additionalLanguage.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PostingObligationsElection {party=" + (Object)((Object)this.party) + ", asPermitted=" + this.asPermitted + ", eligibleCollateral=" + this.eligibleCollateral + ", excludedCollateral=" + this.excludedCollateral + ", additionalLanguage=" + this.additionalLanguage + '}';
        }
    }
}

