/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.AdditionalRepresentations;
import cdm.legaldocumentation.csa.AppropriatedCollateralValuation;
import cdm.legaldocumentation.csa.BaseAndEligibleCurrency;
import cdm.legaldocumentation.csa.CalculationAndTiming;
import cdm.legaldocumentation.csa.CollateralValueMethod;
import cdm.legaldocumentation.csa.ConditionsPrecedent;
import cdm.legaldocumentation.csa.CoveredTransactions;
import cdm.legaldocumentation.csa.CreditSupportObligations;
import cdm.legaldocumentation.csa.CustodyArrangements;
import cdm.legaldocumentation.csa.DatedAsOfDate;
import cdm.legaldocumentation.csa.DemandsAndNotices;
import cdm.legaldocumentation.csa.DisputeResolution;
import cdm.legaldocumentation.csa.FinalReturns;
import cdm.legaldocumentation.csa.FxHaircutCurrency;
import cdm.legaldocumentation.csa.GeneralSimmElections;
import cdm.legaldocumentation.csa.HoldingAndUsingPostedCollateral;
import cdm.legaldocumentation.csa.JurisdictionRelatedTerms;
import cdm.legaldocumentation.csa.MinimumTransferAmountAmendment;
import cdm.legaldocumentation.csa.OneWayProvisions;
import cdm.legaldocumentation.csa.OtherAgreements;
import cdm.legaldocumentation.csa.OtherEligibleAndPostedSupport;
import cdm.legaldocumentation.csa.PostingObligations;
import cdm.legaldocumentation.csa.ProcessAgent;
import cdm.legaldocumentation.csa.Regime;
import cdm.legaldocumentation.csa.RightsEvents;
import cdm.legaldocumentation.csa.SecurityInterestForObligations;
import cdm.legaldocumentation.csa.SensitivityMethodologies;
import cdm.legaldocumentation.csa.SinglePostingParty;
import cdm.legaldocumentation.csa.SubstitutedRegime;
import cdm.legaldocumentation.csa.Substitution;
import cdm.legaldocumentation.csa.TerminationCurrencyAmendment;
import cdm.legaldocumentation.csa.meta.CreditSupportAgreementElectionsMeta;
import cdm.product.collateral.ContactElection;
import cdm.product.collateral.DistributionAndInterestPayment;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditSupportAgreementElections", builder=CreditSupportAgreementElectionsBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CreditSupportAgreementElections", model="cdm", builder=CreditSupportAgreementElectionsBuilderImpl.class, version="7.0.0-dev.52")
public interface CreditSupportAgreementElections
extends RosettaModelObject {
    public static final CreditSupportAgreementElectionsMeta metaData = new CreditSupportAgreementElectionsMeta();

    public Regime getRegime();

    public OneWayProvisions getOneWayProvisions();

    public GeneralSimmElections getGeneralSimmElections();

    public Boolean getIdentifiedCrossCurrencySwap();

    public SensitivityMethodologies getSensitivityMethodologies();

    public FxHaircutCurrency getFxHaircutCurrency();

    public PostingObligations getPostingObligations();

    public List<? extends SubstitutedRegime> getSubstitutedRegime();

    public BaseAndEligibleCurrency getBaseAndEligibleCurrency();

    public String getAdditionalObligations();

    public CoveredTransactions getCoveredTransactions();

    public CreditSupportObligations getCreditSupportObligations();

    public String getExchangeDate();

    public CalculationAndTiming getCalculationAndTiming();

    public ConditionsPrecedent getConditionsPrecedent();

    public Substitution getSubstitution();

    public DisputeResolution getDisputeResolution();

    public HoldingAndUsingPostedCollateral getHoldingAndUsingPostedCollateral();

    public RightsEvents getRightsEvents();

    public CustodyArrangements getCustodyArrangements();

    public DistributionAndInterestPayment getDistributionAndInterestPayment();

    public Boolean getCreditSupportOffsets();

    public AdditionalRepresentations getAdditionalRepresentations();

    public OtherEligibleAndPostedSupport getOtherEligibleAndPostedSupport();

    public DemandsAndNotices getDemandsAndNotices();

    public ContactElection getAddressesForTransfer();

    public OtherAgreements getOtherAgreements();

    public TerminationCurrencyAmendment getTerminationCurrencyAmendment();

    public MinimumTransferAmountAmendment getMinimumTransferAmountAmendment();

    public String getInterpretationTerms();

    public ProcessAgent getProcessAgent();

    public AppropriatedCollateralValuation getAppropriatedCollateralValuation();

    public JurisdictionRelatedTerms getJurisdictionRelatedTerms();

    public String getAdditionalAmendments();

    public String getAdditionalBespokeTerms();

    public Boolean getTrustSchemeAddendum();

    public SecurityInterestForObligations getSecurityInterestForObligations();

    public SinglePostingParty getSinglePostingParty();

    public DatedAsOfDate getDatedAsOfDate();

    public String getCass();

    public String getOtherCSA();

    public String getLegacyAdditionalRepresentations();

    public CollateralValueMethod getValue();

    public FinalReturns getFinalReturns();

    public CreditSupportAgreementElections build();

    public CreditSupportAgreementElectionsBuilder toBuilder();

    public static CreditSupportAgreementElectionsBuilder builder() {
        return new CreditSupportAgreementElectionsBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditSupportAgreementElections> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditSupportAgreementElections> getType() {
        return CreditSupportAgreementElections.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("regime"), processor, Regime.class, this.getRegime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("oneWayProvisions"), processor, OneWayProvisions.class, this.getOneWayProvisions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("generalSimmElections"), processor, GeneralSimmElections.class, this.getGeneralSimmElections(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("identifiedCrossCurrencySwap"), Boolean.class, (Object)this.getIdentifiedCrossCurrencySwap(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivityMethodologies"), processor, SensitivityMethodologies.class, this.getSensitivityMethodologies(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxHaircutCurrency"), processor, FxHaircutCurrency.class, this.getFxHaircutCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("postingObligations"), processor, PostingObligations.class, this.getPostingObligations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("substitutedRegime"), processor, SubstitutedRegime.class, this.getSubstitutedRegime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseAndEligibleCurrency"), processor, BaseAndEligibleCurrency.class, this.getBaseAndEligibleCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalObligations"), String.class, (Object)this.getAdditionalObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coveredTransactions"), processor, CoveredTransactions.class, this.getCoveredTransactions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportObligations"), processor, CreditSupportObligations.class, this.getCreditSupportObligations(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeDate"), String.class, (Object)this.getExchangeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationAndTiming"), processor, CalculationAndTiming.class, this.getCalculationAndTiming(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("conditionsPrecedent"), processor, ConditionsPrecedent.class, this.getConditionsPrecedent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("substitution"), processor, Substitution.class, this.getSubstitution(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("disputeResolution"), processor, DisputeResolution.class, this.getDisputeResolution(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("holdingAndUsingPostedCollateral"), processor, HoldingAndUsingPostedCollateral.class, this.getHoldingAndUsingPostedCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rightsEvents"), processor, RightsEvents.class, this.getRightsEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("custodyArrangements"), processor, CustodyArrangements.class, this.getCustodyArrangements(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("distributionAndInterestPayment"), processor, DistributionAndInterestPayment.class, this.getDistributionAndInterestPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditSupportOffsets"), Boolean.class, (Object)this.getCreditSupportOffsets(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalRepresentations"), processor, AdditionalRepresentations.class, this.getAdditionalRepresentations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherEligibleAndPostedSupport"), processor, OtherEligibleAndPostedSupport.class, this.getOtherEligibleAndPostedSupport(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("demandsAndNotices"), processor, DemandsAndNotices.class, this.getDemandsAndNotices(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("addressesForTransfer"), processor, ContactElection.class, this.getAddressesForTransfer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherAgreements"), processor, OtherAgreements.class, this.getOtherAgreements(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationCurrencyAmendment"), processor, TerminationCurrencyAmendment.class, this.getTerminationCurrencyAmendment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumTransferAmountAmendment"), processor, MinimumTransferAmountAmendment.class, this.getMinimumTransferAmountAmendment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interpretationTerms"), String.class, (Object)this.getInterpretationTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("processAgent"), processor, ProcessAgent.class, this.getProcessAgent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("appropriatedCollateralValuation"), processor, AppropriatedCollateralValuation.class, this.getAppropriatedCollateralValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("jurisdictionRelatedTerms"), processor, JurisdictionRelatedTerms.class, this.getJurisdictionRelatedTerms(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalAmendments"), String.class, (Object)this.getAdditionalAmendments(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("additionalBespokeTerms"), String.class, (Object)this.getAdditionalBespokeTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("trustSchemeAddendum"), Boolean.class, (Object)this.getTrustSchemeAddendum(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityInterestForObligations"), processor, SecurityInterestForObligations.class, this.getSecurityInterestForObligations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("singlePostingParty"), processor, SinglePostingParty.class, this.getSinglePostingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedAsOfDate"), processor, DatedAsOfDate.class, this.getDatedAsOfDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cass"), String.class, (Object)this.getCass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherCSA"), String.class, (Object)this.getOtherCSA(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("legacyAdditionalRepresentations"), String.class, (Object)this.getLegacyAdditionalRepresentations(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("value"), processor, CollateralValueMethod.class, this.getValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalReturns"), processor, FinalReturns.class, this.getFinalReturns(), new AttributeMeta[0]);
    }

    public static class CreditSupportAgreementElectionsBuilderImpl
    implements CreditSupportAgreementElectionsBuilder {
        protected Regime.RegimeBuilder regime;
        protected OneWayProvisions.OneWayProvisionsBuilder oneWayProvisions;
        protected GeneralSimmElections.GeneralSimmElectionsBuilder generalSimmElections;
        protected Boolean identifiedCrossCurrencySwap;
        protected SensitivityMethodologies.SensitivityMethodologiesBuilder sensitivityMethodologies;
        protected FxHaircutCurrency.FxHaircutCurrencyBuilder fxHaircutCurrency;
        protected PostingObligations.PostingObligationsBuilder postingObligations;
        protected List<SubstitutedRegime.SubstitutedRegimeBuilder> substitutedRegime = new ArrayList<SubstitutedRegime.SubstitutedRegimeBuilder>();
        protected BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder baseAndEligibleCurrency;
        protected String additionalObligations;
        protected CoveredTransactions.CoveredTransactionsBuilder coveredTransactions;
        protected CreditSupportObligations.CreditSupportObligationsBuilder creditSupportObligations;
        protected String exchangeDate;
        protected CalculationAndTiming.CalculationAndTimingBuilder calculationAndTiming;
        protected ConditionsPrecedent.ConditionsPrecedentBuilder conditionsPrecedent;
        protected Substitution.SubstitutionBuilder substitution;
        protected DisputeResolution.DisputeResolutionBuilder disputeResolution;
        protected HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder holdingAndUsingPostedCollateral;
        protected RightsEvents.RightsEventsBuilder rightsEvents;
        protected CustodyArrangements.CustodyArrangementsBuilder custodyArrangements;
        protected DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder distributionAndInterestPayment;
        protected Boolean creditSupportOffsets;
        protected AdditionalRepresentations.AdditionalRepresentationsBuilder additionalRepresentations;
        protected OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder otherEligibleAndPostedSupport;
        protected DemandsAndNotices.DemandsAndNoticesBuilder demandsAndNotices;
        protected ContactElection.ContactElectionBuilder addressesForTransfer;
        protected OtherAgreements.OtherAgreementsBuilder otherAgreements;
        protected TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder terminationCurrencyAmendment;
        protected MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder minimumTransferAmountAmendment;
        protected String interpretationTerms;
        protected ProcessAgent.ProcessAgentBuilder processAgent;
        protected AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder appropriatedCollateralValuation;
        protected JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder jurisdictionRelatedTerms;
        protected String additionalAmendments;
        protected String additionalBespokeTerms;
        protected Boolean trustSchemeAddendum;
        protected SecurityInterestForObligations.SecurityInterestForObligationsBuilder securityInterestForObligations;
        protected SinglePostingParty.SinglePostingPartyBuilder singlePostingParty;
        protected DatedAsOfDate.DatedAsOfDateBuilder datedAsOfDate;
        protected String cass;
        protected String otherCSA;
        protected String legacyAdditionalRepresentations;
        protected CollateralValueMethod.CollateralValueMethodBuilder value;
        protected FinalReturns.FinalReturnsBuilder finalReturns;

        @Override
        @RosettaAttribute(value="regime", isRequired=true)
        @RuneAttribute(value="regime", isRequired=true)
        public Regime.RegimeBuilder getRegime() {
            return this.regime;
        }

        @Override
        public Regime.RegimeBuilder getOrCreateRegime() {
            Regime.RegimeBuilder result = this.regime != null ? this.regime : (this.regime = Regime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="oneWayProvisions", isRequired=true)
        @RuneAttribute(value="oneWayProvisions", isRequired=true)
        public OneWayProvisions.OneWayProvisionsBuilder getOneWayProvisions() {
            return this.oneWayProvisions;
        }

        @Override
        public OneWayProvisions.OneWayProvisionsBuilder getOrCreateOneWayProvisions() {
            OneWayProvisions.OneWayProvisionsBuilder result = this.oneWayProvisions != null ? this.oneWayProvisions : (this.oneWayProvisions = OneWayProvisions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="generalSimmElections")
        @RuneAttribute(value="generalSimmElections")
        public GeneralSimmElections.GeneralSimmElectionsBuilder getGeneralSimmElections() {
            return this.generalSimmElections;
        }

        @Override
        public GeneralSimmElections.GeneralSimmElectionsBuilder getOrCreateGeneralSimmElections() {
            GeneralSimmElections.GeneralSimmElectionsBuilder result = this.generalSimmElections != null ? this.generalSimmElections : (this.generalSimmElections = GeneralSimmElections.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="identifiedCrossCurrencySwap")
        @RuneAttribute(value="identifiedCrossCurrencySwap")
        public Boolean getIdentifiedCrossCurrencySwap() {
            return this.identifiedCrossCurrencySwap;
        }

        @Override
        @RosettaAttribute(value="sensitivityMethodologies", isRequired=true)
        @RuneAttribute(value="sensitivityMethodologies", isRequired=true)
        public SensitivityMethodologies.SensitivityMethodologiesBuilder getSensitivityMethodologies() {
            return this.sensitivityMethodologies;
        }

        @Override
        public SensitivityMethodologies.SensitivityMethodologiesBuilder getOrCreateSensitivityMethodologies() {
            SensitivityMethodologies.SensitivityMethodologiesBuilder result = this.sensitivityMethodologies != null ? this.sensitivityMethodologies : (this.sensitivityMethodologies = SensitivityMethodologies.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxHaircutCurrency")
        @RuneAttribute(value="fxHaircutCurrency")
        public FxHaircutCurrency.FxHaircutCurrencyBuilder getFxHaircutCurrency() {
            return this.fxHaircutCurrency;
        }

        @Override
        public FxHaircutCurrency.FxHaircutCurrencyBuilder getOrCreateFxHaircutCurrency() {
            FxHaircutCurrency.FxHaircutCurrencyBuilder result = this.fxHaircutCurrency != null ? this.fxHaircutCurrency : (this.fxHaircutCurrency = FxHaircutCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postingObligations", isRequired=true)
        @RuneAttribute(value="postingObligations", isRequired=true)
        public PostingObligations.PostingObligationsBuilder getPostingObligations() {
            return this.postingObligations;
        }

        @Override
        public PostingObligations.PostingObligationsBuilder getOrCreatePostingObligations() {
            PostingObligations.PostingObligationsBuilder result = this.postingObligations != null ? this.postingObligations : (this.postingObligations = PostingObligations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="substitutedRegime")
        @RuneAttribute(value="substitutedRegime")
        public List<? extends SubstitutedRegime.SubstitutedRegimeBuilder> getSubstitutedRegime() {
            return this.substitutedRegime;
        }

        @Override
        public SubstitutedRegime.SubstitutedRegimeBuilder getOrCreateSubstitutedRegime(int index) {
            if (this.substitutedRegime == null) {
                this.substitutedRegime = new ArrayList<SubstitutedRegime.SubstitutedRegimeBuilder>();
            }
            return (SubstitutedRegime.SubstitutedRegimeBuilder)this.getIndex(this.substitutedRegime, index, () -> {
                SubstitutedRegime.SubstitutedRegimeBuilder newSubstitutedRegime = SubstitutedRegime.builder();
                return newSubstitutedRegime;
            });
        }

        @Override
        @RosettaAttribute(value="baseAndEligibleCurrency", isRequired=true)
        @RuneAttribute(value="baseAndEligibleCurrency", isRequired=true)
        public BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder getBaseAndEligibleCurrency() {
            return this.baseAndEligibleCurrency;
        }

        @Override
        public BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder getOrCreateBaseAndEligibleCurrency() {
            BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder result = this.baseAndEligibleCurrency != null ? this.baseAndEligibleCurrency : (this.baseAndEligibleCurrency = BaseAndEligibleCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public String getAdditionalObligations() {
            return this.additionalObligations;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public CoveredTransactions.CoveredTransactionsBuilder getCoveredTransactions() {
            return this.coveredTransactions;
        }

        @Override
        public CoveredTransactions.CoveredTransactionsBuilder getOrCreateCoveredTransactions() {
            CoveredTransactions.CoveredTransactionsBuilder result = this.coveredTransactions != null ? this.coveredTransactions : (this.coveredTransactions = CoveredTransactions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligations", isRequired=true)
        @RuneAttribute(value="creditSupportObligations", isRequired=true)
        public CreditSupportObligations.CreditSupportObligationsBuilder getCreditSupportObligations() {
            return this.creditSupportObligations;
        }

        @Override
        public CreditSupportObligations.CreditSupportObligationsBuilder getOrCreateCreditSupportObligations() {
            CreditSupportObligations.CreditSupportObligationsBuilder result = this.creditSupportObligations != null ? this.creditSupportObligations : (this.creditSupportObligations = CreditSupportObligations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeDate")
        @RuneAttribute(value="exchangeDate")
        public String getExchangeDate() {
            return this.exchangeDate;
        }

        @Override
        @RosettaAttribute(value="calculationAndTiming", isRequired=true)
        @RuneAttribute(value="calculationAndTiming", isRequired=true)
        public CalculationAndTiming.CalculationAndTimingBuilder getCalculationAndTiming() {
            return this.calculationAndTiming;
        }

        @Override
        public CalculationAndTiming.CalculationAndTimingBuilder getOrCreateCalculationAndTiming() {
            CalculationAndTiming.CalculationAndTimingBuilder result = this.calculationAndTiming != null ? this.calculationAndTiming : (this.calculationAndTiming = CalculationAndTiming.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedent")
        @RuneAttribute(value="conditionsPrecedent")
        public ConditionsPrecedent.ConditionsPrecedentBuilder getConditionsPrecedent() {
            return this.conditionsPrecedent;
        }

        @Override
        public ConditionsPrecedent.ConditionsPrecedentBuilder getOrCreateConditionsPrecedent() {
            ConditionsPrecedent.ConditionsPrecedentBuilder result = this.conditionsPrecedent != null ? this.conditionsPrecedent : (this.conditionsPrecedent = ConditionsPrecedent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="substitution", isRequired=true)
        @RuneAttribute(value="substitution", isRequired=true)
        public Substitution.SubstitutionBuilder getSubstitution() {
            return this.substitution;
        }

        @Override
        public Substitution.SubstitutionBuilder getOrCreateSubstitution() {
            Substitution.SubstitutionBuilder result = this.substitution != null ? this.substitution : (this.substitution = Substitution.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="disputeResolution", isRequired=true)
        @RuneAttribute(value="disputeResolution", isRequired=true)
        public DisputeResolution.DisputeResolutionBuilder getDisputeResolution() {
            return this.disputeResolution;
        }

        @Override
        public DisputeResolution.DisputeResolutionBuilder getOrCreateDisputeResolution() {
            DisputeResolution.DisputeResolutionBuilder result = this.disputeResolution != null ? this.disputeResolution : (this.disputeResolution = DisputeResolution.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        @RuneAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        public HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder getHoldingAndUsingPostedCollateral() {
            return this.holdingAndUsingPostedCollateral;
        }

        @Override
        public HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder getOrCreateHoldingAndUsingPostedCollateral() {
            HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder result = this.holdingAndUsingPostedCollateral != null ? this.holdingAndUsingPostedCollateral : (this.holdingAndUsingPostedCollateral = HoldingAndUsingPostedCollateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rightsEvents", isRequired=true)
        @RuneAttribute(value="rightsEvents", isRequired=true)
        public RightsEvents.RightsEventsBuilder getRightsEvents() {
            return this.rightsEvents;
        }

        @Override
        public RightsEvents.RightsEventsBuilder getOrCreateRightsEvents() {
            RightsEvents.RightsEventsBuilder result = this.rightsEvents != null ? this.rightsEvents : (this.rightsEvents = RightsEvents.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="custodyArrangements")
        @RuneAttribute(value="custodyArrangements")
        public CustodyArrangements.CustodyArrangementsBuilder getCustodyArrangements() {
            return this.custodyArrangements;
        }

        @Override
        public CustodyArrangements.CustodyArrangementsBuilder getOrCreateCustodyArrangements() {
            CustodyArrangements.CustodyArrangementsBuilder result = this.custodyArrangements != null ? this.custodyArrangements : (this.custodyArrangements = CustodyArrangements.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="distributionAndInterestPayment")
        @RuneAttribute(value="distributionAndInterestPayment")
        public DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder getDistributionAndInterestPayment() {
            return this.distributionAndInterestPayment;
        }

        @Override
        public DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder getOrCreateDistributionAndInterestPayment() {
            DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder result = this.distributionAndInterestPayment != null ? this.distributionAndInterestPayment : (this.distributionAndInterestPayment = DistributionAndInterestPayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportOffsets", isRequired=true)
        @RuneAttribute(value="creditSupportOffsets", isRequired=true)
        public Boolean getCreditSupportOffsets() {
            return this.creditSupportOffsets;
        }

        @Override
        @RosettaAttribute(value="additionalRepresentations", isRequired=true)
        @RuneAttribute(value="additionalRepresentations", isRequired=true)
        public AdditionalRepresentations.AdditionalRepresentationsBuilder getAdditionalRepresentations() {
            return this.additionalRepresentations;
        }

        @Override
        public AdditionalRepresentations.AdditionalRepresentationsBuilder getOrCreateAdditionalRepresentations() {
            AdditionalRepresentations.AdditionalRepresentationsBuilder result = this.additionalRepresentations != null ? this.additionalRepresentations : (this.additionalRepresentations = AdditionalRepresentations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        @RuneAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        public OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder getOtherEligibleAndPostedSupport() {
            return this.otherEligibleAndPostedSupport;
        }

        @Override
        public OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder getOrCreateOtherEligibleAndPostedSupport() {
            OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder result = this.otherEligibleAndPostedSupport != null ? this.otherEligibleAndPostedSupport : (this.otherEligibleAndPostedSupport = OtherEligibleAndPostedSupport.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="demandsAndNotices")
        @RuneAttribute(value="demandsAndNotices")
        public DemandsAndNotices.DemandsAndNoticesBuilder getDemandsAndNotices() {
            return this.demandsAndNotices;
        }

        @Override
        public DemandsAndNotices.DemandsAndNoticesBuilder getOrCreateDemandsAndNotices() {
            DemandsAndNotices.DemandsAndNoticesBuilder result = this.demandsAndNotices != null ? this.demandsAndNotices : (this.demandsAndNotices = DemandsAndNotices.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="addressesForTransfer")
        @RuneAttribute(value="addressesForTransfer")
        public ContactElection.ContactElectionBuilder getAddressesForTransfer() {
            return this.addressesForTransfer;
        }

        @Override
        public ContactElection.ContactElectionBuilder getOrCreateAddressesForTransfer() {
            ContactElection.ContactElectionBuilder result = this.addressesForTransfer != null ? this.addressesForTransfer : (this.addressesForTransfer = ContactElection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherAgreements")
        @RuneAttribute(value="otherAgreements")
        public OtherAgreements.OtherAgreementsBuilder getOtherAgreements() {
            return this.otherAgreements;
        }

        @Override
        public OtherAgreements.OtherAgreementsBuilder getOrCreateOtherAgreements() {
            OtherAgreements.OtherAgreementsBuilder result = this.otherAgreements != null ? this.otherAgreements : (this.otherAgreements = OtherAgreements.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationCurrencyAmendment", isRequired=true)
        @RuneAttribute(value="terminationCurrencyAmendment", isRequired=true)
        public TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder getTerminationCurrencyAmendment() {
            return this.terminationCurrencyAmendment;
        }

        @Override
        public TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder getOrCreateTerminationCurrencyAmendment() {
            TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder result = this.terminationCurrencyAmendment != null ? this.terminationCurrencyAmendment : (this.terminationCurrencyAmendment = TerminationCurrencyAmendment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        @RuneAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        public MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder getMinimumTransferAmountAmendment() {
            return this.minimumTransferAmountAmendment;
        }

        @Override
        public MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder getOrCreateMinimumTransferAmountAmendment() {
            MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder result = this.minimumTransferAmountAmendment != null ? this.minimumTransferAmountAmendment : (this.minimumTransferAmountAmendment = MinimumTransferAmountAmendment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interpretationTerms")
        @RuneAttribute(value="interpretationTerms")
        public String getInterpretationTerms() {
            return this.interpretationTerms;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public ProcessAgent.ProcessAgentBuilder getProcessAgent() {
            return this.processAgent;
        }

        @Override
        public ProcessAgent.ProcessAgentBuilder getOrCreateProcessAgent() {
            ProcessAgent.ProcessAgentBuilder result = this.processAgent != null ? this.processAgent : (this.processAgent = ProcessAgent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="appropriatedCollateralValuation")
        @RuneAttribute(value="appropriatedCollateralValuation")
        public AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder getAppropriatedCollateralValuation() {
            return this.appropriatedCollateralValuation;
        }

        @Override
        public AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder getOrCreateAppropriatedCollateralValuation() {
            AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder result = this.appropriatedCollateralValuation != null ? this.appropriatedCollateralValuation : (this.appropriatedCollateralValuation = AppropriatedCollateralValuation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="jurisdictionRelatedTerms")
        @RuneAttribute(value="jurisdictionRelatedTerms")
        public JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder getJurisdictionRelatedTerms() {
            return this.jurisdictionRelatedTerms;
        }

        @Override
        public JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder getOrCreateJurisdictionRelatedTerms() {
            JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder result = this.jurisdictionRelatedTerms != null ? this.jurisdictionRelatedTerms : (this.jurisdictionRelatedTerms = JurisdictionRelatedTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalAmendments")
        @RuneAttribute(value="additionalAmendments")
        public String getAdditionalAmendments() {
            return this.additionalAmendments;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public String getAdditionalBespokeTerms() {
            return this.additionalBespokeTerms;
        }

        @Override
        @RosettaAttribute(value="trustSchemeAddendum", isRequired=true)
        @RuneAttribute(value="trustSchemeAddendum", isRequired=true)
        public Boolean getTrustSchemeAddendum() {
            return this.trustSchemeAddendum;
        }

        @Override
        @RosettaAttribute(value="securityInterestForObligations", isRequired=true)
        @RuneAttribute(value="securityInterestForObligations", isRequired=true)
        public SecurityInterestForObligations.SecurityInterestForObligationsBuilder getSecurityInterestForObligations() {
            return this.securityInterestForObligations;
        }

        @Override
        public SecurityInterestForObligations.SecurityInterestForObligationsBuilder getOrCreateSecurityInterestForObligations() {
            SecurityInterestForObligations.SecurityInterestForObligationsBuilder result = this.securityInterestForObligations != null ? this.securityInterestForObligations : (this.securityInterestForObligations = SecurityInterestForObligations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="singlePostingParty")
        @RuneAttribute(value="singlePostingParty")
        public SinglePostingParty.SinglePostingPartyBuilder getSinglePostingParty() {
            return this.singlePostingParty;
        }

        @Override
        public SinglePostingParty.SinglePostingPartyBuilder getOrCreateSinglePostingParty() {
            SinglePostingParty.SinglePostingPartyBuilder result = this.singlePostingParty != null ? this.singlePostingParty : (this.singlePostingParty = SinglePostingParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="datedAsOfDate")
        @RuneAttribute(value="datedAsOfDate")
        public DatedAsOfDate.DatedAsOfDateBuilder getDatedAsOfDate() {
            return this.datedAsOfDate;
        }

        @Override
        public DatedAsOfDate.DatedAsOfDateBuilder getOrCreateDatedAsOfDate() {
            DatedAsOfDate.DatedAsOfDateBuilder result = this.datedAsOfDate != null ? this.datedAsOfDate : (this.datedAsOfDate = DatedAsOfDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cass")
        @RuneAttribute(value="cass")
        public String getCass() {
            return this.cass;
        }

        @Override
        @RosettaAttribute(value="otherCSA")
        @RuneAttribute(value="otherCSA")
        public String getOtherCSA() {
            return this.otherCSA;
        }

        @Override
        @RosettaAttribute(value="legacyAdditionalRepresentations")
        @RuneAttribute(value="legacyAdditionalRepresentations")
        public String getLegacyAdditionalRepresentations() {
            return this.legacyAdditionalRepresentations;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public CollateralValueMethod.CollateralValueMethodBuilder getValue() {
            return this.value;
        }

        @Override
        public CollateralValueMethod.CollateralValueMethodBuilder getOrCreateValue() {
            CollateralValueMethod.CollateralValueMethodBuilder result = this.value != null ? this.value : (this.value = CollateralValueMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalReturns", isRequired=true)
        @RuneAttribute(value="finalReturns", isRequired=true)
        public FinalReturns.FinalReturnsBuilder getFinalReturns() {
            return this.finalReturns;
        }

        @Override
        public FinalReturns.FinalReturnsBuilder getOrCreateFinalReturns() {
            FinalReturns.FinalReturnsBuilder result = this.finalReturns != null ? this.finalReturns : (this.finalReturns = FinalReturns.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regime", isRequired=true)
        @RuneAttribute(value="regime", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setRegime(Regime _regime) {
            this.regime = _regime == null ? null : _regime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="oneWayProvisions", isRequired=true)
        @RuneAttribute(value="oneWayProvisions", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setOneWayProvisions(OneWayProvisions _oneWayProvisions) {
            this.oneWayProvisions = _oneWayProvisions == null ? null : _oneWayProvisions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="generalSimmElections")
        @RuneAttribute(value="generalSimmElections")
        public CreditSupportAgreementElectionsBuilder setGeneralSimmElections(GeneralSimmElections _generalSimmElections) {
            this.generalSimmElections = _generalSimmElections == null ? null : _generalSimmElections.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="identifiedCrossCurrencySwap")
        @RuneAttribute(value="identifiedCrossCurrencySwap")
        public CreditSupportAgreementElectionsBuilder setIdentifiedCrossCurrencySwap(Boolean _identifiedCrossCurrencySwap) {
            this.identifiedCrossCurrencySwap = _identifiedCrossCurrencySwap == null ? null : _identifiedCrossCurrencySwap;
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivityMethodologies", isRequired=true)
        @RuneAttribute(value="sensitivityMethodologies", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setSensitivityMethodologies(SensitivityMethodologies _sensitivityMethodologies) {
            this.sensitivityMethodologies = _sensitivityMethodologies == null ? null : _sensitivityMethodologies.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxHaircutCurrency")
        @RuneAttribute(value="fxHaircutCurrency")
        public CreditSupportAgreementElectionsBuilder setFxHaircutCurrency(FxHaircutCurrency _fxHaircutCurrency) {
            this.fxHaircutCurrency = _fxHaircutCurrency == null ? null : _fxHaircutCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postingObligations", isRequired=true)
        @RuneAttribute(value="postingObligations", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setPostingObligations(PostingObligations _postingObligations) {
            this.postingObligations = _postingObligations == null ? null : _postingObligations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="substitutedRegime")
        @RuneAttribute(value="substitutedRegime")
        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(SubstitutedRegime _substitutedRegime) {
            if (_substitutedRegime != null) {
                this.substitutedRegime.add(_substitutedRegime.toBuilder());
            }
            return this;
        }

        @Override
        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(SubstitutedRegime _substitutedRegime, int idx) {
            this.getIndex(this.substitutedRegime, idx, () -> _substitutedRegime.toBuilder());
            return this;
        }

        @Override
        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(List<? extends SubstitutedRegime> substitutedRegimes) {
            if (substitutedRegimes != null) {
                for (SubstitutedRegime substitutedRegime : substitutedRegimes) {
                    this.substitutedRegime.add(substitutedRegime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="substitutedRegime")
        public CreditSupportAgreementElectionsBuilder setSubstitutedRegime(List<? extends SubstitutedRegime> substitutedRegimes) {
            this.substitutedRegime = substitutedRegimes == null ? new ArrayList<SubstitutedRegime.SubstitutedRegimeBuilder>() : (List)substitutedRegimes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="baseAndEligibleCurrency", isRequired=true)
        @RuneAttribute(value="baseAndEligibleCurrency", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setBaseAndEligibleCurrency(BaseAndEligibleCurrency _baseAndEligibleCurrency) {
            this.baseAndEligibleCurrency = _baseAndEligibleCurrency == null ? null : _baseAndEligibleCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public CreditSupportAgreementElectionsBuilder setAdditionalObligations(String _additionalObligations) {
            this.additionalObligations = _additionalObligations == null ? null : _additionalObligations;
            return this;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setCoveredTransactions(CoveredTransactions _coveredTransactions) {
            this.coveredTransactions = _coveredTransactions == null ? null : _coveredTransactions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligations", isRequired=true)
        @RuneAttribute(value="creditSupportObligations", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setCreditSupportObligations(CreditSupportObligations _creditSupportObligations) {
            this.creditSupportObligations = _creditSupportObligations == null ? null : _creditSupportObligations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeDate")
        @RuneAttribute(value="exchangeDate")
        public CreditSupportAgreementElectionsBuilder setExchangeDate(String _exchangeDate) {
            this.exchangeDate = _exchangeDate == null ? null : _exchangeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationAndTiming", isRequired=true)
        @RuneAttribute(value="calculationAndTiming", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setCalculationAndTiming(CalculationAndTiming _calculationAndTiming) {
            this.calculationAndTiming = _calculationAndTiming == null ? null : _calculationAndTiming.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedent")
        @RuneAttribute(value="conditionsPrecedent")
        public CreditSupportAgreementElectionsBuilder setConditionsPrecedent(ConditionsPrecedent _conditionsPrecedent) {
            this.conditionsPrecedent = _conditionsPrecedent == null ? null : _conditionsPrecedent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="substitution", isRequired=true)
        @RuneAttribute(value="substitution", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setSubstitution(Substitution _substitution) {
            this.substitution = _substitution == null ? null : _substitution.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="disputeResolution", isRequired=true)
        @RuneAttribute(value="disputeResolution", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setDisputeResolution(DisputeResolution _disputeResolution) {
            this.disputeResolution = _disputeResolution == null ? null : _disputeResolution.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        @RuneAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setHoldingAndUsingPostedCollateral(HoldingAndUsingPostedCollateral _holdingAndUsingPostedCollateral) {
            this.holdingAndUsingPostedCollateral = _holdingAndUsingPostedCollateral == null ? null : _holdingAndUsingPostedCollateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rightsEvents", isRequired=true)
        @RuneAttribute(value="rightsEvents", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setRightsEvents(RightsEvents _rightsEvents) {
            this.rightsEvents = _rightsEvents == null ? null : _rightsEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="custodyArrangements")
        @RuneAttribute(value="custodyArrangements")
        public CreditSupportAgreementElectionsBuilder setCustodyArrangements(CustodyArrangements _custodyArrangements) {
            this.custodyArrangements = _custodyArrangements == null ? null : _custodyArrangements.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="distributionAndInterestPayment")
        @RuneAttribute(value="distributionAndInterestPayment")
        public CreditSupportAgreementElectionsBuilder setDistributionAndInterestPayment(DistributionAndInterestPayment _distributionAndInterestPayment) {
            this.distributionAndInterestPayment = _distributionAndInterestPayment == null ? null : _distributionAndInterestPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportOffsets", isRequired=true)
        @RuneAttribute(value="creditSupportOffsets", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setCreditSupportOffsets(Boolean _creditSupportOffsets) {
            this.creditSupportOffsets = _creditSupportOffsets == null ? null : _creditSupportOffsets;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalRepresentations", isRequired=true)
        @RuneAttribute(value="additionalRepresentations", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setAdditionalRepresentations(AdditionalRepresentations _additionalRepresentations) {
            this.additionalRepresentations = _additionalRepresentations == null ? null : _additionalRepresentations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        @RuneAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setOtherEligibleAndPostedSupport(OtherEligibleAndPostedSupport _otherEligibleAndPostedSupport) {
            this.otherEligibleAndPostedSupport = _otherEligibleAndPostedSupport == null ? null : _otherEligibleAndPostedSupport.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="demandsAndNotices")
        @RuneAttribute(value="demandsAndNotices")
        public CreditSupportAgreementElectionsBuilder setDemandsAndNotices(DemandsAndNotices _demandsAndNotices) {
            this.demandsAndNotices = _demandsAndNotices == null ? null : _demandsAndNotices.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="addressesForTransfer")
        @RuneAttribute(value="addressesForTransfer")
        public CreditSupportAgreementElectionsBuilder setAddressesForTransfer(ContactElection _addressesForTransfer) {
            this.addressesForTransfer = _addressesForTransfer == null ? null : _addressesForTransfer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherAgreements")
        @RuneAttribute(value="otherAgreements")
        public CreditSupportAgreementElectionsBuilder setOtherAgreements(OtherAgreements _otherAgreements) {
            this.otherAgreements = _otherAgreements == null ? null : _otherAgreements.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationCurrencyAmendment", isRequired=true)
        @RuneAttribute(value="terminationCurrencyAmendment", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setTerminationCurrencyAmendment(TerminationCurrencyAmendment _terminationCurrencyAmendment) {
            this.terminationCurrencyAmendment = _terminationCurrencyAmendment == null ? null : _terminationCurrencyAmendment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        @RuneAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setMinimumTransferAmountAmendment(MinimumTransferAmountAmendment _minimumTransferAmountAmendment) {
            this.minimumTransferAmountAmendment = _minimumTransferAmountAmendment == null ? null : _minimumTransferAmountAmendment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interpretationTerms")
        @RuneAttribute(value="interpretationTerms")
        public CreditSupportAgreementElectionsBuilder setInterpretationTerms(String _interpretationTerms) {
            this.interpretationTerms = _interpretationTerms == null ? null : _interpretationTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public CreditSupportAgreementElectionsBuilder setProcessAgent(ProcessAgent _processAgent) {
            this.processAgent = _processAgent == null ? null : _processAgent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="appropriatedCollateralValuation")
        @RuneAttribute(value="appropriatedCollateralValuation")
        public CreditSupportAgreementElectionsBuilder setAppropriatedCollateralValuation(AppropriatedCollateralValuation _appropriatedCollateralValuation) {
            this.appropriatedCollateralValuation = _appropriatedCollateralValuation == null ? null : _appropriatedCollateralValuation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="jurisdictionRelatedTerms")
        @RuneAttribute(value="jurisdictionRelatedTerms")
        public CreditSupportAgreementElectionsBuilder setJurisdictionRelatedTerms(JurisdictionRelatedTerms _jurisdictionRelatedTerms) {
            this.jurisdictionRelatedTerms = _jurisdictionRelatedTerms == null ? null : _jurisdictionRelatedTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalAmendments")
        @RuneAttribute(value="additionalAmendments")
        public CreditSupportAgreementElectionsBuilder setAdditionalAmendments(String _additionalAmendments) {
            this.additionalAmendments = _additionalAmendments == null ? null : _additionalAmendments;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public CreditSupportAgreementElectionsBuilder setAdditionalBespokeTerms(String _additionalBespokeTerms) {
            this.additionalBespokeTerms = _additionalBespokeTerms == null ? null : _additionalBespokeTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="trustSchemeAddendum", isRequired=true)
        @RuneAttribute(value="trustSchemeAddendum", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setTrustSchemeAddendum(Boolean _trustSchemeAddendum) {
            this.trustSchemeAddendum = _trustSchemeAddendum == null ? null : _trustSchemeAddendum;
            return this;
        }

        @Override
        @RosettaAttribute(value="securityInterestForObligations", isRequired=true)
        @RuneAttribute(value="securityInterestForObligations", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setSecurityInterestForObligations(SecurityInterestForObligations _securityInterestForObligations) {
            this.securityInterestForObligations = _securityInterestForObligations == null ? null : _securityInterestForObligations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="singlePostingParty")
        @RuneAttribute(value="singlePostingParty")
        public CreditSupportAgreementElectionsBuilder setSinglePostingParty(SinglePostingParty _singlePostingParty) {
            this.singlePostingParty = _singlePostingParty == null ? null : _singlePostingParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="datedAsOfDate")
        @RuneAttribute(value="datedAsOfDate")
        public CreditSupportAgreementElectionsBuilder setDatedAsOfDate(DatedAsOfDate _datedAsOfDate) {
            this.datedAsOfDate = _datedAsOfDate == null ? null : _datedAsOfDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cass")
        @RuneAttribute(value="cass")
        public CreditSupportAgreementElectionsBuilder setCass(String _cass) {
            this.cass = _cass == null ? null : _cass;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherCSA")
        @RuneAttribute(value="otherCSA")
        public CreditSupportAgreementElectionsBuilder setOtherCSA(String _otherCSA) {
            this.otherCSA = _otherCSA == null ? null : _otherCSA;
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyAdditionalRepresentations")
        @RuneAttribute(value="legacyAdditionalRepresentations")
        public CreditSupportAgreementElectionsBuilder setLegacyAdditionalRepresentations(String _legacyAdditionalRepresentations) {
            this.legacyAdditionalRepresentations = _legacyAdditionalRepresentations == null ? null : _legacyAdditionalRepresentations;
            return this;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public CreditSupportAgreementElectionsBuilder setValue(CollateralValueMethod _value) {
            this.value = _value == null ? null : _value.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalReturns", isRequired=true)
        @RuneAttribute(value="finalReturns", isRequired=true)
        public CreditSupportAgreementElectionsBuilder setFinalReturns(FinalReturns _finalReturns) {
            this.finalReturns = _finalReturns == null ? null : _finalReturns.toBuilder();
            return this;
        }

        @Override
        public CreditSupportAgreementElections build() {
            return new CreditSupportAgreementElectionsImpl(this);
        }

        @Override
        public CreditSupportAgreementElectionsBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditSupportAgreementElectionsBuilder prune() {
            if (this.regime != null && !this.regime.prune().hasData()) {
                this.regime = null;
            }
            if (this.oneWayProvisions != null && !this.oneWayProvisions.prune().hasData()) {
                this.oneWayProvisions = null;
            }
            if (this.generalSimmElections != null && !this.generalSimmElections.prune().hasData()) {
                this.generalSimmElections = null;
            }
            if (this.sensitivityMethodologies != null && !this.sensitivityMethodologies.prune().hasData()) {
                this.sensitivityMethodologies = null;
            }
            if (this.fxHaircutCurrency != null && !this.fxHaircutCurrency.prune().hasData()) {
                this.fxHaircutCurrency = null;
            }
            if (this.postingObligations != null && !this.postingObligations.prune().hasData()) {
                this.postingObligations = null;
            }
            this.substitutedRegime = this.substitutedRegime.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.baseAndEligibleCurrency != null && !this.baseAndEligibleCurrency.prune().hasData()) {
                this.baseAndEligibleCurrency = null;
            }
            if (this.coveredTransactions != null && !this.coveredTransactions.prune().hasData()) {
                this.coveredTransactions = null;
            }
            if (this.creditSupportObligations != null && !this.creditSupportObligations.prune().hasData()) {
                this.creditSupportObligations = null;
            }
            if (this.calculationAndTiming != null && !this.calculationAndTiming.prune().hasData()) {
                this.calculationAndTiming = null;
            }
            if (this.conditionsPrecedent != null && !this.conditionsPrecedent.prune().hasData()) {
                this.conditionsPrecedent = null;
            }
            if (this.substitution != null && !this.substitution.prune().hasData()) {
                this.substitution = null;
            }
            if (this.disputeResolution != null && !this.disputeResolution.prune().hasData()) {
                this.disputeResolution = null;
            }
            if (this.holdingAndUsingPostedCollateral != null && !this.holdingAndUsingPostedCollateral.prune().hasData()) {
                this.holdingAndUsingPostedCollateral = null;
            }
            if (this.rightsEvents != null && !this.rightsEvents.prune().hasData()) {
                this.rightsEvents = null;
            }
            if (this.custodyArrangements != null && !this.custodyArrangements.prune().hasData()) {
                this.custodyArrangements = null;
            }
            if (this.distributionAndInterestPayment != null && !this.distributionAndInterestPayment.prune().hasData()) {
                this.distributionAndInterestPayment = null;
            }
            if (this.additionalRepresentations != null && !this.additionalRepresentations.prune().hasData()) {
                this.additionalRepresentations = null;
            }
            if (this.otherEligibleAndPostedSupport != null && !this.otherEligibleAndPostedSupport.prune().hasData()) {
                this.otherEligibleAndPostedSupport = null;
            }
            if (this.demandsAndNotices != null && !this.demandsAndNotices.prune().hasData()) {
                this.demandsAndNotices = null;
            }
            if (this.addressesForTransfer != null && !this.addressesForTransfer.prune().hasData()) {
                this.addressesForTransfer = null;
            }
            if (this.otherAgreements != null && !this.otherAgreements.prune().hasData()) {
                this.otherAgreements = null;
            }
            if (this.terminationCurrencyAmendment != null && !this.terminationCurrencyAmendment.prune().hasData()) {
                this.terminationCurrencyAmendment = null;
            }
            if (this.minimumTransferAmountAmendment != null && !this.minimumTransferAmountAmendment.prune().hasData()) {
                this.minimumTransferAmountAmendment = null;
            }
            if (this.processAgent != null && !this.processAgent.prune().hasData()) {
                this.processAgent = null;
            }
            if (this.appropriatedCollateralValuation != null && !this.appropriatedCollateralValuation.prune().hasData()) {
                this.appropriatedCollateralValuation = null;
            }
            if (this.jurisdictionRelatedTerms != null && !this.jurisdictionRelatedTerms.prune().hasData()) {
                this.jurisdictionRelatedTerms = null;
            }
            if (this.securityInterestForObligations != null && !this.securityInterestForObligations.prune().hasData()) {
                this.securityInterestForObligations = null;
            }
            if (this.singlePostingParty != null && !this.singlePostingParty.prune().hasData()) {
                this.singlePostingParty = null;
            }
            if (this.datedAsOfDate != null && !this.datedAsOfDate.prune().hasData()) {
                this.datedAsOfDate = null;
            }
            if (this.value != null && !this.value.prune().hasData()) {
                this.value = null;
            }
            if (this.finalReturns != null && !this.finalReturns.prune().hasData()) {
                this.finalReturns = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRegime() != null && this.getRegime().hasData()) {
                return true;
            }
            if (this.getOneWayProvisions() != null && this.getOneWayProvisions().hasData()) {
                return true;
            }
            if (this.getGeneralSimmElections() != null && this.getGeneralSimmElections().hasData()) {
                return true;
            }
            if (this.getIdentifiedCrossCurrencySwap() != null) {
                return true;
            }
            if (this.getSensitivityMethodologies() != null && this.getSensitivityMethodologies().hasData()) {
                return true;
            }
            if (this.getFxHaircutCurrency() != null && this.getFxHaircutCurrency().hasData()) {
                return true;
            }
            if (this.getPostingObligations() != null && this.getPostingObligations().hasData()) {
                return true;
            }
            if (this.getSubstitutedRegime() != null && this.getSubstitutedRegime().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBaseAndEligibleCurrency() != null && this.getBaseAndEligibleCurrency().hasData()) {
                return true;
            }
            if (this.getAdditionalObligations() != null) {
                return true;
            }
            if (this.getCoveredTransactions() != null && this.getCoveredTransactions().hasData()) {
                return true;
            }
            if (this.getCreditSupportObligations() != null && this.getCreditSupportObligations().hasData()) {
                return true;
            }
            if (this.getExchangeDate() != null) {
                return true;
            }
            if (this.getCalculationAndTiming() != null && this.getCalculationAndTiming().hasData()) {
                return true;
            }
            if (this.getConditionsPrecedent() != null && this.getConditionsPrecedent().hasData()) {
                return true;
            }
            if (this.getSubstitution() != null && this.getSubstitution().hasData()) {
                return true;
            }
            if (this.getDisputeResolution() != null && this.getDisputeResolution().hasData()) {
                return true;
            }
            if (this.getHoldingAndUsingPostedCollateral() != null && this.getHoldingAndUsingPostedCollateral().hasData()) {
                return true;
            }
            if (this.getRightsEvents() != null && this.getRightsEvents().hasData()) {
                return true;
            }
            if (this.getCustodyArrangements() != null && this.getCustodyArrangements().hasData()) {
                return true;
            }
            if (this.getDistributionAndInterestPayment() != null && this.getDistributionAndInterestPayment().hasData()) {
                return true;
            }
            if (this.getCreditSupportOffsets() != null) {
                return true;
            }
            if (this.getAdditionalRepresentations() != null && this.getAdditionalRepresentations().hasData()) {
                return true;
            }
            if (this.getOtherEligibleAndPostedSupport() != null && this.getOtherEligibleAndPostedSupport().hasData()) {
                return true;
            }
            if (this.getDemandsAndNotices() != null && this.getDemandsAndNotices().hasData()) {
                return true;
            }
            if (this.getAddressesForTransfer() != null && this.getAddressesForTransfer().hasData()) {
                return true;
            }
            if (this.getOtherAgreements() != null && this.getOtherAgreements().hasData()) {
                return true;
            }
            if (this.getTerminationCurrencyAmendment() != null && this.getTerminationCurrencyAmendment().hasData()) {
                return true;
            }
            if (this.getMinimumTransferAmountAmendment() != null && this.getMinimumTransferAmountAmendment().hasData()) {
                return true;
            }
            if (this.getInterpretationTerms() != null) {
                return true;
            }
            if (this.getProcessAgent() != null && this.getProcessAgent().hasData()) {
                return true;
            }
            if (this.getAppropriatedCollateralValuation() != null && this.getAppropriatedCollateralValuation().hasData()) {
                return true;
            }
            if (this.getJurisdictionRelatedTerms() != null && this.getJurisdictionRelatedTerms().hasData()) {
                return true;
            }
            if (this.getAdditionalAmendments() != null) {
                return true;
            }
            if (this.getAdditionalBespokeTerms() != null) {
                return true;
            }
            if (this.getTrustSchemeAddendum() != null) {
                return true;
            }
            if (this.getSecurityInterestForObligations() != null && this.getSecurityInterestForObligations().hasData()) {
                return true;
            }
            if (this.getSinglePostingParty() != null && this.getSinglePostingParty().hasData()) {
                return true;
            }
            if (this.getDatedAsOfDate() != null && this.getDatedAsOfDate().hasData()) {
                return true;
            }
            if (this.getCass() != null) {
                return true;
            }
            if (this.getOtherCSA() != null) {
                return true;
            }
            if (this.getLegacyAdditionalRepresentations() != null) {
                return true;
            }
            if (this.getValue() != null && this.getValue().hasData()) {
                return true;
            }
            return this.getFinalReturns() != null && this.getFinalReturns().hasData();
        }

        public CreditSupportAgreementElectionsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditSupportAgreementElectionsBuilder o = (CreditSupportAgreementElectionsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegime(), (RosettaModelObjectBuilder)o.getRegime(), this::setRegime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOneWayProvisions(), (RosettaModelObjectBuilder)o.getOneWayProvisions(), this::setOneWayProvisions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGeneralSimmElections(), (RosettaModelObjectBuilder)o.getGeneralSimmElections(), this::setGeneralSimmElections);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSensitivityMethodologies(), (RosettaModelObjectBuilder)o.getSensitivityMethodologies(), this::setSensitivityMethodologies);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxHaircutCurrency(), (RosettaModelObjectBuilder)o.getFxHaircutCurrency(), this::setFxHaircutCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPostingObligations(), (RosettaModelObjectBuilder)o.getPostingObligations(), this::setPostingObligations);
            merger.mergeRosetta(this.getSubstitutedRegime(), o.getSubstitutedRegime(), this::getOrCreateSubstitutedRegime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBaseAndEligibleCurrency(), (RosettaModelObjectBuilder)o.getBaseAndEligibleCurrency(), this::setBaseAndEligibleCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCoveredTransactions(), (RosettaModelObjectBuilder)o.getCoveredTransactions(), this::setCoveredTransactions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportObligations(), (RosettaModelObjectBuilder)o.getCreditSupportObligations(), this::setCreditSupportObligations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAndTiming(), (RosettaModelObjectBuilder)o.getCalculationAndTiming(), this::setCalculationAndTiming);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConditionsPrecedent(), (RosettaModelObjectBuilder)o.getConditionsPrecedent(), this::setConditionsPrecedent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSubstitution(), (RosettaModelObjectBuilder)o.getSubstitution(), this::setSubstitution);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDisputeResolution(), (RosettaModelObjectBuilder)o.getDisputeResolution(), this::setDisputeResolution);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getHoldingAndUsingPostedCollateral(), (RosettaModelObjectBuilder)o.getHoldingAndUsingPostedCollateral(), this::setHoldingAndUsingPostedCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRightsEvents(), (RosettaModelObjectBuilder)o.getRightsEvents(), this::setRightsEvents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCustodyArrangements(), (RosettaModelObjectBuilder)o.getCustodyArrangements(), this::setCustodyArrangements);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDistributionAndInterestPayment(), (RosettaModelObjectBuilder)o.getDistributionAndInterestPayment(), this::setDistributionAndInterestPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalRepresentations(), (RosettaModelObjectBuilder)o.getAdditionalRepresentations(), this::setAdditionalRepresentations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOtherEligibleAndPostedSupport(), (RosettaModelObjectBuilder)o.getOtherEligibleAndPostedSupport(), this::setOtherEligibleAndPostedSupport);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDemandsAndNotices(), (RosettaModelObjectBuilder)o.getDemandsAndNotices(), this::setDemandsAndNotices);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAddressesForTransfer(), (RosettaModelObjectBuilder)o.getAddressesForTransfer(), this::setAddressesForTransfer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOtherAgreements(), (RosettaModelObjectBuilder)o.getOtherAgreements(), this::setOtherAgreements);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationCurrencyAmendment(), (RosettaModelObjectBuilder)o.getTerminationCurrencyAmendment(), this::setTerminationCurrencyAmendment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumTransferAmountAmendment(), (RosettaModelObjectBuilder)o.getMinimumTransferAmountAmendment(), this::setMinimumTransferAmountAmendment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProcessAgent(), (RosettaModelObjectBuilder)o.getProcessAgent(), this::setProcessAgent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAppropriatedCollateralValuation(), (RosettaModelObjectBuilder)o.getAppropriatedCollateralValuation(), this::setAppropriatedCollateralValuation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getJurisdictionRelatedTerms(), (RosettaModelObjectBuilder)o.getJurisdictionRelatedTerms(), this::setJurisdictionRelatedTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurityInterestForObligations(), (RosettaModelObjectBuilder)o.getSecurityInterestForObligations(), this::setSecurityInterestForObligations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSinglePostingParty(), (RosettaModelObjectBuilder)o.getSinglePostingParty(), this::setSinglePostingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDatedAsOfDate(), (RosettaModelObjectBuilder)o.getDatedAsOfDate(), this::setDatedAsOfDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValue(), (RosettaModelObjectBuilder)o.getValue(), this::setValue);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalReturns(), (RosettaModelObjectBuilder)o.getFinalReturns(), this::setFinalReturns);
            merger.mergeBasic((Object)this.getIdentifiedCrossCurrencySwap(), (Object)o.getIdentifiedCrossCurrencySwap(), this::setIdentifiedCrossCurrencySwap, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalObligations(), (Object)o.getAdditionalObligations(), this::setAdditionalObligations, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeDate(), (Object)o.getExchangeDate(), this::setExchangeDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCreditSupportOffsets(), (Object)o.getCreditSupportOffsets(), this::setCreditSupportOffsets, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInterpretationTerms(), (Object)o.getInterpretationTerms(), this::setInterpretationTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalAmendments(), (Object)o.getAdditionalAmendments(), this::setAdditionalAmendments, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdditionalBespokeTerms(), (Object)o.getAdditionalBespokeTerms(), this::setAdditionalBespokeTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTrustSchemeAddendum(), (Object)o.getTrustSchemeAddendum(), this::setTrustSchemeAddendum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCass(), (Object)o.getCass(), this::setCass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOtherCSA(), (Object)o.getOtherCSA(), this::setOtherCSA, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLegacyAdditionalRepresentations(), (Object)o.getLegacyAdditionalRepresentations(), this::setLegacyAdditionalRepresentations, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportAgreementElections _that = this.getType().cast(o);
            if (!Objects.equals(this.regime, _that.getRegime())) {
                return false;
            }
            if (!Objects.equals(this.oneWayProvisions, _that.getOneWayProvisions())) {
                return false;
            }
            if (!Objects.equals(this.generalSimmElections, _that.getGeneralSimmElections())) {
                return false;
            }
            if (!Objects.equals(this.identifiedCrossCurrencySwap, _that.getIdentifiedCrossCurrencySwap())) {
                return false;
            }
            if (!Objects.equals(this.sensitivityMethodologies, _that.getSensitivityMethodologies())) {
                return false;
            }
            if (!Objects.equals(this.fxHaircutCurrency, _that.getFxHaircutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.postingObligations, _that.getPostingObligations())) {
                return false;
            }
            if (!ListEquals.listEquals(this.substitutedRegime, _that.getSubstitutedRegime())) {
                return false;
            }
            if (!Objects.equals(this.baseAndEligibleCurrency, _that.getBaseAndEligibleCurrency())) {
                return false;
            }
            if (!Objects.equals(this.additionalObligations, _that.getAdditionalObligations())) {
                return false;
            }
            if (!Objects.equals(this.coveredTransactions, _that.getCoveredTransactions())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportObligations, _that.getCreditSupportObligations())) {
                return false;
            }
            if (!Objects.equals(this.exchangeDate, _that.getExchangeDate())) {
                return false;
            }
            if (!Objects.equals(this.calculationAndTiming, _that.getCalculationAndTiming())) {
                return false;
            }
            if (!Objects.equals(this.conditionsPrecedent, _that.getConditionsPrecedent())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            if (!Objects.equals(this.disputeResolution, _that.getDisputeResolution())) {
                return false;
            }
            if (!Objects.equals(this.holdingAndUsingPostedCollateral, _that.getHoldingAndUsingPostedCollateral())) {
                return false;
            }
            if (!Objects.equals(this.rightsEvents, _that.getRightsEvents())) {
                return false;
            }
            if (!Objects.equals(this.custodyArrangements, _that.getCustodyArrangements())) {
                return false;
            }
            if (!Objects.equals(this.distributionAndInterestPayment, _that.getDistributionAndInterestPayment())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportOffsets, _that.getCreditSupportOffsets())) {
                return false;
            }
            if (!Objects.equals(this.additionalRepresentations, _that.getAdditionalRepresentations())) {
                return false;
            }
            if (!Objects.equals(this.otherEligibleAndPostedSupport, _that.getOtherEligibleAndPostedSupport())) {
                return false;
            }
            if (!Objects.equals(this.demandsAndNotices, _that.getDemandsAndNotices())) {
                return false;
            }
            if (!Objects.equals(this.addressesForTransfer, _that.getAddressesForTransfer())) {
                return false;
            }
            if (!Objects.equals(this.otherAgreements, _that.getOtherAgreements())) {
                return false;
            }
            if (!Objects.equals(this.terminationCurrencyAmendment, _that.getTerminationCurrencyAmendment())) {
                return false;
            }
            if (!Objects.equals(this.minimumTransferAmountAmendment, _that.getMinimumTransferAmountAmendment())) {
                return false;
            }
            if (!Objects.equals(this.interpretationTerms, _that.getInterpretationTerms())) {
                return false;
            }
            if (!Objects.equals(this.processAgent, _that.getProcessAgent())) {
                return false;
            }
            if (!Objects.equals(this.appropriatedCollateralValuation, _that.getAppropriatedCollateralValuation())) {
                return false;
            }
            if (!Objects.equals(this.jurisdictionRelatedTerms, _that.getJurisdictionRelatedTerms())) {
                return false;
            }
            if (!Objects.equals(this.additionalAmendments, _that.getAdditionalAmendments())) {
                return false;
            }
            if (!Objects.equals(this.additionalBespokeTerms, _that.getAdditionalBespokeTerms())) {
                return false;
            }
            if (!Objects.equals(this.trustSchemeAddendum, _that.getTrustSchemeAddendum())) {
                return false;
            }
            if (!Objects.equals(this.securityInterestForObligations, _that.getSecurityInterestForObligations())) {
                return false;
            }
            if (!Objects.equals(this.singlePostingParty, _that.getSinglePostingParty())) {
                return false;
            }
            if (!Objects.equals(this.datedAsOfDate, _that.getDatedAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.cass, _that.getCass())) {
                return false;
            }
            if (!Objects.equals(this.otherCSA, _that.getOtherCSA())) {
                return false;
            }
            if (!Objects.equals(this.legacyAdditionalRepresentations, _that.getLegacyAdditionalRepresentations())) {
                return false;
            }
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return Objects.equals(this.finalReturns, _that.getFinalReturns());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regime != null ? this.regime.hashCode() : 0);
            _result = 31 * _result + (this.oneWayProvisions != null ? this.oneWayProvisions.hashCode() : 0);
            _result = 31 * _result + (this.generalSimmElections != null ? this.generalSimmElections.hashCode() : 0);
            _result = 31 * _result + (this.identifiedCrossCurrencySwap != null ? this.identifiedCrossCurrencySwap.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityMethodologies != null ? this.sensitivityMethodologies.hashCode() : 0);
            _result = 31 * _result + (this.fxHaircutCurrency != null ? this.fxHaircutCurrency.hashCode() : 0);
            _result = 31 * _result + (this.postingObligations != null ? this.postingObligations.hashCode() : 0);
            _result = 31 * _result + (this.substitutedRegime != null ? this.substitutedRegime.hashCode() : 0);
            _result = 31 * _result + (this.baseAndEligibleCurrency != null ? this.baseAndEligibleCurrency.hashCode() : 0);
            _result = 31 * _result + (this.additionalObligations != null ? this.additionalObligations.hashCode() : 0);
            _result = 31 * _result + (this.coveredTransactions != null ? this.coveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportObligations != null ? this.creditSupportObligations.hashCode() : 0);
            _result = 31 * _result + (this.exchangeDate != null ? this.exchangeDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationAndTiming != null ? this.calculationAndTiming.hashCode() : 0);
            _result = 31 * _result + (this.conditionsPrecedent != null ? this.conditionsPrecedent.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.disputeResolution != null ? this.disputeResolution.hashCode() : 0);
            _result = 31 * _result + (this.holdingAndUsingPostedCollateral != null ? this.holdingAndUsingPostedCollateral.hashCode() : 0);
            _result = 31 * _result + (this.rightsEvents != null ? this.rightsEvents.hashCode() : 0);
            _result = 31 * _result + (this.custodyArrangements != null ? this.custodyArrangements.hashCode() : 0);
            _result = 31 * _result + (this.distributionAndInterestPayment != null ? this.distributionAndInterestPayment.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportOffsets != null ? this.creditSupportOffsets.hashCode() : 0);
            _result = 31 * _result + (this.additionalRepresentations != null ? this.additionalRepresentations.hashCode() : 0);
            _result = 31 * _result + (this.otherEligibleAndPostedSupport != null ? this.otherEligibleAndPostedSupport.hashCode() : 0);
            _result = 31 * _result + (this.demandsAndNotices != null ? this.demandsAndNotices.hashCode() : 0);
            _result = 31 * _result + (this.addressesForTransfer != null ? this.addressesForTransfer.hashCode() : 0);
            _result = 31 * _result + (this.otherAgreements != null ? this.otherAgreements.hashCode() : 0);
            _result = 31 * _result + (this.terminationCurrencyAmendment != null ? this.terminationCurrencyAmendment.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmountAmendment != null ? this.minimumTransferAmountAmendment.hashCode() : 0);
            _result = 31 * _result + (this.interpretationTerms != null ? this.interpretationTerms.hashCode() : 0);
            _result = 31 * _result + (this.processAgent != null ? this.processAgent.hashCode() : 0);
            _result = 31 * _result + (this.appropriatedCollateralValuation != null ? this.appropriatedCollateralValuation.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionRelatedTerms != null ? this.jurisdictionRelatedTerms.hashCode() : 0);
            _result = 31 * _result + (this.additionalAmendments != null ? this.additionalAmendments.hashCode() : 0);
            _result = 31 * _result + (this.additionalBespokeTerms != null ? this.additionalBespokeTerms.hashCode() : 0);
            _result = 31 * _result + (this.trustSchemeAddendum != null ? this.trustSchemeAddendum.hashCode() : 0);
            _result = 31 * _result + (this.securityInterestForObligations != null ? this.securityInterestForObligations.hashCode() : 0);
            _result = 31 * _result + (this.singlePostingParty != null ? this.singlePostingParty.hashCode() : 0);
            _result = 31 * _result + (this.datedAsOfDate != null ? this.datedAsOfDate.hashCode() : 0);
            _result = 31 * _result + (this.cass != null ? this.cass.hashCode() : 0);
            _result = 31 * _result + (this.otherCSA != null ? this.otherCSA.hashCode() : 0);
            _result = 31 * _result + (this.legacyAdditionalRepresentations != null ? this.legacyAdditionalRepresentations.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.finalReturns != null ? this.finalReturns.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportAgreementElectionsBuilder {regime=" + this.regime + ", oneWayProvisions=" + this.oneWayProvisions + ", generalSimmElections=" + this.generalSimmElections + ", identifiedCrossCurrencySwap=" + this.identifiedCrossCurrencySwap + ", sensitivityMethodologies=" + this.sensitivityMethodologies + ", fxHaircutCurrency=" + this.fxHaircutCurrency + ", postingObligations=" + this.postingObligations + ", substitutedRegime=" + this.substitutedRegime + ", baseAndEligibleCurrency=" + this.baseAndEligibleCurrency + ", additionalObligations=" + this.additionalObligations + ", coveredTransactions=" + this.coveredTransactions + ", creditSupportObligations=" + this.creditSupportObligations + ", exchangeDate=" + this.exchangeDate + ", calculationAndTiming=" + this.calculationAndTiming + ", conditionsPrecedent=" + this.conditionsPrecedent + ", substitution=" + this.substitution + ", disputeResolution=" + this.disputeResolution + ", holdingAndUsingPostedCollateral=" + this.holdingAndUsingPostedCollateral + ", rightsEvents=" + this.rightsEvents + ", custodyArrangements=" + this.custodyArrangements + ", distributionAndInterestPayment=" + this.distributionAndInterestPayment + ", creditSupportOffsets=" + this.creditSupportOffsets + ", additionalRepresentations=" + this.additionalRepresentations + ", otherEligibleAndPostedSupport=" + this.otherEligibleAndPostedSupport + ", demandsAndNotices=" + this.demandsAndNotices + ", addressesForTransfer=" + this.addressesForTransfer + ", otherAgreements=" + this.otherAgreements + ", terminationCurrencyAmendment=" + this.terminationCurrencyAmendment + ", minimumTransferAmountAmendment=" + this.minimumTransferAmountAmendment + ", interpretationTerms=" + this.interpretationTerms + ", processAgent=" + this.processAgent + ", appropriatedCollateralValuation=" + this.appropriatedCollateralValuation + ", jurisdictionRelatedTerms=" + this.jurisdictionRelatedTerms + ", additionalAmendments=" + this.additionalAmendments + ", additionalBespokeTerms=" + this.additionalBespokeTerms + ", trustSchemeAddendum=" + this.trustSchemeAddendum + ", securityInterestForObligations=" + this.securityInterestForObligations + ", singlePostingParty=" + this.singlePostingParty + ", datedAsOfDate=" + this.datedAsOfDate + ", cass=" + this.cass + ", otherCSA=" + this.otherCSA + ", legacyAdditionalRepresentations=" + this.legacyAdditionalRepresentations + ", value=" + this.value + ", finalReturns=" + this.finalReturns + '}';
        }
    }

    public static interface CreditSupportAgreementElectionsBuilder
    extends CreditSupportAgreementElections,
    RosettaModelObjectBuilder {
        public Regime.RegimeBuilder getOrCreateRegime();

        @Override
        public Regime.RegimeBuilder getRegime();

        public OneWayProvisions.OneWayProvisionsBuilder getOrCreateOneWayProvisions();

        @Override
        public OneWayProvisions.OneWayProvisionsBuilder getOneWayProvisions();

        public GeneralSimmElections.GeneralSimmElectionsBuilder getOrCreateGeneralSimmElections();

        @Override
        public GeneralSimmElections.GeneralSimmElectionsBuilder getGeneralSimmElections();

        public SensitivityMethodologies.SensitivityMethodologiesBuilder getOrCreateSensitivityMethodologies();

        @Override
        public SensitivityMethodologies.SensitivityMethodologiesBuilder getSensitivityMethodologies();

        public FxHaircutCurrency.FxHaircutCurrencyBuilder getOrCreateFxHaircutCurrency();

        @Override
        public FxHaircutCurrency.FxHaircutCurrencyBuilder getFxHaircutCurrency();

        public PostingObligations.PostingObligationsBuilder getOrCreatePostingObligations();

        @Override
        public PostingObligations.PostingObligationsBuilder getPostingObligations();

        public SubstitutedRegime.SubstitutedRegimeBuilder getOrCreateSubstitutedRegime(int var1);

        public List<? extends SubstitutedRegime.SubstitutedRegimeBuilder> getSubstitutedRegime();

        public BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder getOrCreateBaseAndEligibleCurrency();

        @Override
        public BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder getBaseAndEligibleCurrency();

        public CoveredTransactions.CoveredTransactionsBuilder getOrCreateCoveredTransactions();

        @Override
        public CoveredTransactions.CoveredTransactionsBuilder getCoveredTransactions();

        public CreditSupportObligations.CreditSupportObligationsBuilder getOrCreateCreditSupportObligations();

        @Override
        public CreditSupportObligations.CreditSupportObligationsBuilder getCreditSupportObligations();

        public CalculationAndTiming.CalculationAndTimingBuilder getOrCreateCalculationAndTiming();

        @Override
        public CalculationAndTiming.CalculationAndTimingBuilder getCalculationAndTiming();

        public ConditionsPrecedent.ConditionsPrecedentBuilder getOrCreateConditionsPrecedent();

        @Override
        public ConditionsPrecedent.ConditionsPrecedentBuilder getConditionsPrecedent();

        public Substitution.SubstitutionBuilder getOrCreateSubstitution();

        @Override
        public Substitution.SubstitutionBuilder getSubstitution();

        public DisputeResolution.DisputeResolutionBuilder getOrCreateDisputeResolution();

        @Override
        public DisputeResolution.DisputeResolutionBuilder getDisputeResolution();

        public HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder getOrCreateHoldingAndUsingPostedCollateral();

        @Override
        public HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder getHoldingAndUsingPostedCollateral();

        public RightsEvents.RightsEventsBuilder getOrCreateRightsEvents();

        @Override
        public RightsEvents.RightsEventsBuilder getRightsEvents();

        public CustodyArrangements.CustodyArrangementsBuilder getOrCreateCustodyArrangements();

        @Override
        public CustodyArrangements.CustodyArrangementsBuilder getCustodyArrangements();

        public DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder getOrCreateDistributionAndInterestPayment();

        @Override
        public DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder getDistributionAndInterestPayment();

        public AdditionalRepresentations.AdditionalRepresentationsBuilder getOrCreateAdditionalRepresentations();

        @Override
        public AdditionalRepresentations.AdditionalRepresentationsBuilder getAdditionalRepresentations();

        public OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder getOrCreateOtherEligibleAndPostedSupport();

        @Override
        public OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder getOtherEligibleAndPostedSupport();

        public DemandsAndNotices.DemandsAndNoticesBuilder getOrCreateDemandsAndNotices();

        @Override
        public DemandsAndNotices.DemandsAndNoticesBuilder getDemandsAndNotices();

        public ContactElection.ContactElectionBuilder getOrCreateAddressesForTransfer();

        @Override
        public ContactElection.ContactElectionBuilder getAddressesForTransfer();

        public OtherAgreements.OtherAgreementsBuilder getOrCreateOtherAgreements();

        @Override
        public OtherAgreements.OtherAgreementsBuilder getOtherAgreements();

        public TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder getOrCreateTerminationCurrencyAmendment();

        @Override
        public TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder getTerminationCurrencyAmendment();

        public MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder getOrCreateMinimumTransferAmountAmendment();

        @Override
        public MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder getMinimumTransferAmountAmendment();

        public ProcessAgent.ProcessAgentBuilder getOrCreateProcessAgent();

        @Override
        public ProcessAgent.ProcessAgentBuilder getProcessAgent();

        public AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder getOrCreateAppropriatedCollateralValuation();

        @Override
        public AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder getAppropriatedCollateralValuation();

        public JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder getOrCreateJurisdictionRelatedTerms();

        @Override
        public JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder getJurisdictionRelatedTerms();

        public SecurityInterestForObligations.SecurityInterestForObligationsBuilder getOrCreateSecurityInterestForObligations();

        @Override
        public SecurityInterestForObligations.SecurityInterestForObligationsBuilder getSecurityInterestForObligations();

        public SinglePostingParty.SinglePostingPartyBuilder getOrCreateSinglePostingParty();

        @Override
        public SinglePostingParty.SinglePostingPartyBuilder getSinglePostingParty();

        public DatedAsOfDate.DatedAsOfDateBuilder getOrCreateDatedAsOfDate();

        @Override
        public DatedAsOfDate.DatedAsOfDateBuilder getDatedAsOfDate();

        public CollateralValueMethod.CollateralValueMethodBuilder getOrCreateValue();

        @Override
        public CollateralValueMethod.CollateralValueMethodBuilder getValue();

        public FinalReturns.FinalReturnsBuilder getOrCreateFinalReturns();

        @Override
        public FinalReturns.FinalReturnsBuilder getFinalReturns();

        public CreditSupportAgreementElectionsBuilder setRegime(Regime var1);

        public CreditSupportAgreementElectionsBuilder setOneWayProvisions(OneWayProvisions var1);

        public CreditSupportAgreementElectionsBuilder setGeneralSimmElections(GeneralSimmElections var1);

        public CreditSupportAgreementElectionsBuilder setIdentifiedCrossCurrencySwap(Boolean var1);

        public CreditSupportAgreementElectionsBuilder setSensitivityMethodologies(SensitivityMethodologies var1);

        public CreditSupportAgreementElectionsBuilder setFxHaircutCurrency(FxHaircutCurrency var1);

        public CreditSupportAgreementElectionsBuilder setPostingObligations(PostingObligations var1);

        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(SubstitutedRegime var1);

        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(SubstitutedRegime var1, int var2);

        public CreditSupportAgreementElectionsBuilder addSubstitutedRegime(List<? extends SubstitutedRegime> var1);

        public CreditSupportAgreementElectionsBuilder setSubstitutedRegime(List<? extends SubstitutedRegime> var1);

        public CreditSupportAgreementElectionsBuilder setBaseAndEligibleCurrency(BaseAndEligibleCurrency var1);

        public CreditSupportAgreementElectionsBuilder setAdditionalObligations(String var1);

        public CreditSupportAgreementElectionsBuilder setCoveredTransactions(CoveredTransactions var1);

        public CreditSupportAgreementElectionsBuilder setCreditSupportObligations(CreditSupportObligations var1);

        public CreditSupportAgreementElectionsBuilder setExchangeDate(String var1);

        public CreditSupportAgreementElectionsBuilder setCalculationAndTiming(CalculationAndTiming var1);

        public CreditSupportAgreementElectionsBuilder setConditionsPrecedent(ConditionsPrecedent var1);

        public CreditSupportAgreementElectionsBuilder setSubstitution(Substitution var1);

        public CreditSupportAgreementElectionsBuilder setDisputeResolution(DisputeResolution var1);

        public CreditSupportAgreementElectionsBuilder setHoldingAndUsingPostedCollateral(HoldingAndUsingPostedCollateral var1);

        public CreditSupportAgreementElectionsBuilder setRightsEvents(RightsEvents var1);

        public CreditSupportAgreementElectionsBuilder setCustodyArrangements(CustodyArrangements var1);

        public CreditSupportAgreementElectionsBuilder setDistributionAndInterestPayment(DistributionAndInterestPayment var1);

        public CreditSupportAgreementElectionsBuilder setCreditSupportOffsets(Boolean var1);

        public CreditSupportAgreementElectionsBuilder setAdditionalRepresentations(AdditionalRepresentations var1);

        public CreditSupportAgreementElectionsBuilder setOtherEligibleAndPostedSupport(OtherEligibleAndPostedSupport var1);

        public CreditSupportAgreementElectionsBuilder setDemandsAndNotices(DemandsAndNotices var1);

        public CreditSupportAgreementElectionsBuilder setAddressesForTransfer(ContactElection var1);

        public CreditSupportAgreementElectionsBuilder setOtherAgreements(OtherAgreements var1);

        public CreditSupportAgreementElectionsBuilder setTerminationCurrencyAmendment(TerminationCurrencyAmendment var1);

        public CreditSupportAgreementElectionsBuilder setMinimumTransferAmountAmendment(MinimumTransferAmountAmendment var1);

        public CreditSupportAgreementElectionsBuilder setInterpretationTerms(String var1);

        public CreditSupportAgreementElectionsBuilder setProcessAgent(ProcessAgent var1);

        public CreditSupportAgreementElectionsBuilder setAppropriatedCollateralValuation(AppropriatedCollateralValuation var1);

        public CreditSupportAgreementElectionsBuilder setJurisdictionRelatedTerms(JurisdictionRelatedTerms var1);

        public CreditSupportAgreementElectionsBuilder setAdditionalAmendments(String var1);

        public CreditSupportAgreementElectionsBuilder setAdditionalBespokeTerms(String var1);

        public CreditSupportAgreementElectionsBuilder setTrustSchemeAddendum(Boolean var1);

        public CreditSupportAgreementElectionsBuilder setSecurityInterestForObligations(SecurityInterestForObligations var1);

        public CreditSupportAgreementElectionsBuilder setSinglePostingParty(SinglePostingParty var1);

        public CreditSupportAgreementElectionsBuilder setDatedAsOfDate(DatedAsOfDate var1);

        public CreditSupportAgreementElectionsBuilder setCass(String var1);

        public CreditSupportAgreementElectionsBuilder setOtherCSA(String var1);

        public CreditSupportAgreementElectionsBuilder setLegacyAdditionalRepresentations(String var1);

        public CreditSupportAgreementElectionsBuilder setValue(CollateralValueMethod var1);

        public CreditSupportAgreementElectionsBuilder setFinalReturns(FinalReturns var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("regime"), processor, Regime.RegimeBuilder.class, this.getRegime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("oneWayProvisions"), processor, OneWayProvisions.OneWayProvisionsBuilder.class, this.getOneWayProvisions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("generalSimmElections"), processor, GeneralSimmElections.GeneralSimmElectionsBuilder.class, this.getGeneralSimmElections(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("identifiedCrossCurrencySwap"), Boolean.class, (Object)this.getIdentifiedCrossCurrencySwap(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivityMethodologies"), processor, SensitivityMethodologies.SensitivityMethodologiesBuilder.class, this.getSensitivityMethodologies(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxHaircutCurrency"), processor, FxHaircutCurrency.FxHaircutCurrencyBuilder.class, this.getFxHaircutCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("postingObligations"), processor, PostingObligations.PostingObligationsBuilder.class, this.getPostingObligations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("substitutedRegime"), processor, SubstitutedRegime.SubstitutedRegimeBuilder.class, this.getSubstitutedRegime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseAndEligibleCurrency"), processor, BaseAndEligibleCurrency.BaseAndEligibleCurrencyBuilder.class, this.getBaseAndEligibleCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalObligations"), String.class, (Object)this.getAdditionalObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coveredTransactions"), processor, CoveredTransactions.CoveredTransactionsBuilder.class, this.getCoveredTransactions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportObligations"), processor, CreditSupportObligations.CreditSupportObligationsBuilder.class, this.getCreditSupportObligations(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeDate"), String.class, (Object)this.getExchangeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationAndTiming"), processor, CalculationAndTiming.CalculationAndTimingBuilder.class, this.getCalculationAndTiming(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("conditionsPrecedent"), processor, ConditionsPrecedent.ConditionsPrecedentBuilder.class, this.getConditionsPrecedent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("substitution"), processor, Substitution.SubstitutionBuilder.class, this.getSubstitution(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("disputeResolution"), processor, DisputeResolution.DisputeResolutionBuilder.class, this.getDisputeResolution(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("holdingAndUsingPostedCollateral"), processor, HoldingAndUsingPostedCollateral.HoldingAndUsingPostedCollateralBuilder.class, this.getHoldingAndUsingPostedCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rightsEvents"), processor, RightsEvents.RightsEventsBuilder.class, this.getRightsEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("custodyArrangements"), processor, CustodyArrangements.CustodyArrangementsBuilder.class, this.getCustodyArrangements(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("distributionAndInterestPayment"), processor, DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder.class, this.getDistributionAndInterestPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditSupportOffsets"), Boolean.class, (Object)this.getCreditSupportOffsets(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalRepresentations"), processor, AdditionalRepresentations.AdditionalRepresentationsBuilder.class, this.getAdditionalRepresentations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherEligibleAndPostedSupport"), processor, OtherEligibleAndPostedSupport.OtherEligibleAndPostedSupportBuilder.class, this.getOtherEligibleAndPostedSupport(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("demandsAndNotices"), processor, DemandsAndNotices.DemandsAndNoticesBuilder.class, this.getDemandsAndNotices(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("addressesForTransfer"), processor, ContactElection.ContactElectionBuilder.class, this.getAddressesForTransfer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherAgreements"), processor, OtherAgreements.OtherAgreementsBuilder.class, this.getOtherAgreements(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationCurrencyAmendment"), processor, TerminationCurrencyAmendment.TerminationCurrencyAmendmentBuilder.class, this.getTerminationCurrencyAmendment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumTransferAmountAmendment"), processor, MinimumTransferAmountAmendment.MinimumTransferAmountAmendmentBuilder.class, this.getMinimumTransferAmountAmendment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interpretationTerms"), String.class, (Object)this.getInterpretationTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("processAgent"), processor, ProcessAgent.ProcessAgentBuilder.class, this.getProcessAgent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("appropriatedCollateralValuation"), processor, AppropriatedCollateralValuation.AppropriatedCollateralValuationBuilder.class, this.getAppropriatedCollateralValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("jurisdictionRelatedTerms"), processor, JurisdictionRelatedTerms.JurisdictionRelatedTermsBuilder.class, this.getJurisdictionRelatedTerms(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalAmendments"), String.class, (Object)this.getAdditionalAmendments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("additionalBespokeTerms"), String.class, (Object)this.getAdditionalBespokeTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("trustSchemeAddendum"), Boolean.class, (Object)this.getTrustSchemeAddendum(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityInterestForObligations"), processor, SecurityInterestForObligations.SecurityInterestForObligationsBuilder.class, this.getSecurityInterestForObligations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("singlePostingParty"), processor, SinglePostingParty.SinglePostingPartyBuilder.class, this.getSinglePostingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedAsOfDate"), processor, DatedAsOfDate.DatedAsOfDateBuilder.class, this.getDatedAsOfDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cass"), String.class, (Object)this.getCass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherCSA"), String.class, (Object)this.getOtherCSA(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("legacyAdditionalRepresentations"), String.class, (Object)this.getLegacyAdditionalRepresentations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("value"), processor, CollateralValueMethod.CollateralValueMethodBuilder.class, this.getValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalReturns"), processor, FinalReturns.FinalReturnsBuilder.class, this.getFinalReturns(), new AttributeMeta[0]);
        }

        public CreditSupportAgreementElectionsBuilder prune();
    }

    public static class CreditSupportAgreementElectionsImpl
    implements CreditSupportAgreementElections {
        private final Regime regime;
        private final OneWayProvisions oneWayProvisions;
        private final GeneralSimmElections generalSimmElections;
        private final Boolean identifiedCrossCurrencySwap;
        private final SensitivityMethodologies sensitivityMethodologies;
        private final FxHaircutCurrency fxHaircutCurrency;
        private final PostingObligations postingObligations;
        private final List<? extends SubstitutedRegime> substitutedRegime;
        private final BaseAndEligibleCurrency baseAndEligibleCurrency;
        private final String additionalObligations;
        private final CoveredTransactions coveredTransactions;
        private final CreditSupportObligations creditSupportObligations;
        private final String exchangeDate;
        private final CalculationAndTiming calculationAndTiming;
        private final ConditionsPrecedent conditionsPrecedent;
        private final Substitution substitution;
        private final DisputeResolution disputeResolution;
        private final HoldingAndUsingPostedCollateral holdingAndUsingPostedCollateral;
        private final RightsEvents rightsEvents;
        private final CustodyArrangements custodyArrangements;
        private final DistributionAndInterestPayment distributionAndInterestPayment;
        private final Boolean creditSupportOffsets;
        private final AdditionalRepresentations additionalRepresentations;
        private final OtherEligibleAndPostedSupport otherEligibleAndPostedSupport;
        private final DemandsAndNotices demandsAndNotices;
        private final ContactElection addressesForTransfer;
        private final OtherAgreements otherAgreements;
        private final TerminationCurrencyAmendment terminationCurrencyAmendment;
        private final MinimumTransferAmountAmendment minimumTransferAmountAmendment;
        private final String interpretationTerms;
        private final ProcessAgent processAgent;
        private final AppropriatedCollateralValuation appropriatedCollateralValuation;
        private final JurisdictionRelatedTerms jurisdictionRelatedTerms;
        private final String additionalAmendments;
        private final String additionalBespokeTerms;
        private final Boolean trustSchemeAddendum;
        private final SecurityInterestForObligations securityInterestForObligations;
        private final SinglePostingParty singlePostingParty;
        private final DatedAsOfDate datedAsOfDate;
        private final String cass;
        private final String otherCSA;
        private final String legacyAdditionalRepresentations;
        private final CollateralValueMethod value;
        private final FinalReturns finalReturns;

        protected CreditSupportAgreementElectionsImpl(CreditSupportAgreementElectionsBuilder builder) {
            this.regime = Optional.ofNullable(builder.getRegime()).map(f -> f.build()).orElse(null);
            this.oneWayProvisions = Optional.ofNullable(builder.getOneWayProvisions()).map(f -> f.build()).orElse(null);
            this.generalSimmElections = Optional.ofNullable(builder.getGeneralSimmElections()).map(f -> f.build()).orElse(null);
            this.identifiedCrossCurrencySwap = builder.getIdentifiedCrossCurrencySwap();
            this.sensitivityMethodologies = Optional.ofNullable(builder.getSensitivityMethodologies()).map(f -> f.build()).orElse(null);
            this.fxHaircutCurrency = Optional.ofNullable(builder.getFxHaircutCurrency()).map(f -> f.build()).orElse(null);
            this.postingObligations = Optional.ofNullable(builder.getPostingObligations()).map(f -> f.build()).orElse(null);
            this.substitutedRegime = Optional.ofNullable(builder.getSubstitutedRegime()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.baseAndEligibleCurrency = Optional.ofNullable(builder.getBaseAndEligibleCurrency()).map(f -> f.build()).orElse(null);
            this.additionalObligations = builder.getAdditionalObligations();
            this.coveredTransactions = Optional.ofNullable(builder.getCoveredTransactions()).map(f -> f.build()).orElse(null);
            this.creditSupportObligations = Optional.ofNullable(builder.getCreditSupportObligations()).map(f -> f.build()).orElse(null);
            this.exchangeDate = builder.getExchangeDate();
            this.calculationAndTiming = Optional.ofNullable(builder.getCalculationAndTiming()).map(f -> f.build()).orElse(null);
            this.conditionsPrecedent = Optional.ofNullable(builder.getConditionsPrecedent()).map(f -> f.build()).orElse(null);
            this.substitution = Optional.ofNullable(builder.getSubstitution()).map(f -> f.build()).orElse(null);
            this.disputeResolution = Optional.ofNullable(builder.getDisputeResolution()).map(f -> f.build()).orElse(null);
            this.holdingAndUsingPostedCollateral = Optional.ofNullable(builder.getHoldingAndUsingPostedCollateral()).map(f -> f.build()).orElse(null);
            this.rightsEvents = Optional.ofNullable(builder.getRightsEvents()).map(f -> f.build()).orElse(null);
            this.custodyArrangements = Optional.ofNullable(builder.getCustodyArrangements()).map(f -> f.build()).orElse(null);
            this.distributionAndInterestPayment = Optional.ofNullable(builder.getDistributionAndInterestPayment()).map(f -> f.build()).orElse(null);
            this.creditSupportOffsets = builder.getCreditSupportOffsets();
            this.additionalRepresentations = Optional.ofNullable(builder.getAdditionalRepresentations()).map(f -> f.build()).orElse(null);
            this.otherEligibleAndPostedSupport = Optional.ofNullable(builder.getOtherEligibleAndPostedSupport()).map(f -> f.build()).orElse(null);
            this.demandsAndNotices = Optional.ofNullable(builder.getDemandsAndNotices()).map(f -> f.build()).orElse(null);
            this.addressesForTransfer = Optional.ofNullable(builder.getAddressesForTransfer()).map(f -> f.build()).orElse(null);
            this.otherAgreements = Optional.ofNullable(builder.getOtherAgreements()).map(f -> f.build()).orElse(null);
            this.terminationCurrencyAmendment = Optional.ofNullable(builder.getTerminationCurrencyAmendment()).map(f -> f.build()).orElse(null);
            this.minimumTransferAmountAmendment = Optional.ofNullable(builder.getMinimumTransferAmountAmendment()).map(f -> f.build()).orElse(null);
            this.interpretationTerms = builder.getInterpretationTerms();
            this.processAgent = Optional.ofNullable(builder.getProcessAgent()).map(f -> f.build()).orElse(null);
            this.appropriatedCollateralValuation = Optional.ofNullable(builder.getAppropriatedCollateralValuation()).map(f -> f.build()).orElse(null);
            this.jurisdictionRelatedTerms = Optional.ofNullable(builder.getJurisdictionRelatedTerms()).map(f -> f.build()).orElse(null);
            this.additionalAmendments = builder.getAdditionalAmendments();
            this.additionalBespokeTerms = builder.getAdditionalBespokeTerms();
            this.trustSchemeAddendum = builder.getTrustSchemeAddendum();
            this.securityInterestForObligations = Optional.ofNullable(builder.getSecurityInterestForObligations()).map(f -> f.build()).orElse(null);
            this.singlePostingParty = Optional.ofNullable(builder.getSinglePostingParty()).map(f -> f.build()).orElse(null);
            this.datedAsOfDate = Optional.ofNullable(builder.getDatedAsOfDate()).map(f -> f.build()).orElse(null);
            this.cass = builder.getCass();
            this.otherCSA = builder.getOtherCSA();
            this.legacyAdditionalRepresentations = builder.getLegacyAdditionalRepresentations();
            this.value = Optional.ofNullable(builder.getValue()).map(f -> f.build()).orElse(null);
            this.finalReturns = Optional.ofNullable(builder.getFinalReturns()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regime", isRequired=true)
        @RuneAttribute(value="regime", isRequired=true)
        public Regime getRegime() {
            return this.regime;
        }

        @Override
        @RosettaAttribute(value="oneWayProvisions", isRequired=true)
        @RuneAttribute(value="oneWayProvisions", isRequired=true)
        public OneWayProvisions getOneWayProvisions() {
            return this.oneWayProvisions;
        }

        @Override
        @RosettaAttribute(value="generalSimmElections")
        @RuneAttribute(value="generalSimmElections")
        public GeneralSimmElections getGeneralSimmElections() {
            return this.generalSimmElections;
        }

        @Override
        @RosettaAttribute(value="identifiedCrossCurrencySwap")
        @RuneAttribute(value="identifiedCrossCurrencySwap")
        public Boolean getIdentifiedCrossCurrencySwap() {
            return this.identifiedCrossCurrencySwap;
        }

        @Override
        @RosettaAttribute(value="sensitivityMethodologies", isRequired=true)
        @RuneAttribute(value="sensitivityMethodologies", isRequired=true)
        public SensitivityMethodologies getSensitivityMethodologies() {
            return this.sensitivityMethodologies;
        }

        @Override
        @RosettaAttribute(value="fxHaircutCurrency")
        @RuneAttribute(value="fxHaircutCurrency")
        public FxHaircutCurrency getFxHaircutCurrency() {
            return this.fxHaircutCurrency;
        }

        @Override
        @RosettaAttribute(value="postingObligations", isRequired=true)
        @RuneAttribute(value="postingObligations", isRequired=true)
        public PostingObligations getPostingObligations() {
            return this.postingObligations;
        }

        @Override
        @RosettaAttribute(value="substitutedRegime")
        @RuneAttribute(value="substitutedRegime")
        public List<? extends SubstitutedRegime> getSubstitutedRegime() {
            return this.substitutedRegime;
        }

        @Override
        @RosettaAttribute(value="baseAndEligibleCurrency", isRequired=true)
        @RuneAttribute(value="baseAndEligibleCurrency", isRequired=true)
        public BaseAndEligibleCurrency getBaseAndEligibleCurrency() {
            return this.baseAndEligibleCurrency;
        }

        @Override
        @RosettaAttribute(value="additionalObligations")
        @RuneAttribute(value="additionalObligations")
        public String getAdditionalObligations() {
            return this.additionalObligations;
        }

        @Override
        @RosettaAttribute(value="coveredTransactions", isRequired=true)
        @RuneAttribute(value="coveredTransactions", isRequired=true)
        public CoveredTransactions getCoveredTransactions() {
            return this.coveredTransactions;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligations", isRequired=true)
        @RuneAttribute(value="creditSupportObligations", isRequired=true)
        public CreditSupportObligations getCreditSupportObligations() {
            return this.creditSupportObligations;
        }

        @Override
        @RosettaAttribute(value="exchangeDate")
        @RuneAttribute(value="exchangeDate")
        public String getExchangeDate() {
            return this.exchangeDate;
        }

        @Override
        @RosettaAttribute(value="calculationAndTiming", isRequired=true)
        @RuneAttribute(value="calculationAndTiming", isRequired=true)
        public CalculationAndTiming getCalculationAndTiming() {
            return this.calculationAndTiming;
        }

        @Override
        @RosettaAttribute(value="conditionsPrecedent")
        @RuneAttribute(value="conditionsPrecedent")
        public ConditionsPrecedent getConditionsPrecedent() {
            return this.conditionsPrecedent;
        }

        @Override
        @RosettaAttribute(value="substitution", isRequired=true)
        @RuneAttribute(value="substitution", isRequired=true)
        public Substitution getSubstitution() {
            return this.substitution;
        }

        @Override
        @RosettaAttribute(value="disputeResolution", isRequired=true)
        @RuneAttribute(value="disputeResolution", isRequired=true)
        public DisputeResolution getDisputeResolution() {
            return this.disputeResolution;
        }

        @Override
        @RosettaAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        @RuneAttribute(value="holdingAndUsingPostedCollateral", isRequired=true)
        public HoldingAndUsingPostedCollateral getHoldingAndUsingPostedCollateral() {
            return this.holdingAndUsingPostedCollateral;
        }

        @Override
        @RosettaAttribute(value="rightsEvents", isRequired=true)
        @RuneAttribute(value="rightsEvents", isRequired=true)
        public RightsEvents getRightsEvents() {
            return this.rightsEvents;
        }

        @Override
        @RosettaAttribute(value="custodyArrangements")
        @RuneAttribute(value="custodyArrangements")
        public CustodyArrangements getCustodyArrangements() {
            return this.custodyArrangements;
        }

        @Override
        @RosettaAttribute(value="distributionAndInterestPayment")
        @RuneAttribute(value="distributionAndInterestPayment")
        public DistributionAndInterestPayment getDistributionAndInterestPayment() {
            return this.distributionAndInterestPayment;
        }

        @Override
        @RosettaAttribute(value="creditSupportOffsets", isRequired=true)
        @RuneAttribute(value="creditSupportOffsets", isRequired=true)
        public Boolean getCreditSupportOffsets() {
            return this.creditSupportOffsets;
        }

        @Override
        @RosettaAttribute(value="additionalRepresentations", isRequired=true)
        @RuneAttribute(value="additionalRepresentations", isRequired=true)
        public AdditionalRepresentations getAdditionalRepresentations() {
            return this.additionalRepresentations;
        }

        @Override
        @RosettaAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        @RuneAttribute(value="otherEligibleAndPostedSupport", isRequired=true)
        public OtherEligibleAndPostedSupport getOtherEligibleAndPostedSupport() {
            return this.otherEligibleAndPostedSupport;
        }

        @Override
        @RosettaAttribute(value="demandsAndNotices")
        @RuneAttribute(value="demandsAndNotices")
        public DemandsAndNotices getDemandsAndNotices() {
            return this.demandsAndNotices;
        }

        @Override
        @RosettaAttribute(value="addressesForTransfer")
        @RuneAttribute(value="addressesForTransfer")
        public ContactElection getAddressesForTransfer() {
            return this.addressesForTransfer;
        }

        @Override
        @RosettaAttribute(value="otherAgreements")
        @RuneAttribute(value="otherAgreements")
        public OtherAgreements getOtherAgreements() {
            return this.otherAgreements;
        }

        @Override
        @RosettaAttribute(value="terminationCurrencyAmendment", isRequired=true)
        @RuneAttribute(value="terminationCurrencyAmendment", isRequired=true)
        public TerminationCurrencyAmendment getTerminationCurrencyAmendment() {
            return this.terminationCurrencyAmendment;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        @RuneAttribute(value="minimumTransferAmountAmendment", isRequired=true)
        public MinimumTransferAmountAmendment getMinimumTransferAmountAmendment() {
            return this.minimumTransferAmountAmendment;
        }

        @Override
        @RosettaAttribute(value="interpretationTerms")
        @RuneAttribute(value="interpretationTerms")
        public String getInterpretationTerms() {
            return this.interpretationTerms;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public ProcessAgent getProcessAgent() {
            return this.processAgent;
        }

        @Override
        @RosettaAttribute(value="appropriatedCollateralValuation")
        @RuneAttribute(value="appropriatedCollateralValuation")
        public AppropriatedCollateralValuation getAppropriatedCollateralValuation() {
            return this.appropriatedCollateralValuation;
        }

        @Override
        @RosettaAttribute(value="jurisdictionRelatedTerms")
        @RuneAttribute(value="jurisdictionRelatedTerms")
        public JurisdictionRelatedTerms getJurisdictionRelatedTerms() {
            return this.jurisdictionRelatedTerms;
        }

        @Override
        @RosettaAttribute(value="additionalAmendments")
        @RuneAttribute(value="additionalAmendments")
        public String getAdditionalAmendments() {
            return this.additionalAmendments;
        }

        @Override
        @RosettaAttribute(value="additionalBespokeTerms")
        @RuneAttribute(value="additionalBespokeTerms")
        public String getAdditionalBespokeTerms() {
            return this.additionalBespokeTerms;
        }

        @Override
        @RosettaAttribute(value="trustSchemeAddendum", isRequired=true)
        @RuneAttribute(value="trustSchemeAddendum", isRequired=true)
        public Boolean getTrustSchemeAddendum() {
            return this.trustSchemeAddendum;
        }

        @Override
        @RosettaAttribute(value="securityInterestForObligations", isRequired=true)
        @RuneAttribute(value="securityInterestForObligations", isRequired=true)
        public SecurityInterestForObligations getSecurityInterestForObligations() {
            return this.securityInterestForObligations;
        }

        @Override
        @RosettaAttribute(value="singlePostingParty")
        @RuneAttribute(value="singlePostingParty")
        public SinglePostingParty getSinglePostingParty() {
            return this.singlePostingParty;
        }

        @Override
        @RosettaAttribute(value="datedAsOfDate")
        @RuneAttribute(value="datedAsOfDate")
        public DatedAsOfDate getDatedAsOfDate() {
            return this.datedAsOfDate;
        }

        @Override
        @RosettaAttribute(value="cass")
        @RuneAttribute(value="cass")
        public String getCass() {
            return this.cass;
        }

        @Override
        @RosettaAttribute(value="otherCSA")
        @RuneAttribute(value="otherCSA")
        public String getOtherCSA() {
            return this.otherCSA;
        }

        @Override
        @RosettaAttribute(value="legacyAdditionalRepresentations")
        @RuneAttribute(value="legacyAdditionalRepresentations")
        public String getLegacyAdditionalRepresentations() {
            return this.legacyAdditionalRepresentations;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public CollateralValueMethod getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="finalReturns", isRequired=true)
        @RuneAttribute(value="finalReturns", isRequired=true)
        public FinalReturns getFinalReturns() {
            return this.finalReturns;
        }

        @Override
        public CreditSupportAgreementElections build() {
            return this;
        }

        @Override
        public CreditSupportAgreementElectionsBuilder toBuilder() {
            CreditSupportAgreementElectionsBuilder builder = CreditSupportAgreementElections.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditSupportAgreementElectionsBuilder builder) {
            Optional.ofNullable(this.getRegime()).ifPresent(builder::setRegime);
            Optional.ofNullable(this.getOneWayProvisions()).ifPresent(builder::setOneWayProvisions);
            Optional.ofNullable(this.getGeneralSimmElections()).ifPresent(builder::setGeneralSimmElections);
            Optional.ofNullable(this.getIdentifiedCrossCurrencySwap()).ifPresent(builder::setIdentifiedCrossCurrencySwap);
            Optional.ofNullable(this.getSensitivityMethodologies()).ifPresent(builder::setSensitivityMethodologies);
            Optional.ofNullable(this.getFxHaircutCurrency()).ifPresent(builder::setFxHaircutCurrency);
            Optional.ofNullable(this.getPostingObligations()).ifPresent(builder::setPostingObligations);
            Optional.ofNullable(this.getSubstitutedRegime()).ifPresent(builder::setSubstitutedRegime);
            Optional.ofNullable(this.getBaseAndEligibleCurrency()).ifPresent(builder::setBaseAndEligibleCurrency);
            Optional.ofNullable(this.getAdditionalObligations()).ifPresent(builder::setAdditionalObligations);
            Optional.ofNullable(this.getCoveredTransactions()).ifPresent(builder::setCoveredTransactions);
            Optional.ofNullable(this.getCreditSupportObligations()).ifPresent(builder::setCreditSupportObligations);
            Optional.ofNullable(this.getExchangeDate()).ifPresent(builder::setExchangeDate);
            Optional.ofNullable(this.getCalculationAndTiming()).ifPresent(builder::setCalculationAndTiming);
            Optional.ofNullable(this.getConditionsPrecedent()).ifPresent(builder::setConditionsPrecedent);
            Optional.ofNullable(this.getSubstitution()).ifPresent(builder::setSubstitution);
            Optional.ofNullable(this.getDisputeResolution()).ifPresent(builder::setDisputeResolution);
            Optional.ofNullable(this.getHoldingAndUsingPostedCollateral()).ifPresent(builder::setHoldingAndUsingPostedCollateral);
            Optional.ofNullable(this.getRightsEvents()).ifPresent(builder::setRightsEvents);
            Optional.ofNullable(this.getCustodyArrangements()).ifPresent(builder::setCustodyArrangements);
            Optional.ofNullable(this.getDistributionAndInterestPayment()).ifPresent(builder::setDistributionAndInterestPayment);
            Optional.ofNullable(this.getCreditSupportOffsets()).ifPresent(builder::setCreditSupportOffsets);
            Optional.ofNullable(this.getAdditionalRepresentations()).ifPresent(builder::setAdditionalRepresentations);
            Optional.ofNullable(this.getOtherEligibleAndPostedSupport()).ifPresent(builder::setOtherEligibleAndPostedSupport);
            Optional.ofNullable(this.getDemandsAndNotices()).ifPresent(builder::setDemandsAndNotices);
            Optional.ofNullable(this.getAddressesForTransfer()).ifPresent(builder::setAddressesForTransfer);
            Optional.ofNullable(this.getOtherAgreements()).ifPresent(builder::setOtherAgreements);
            Optional.ofNullable(this.getTerminationCurrencyAmendment()).ifPresent(builder::setTerminationCurrencyAmendment);
            Optional.ofNullable(this.getMinimumTransferAmountAmendment()).ifPresent(builder::setMinimumTransferAmountAmendment);
            Optional.ofNullable(this.getInterpretationTerms()).ifPresent(builder::setInterpretationTerms);
            Optional.ofNullable(this.getProcessAgent()).ifPresent(builder::setProcessAgent);
            Optional.ofNullable(this.getAppropriatedCollateralValuation()).ifPresent(builder::setAppropriatedCollateralValuation);
            Optional.ofNullable(this.getJurisdictionRelatedTerms()).ifPresent(builder::setJurisdictionRelatedTerms);
            Optional.ofNullable(this.getAdditionalAmendments()).ifPresent(builder::setAdditionalAmendments);
            Optional.ofNullable(this.getAdditionalBespokeTerms()).ifPresent(builder::setAdditionalBespokeTerms);
            Optional.ofNullable(this.getTrustSchemeAddendum()).ifPresent(builder::setTrustSchemeAddendum);
            Optional.ofNullable(this.getSecurityInterestForObligations()).ifPresent(builder::setSecurityInterestForObligations);
            Optional.ofNullable(this.getSinglePostingParty()).ifPresent(builder::setSinglePostingParty);
            Optional.ofNullable(this.getDatedAsOfDate()).ifPresent(builder::setDatedAsOfDate);
            Optional.ofNullable(this.getCass()).ifPresent(builder::setCass);
            Optional.ofNullable(this.getOtherCSA()).ifPresent(builder::setOtherCSA);
            Optional.ofNullable(this.getLegacyAdditionalRepresentations()).ifPresent(builder::setLegacyAdditionalRepresentations);
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
            Optional.ofNullable(this.getFinalReturns()).ifPresent(builder::setFinalReturns);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportAgreementElections _that = this.getType().cast(o);
            if (!Objects.equals(this.regime, _that.getRegime())) {
                return false;
            }
            if (!Objects.equals(this.oneWayProvisions, _that.getOneWayProvisions())) {
                return false;
            }
            if (!Objects.equals(this.generalSimmElections, _that.getGeneralSimmElections())) {
                return false;
            }
            if (!Objects.equals(this.identifiedCrossCurrencySwap, _that.getIdentifiedCrossCurrencySwap())) {
                return false;
            }
            if (!Objects.equals(this.sensitivityMethodologies, _that.getSensitivityMethodologies())) {
                return false;
            }
            if (!Objects.equals(this.fxHaircutCurrency, _that.getFxHaircutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.postingObligations, _that.getPostingObligations())) {
                return false;
            }
            if (!ListEquals.listEquals(this.substitutedRegime, _that.getSubstitutedRegime())) {
                return false;
            }
            if (!Objects.equals(this.baseAndEligibleCurrency, _that.getBaseAndEligibleCurrency())) {
                return false;
            }
            if (!Objects.equals(this.additionalObligations, _that.getAdditionalObligations())) {
                return false;
            }
            if (!Objects.equals(this.coveredTransactions, _that.getCoveredTransactions())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportObligations, _that.getCreditSupportObligations())) {
                return false;
            }
            if (!Objects.equals(this.exchangeDate, _that.getExchangeDate())) {
                return false;
            }
            if (!Objects.equals(this.calculationAndTiming, _that.getCalculationAndTiming())) {
                return false;
            }
            if (!Objects.equals(this.conditionsPrecedent, _that.getConditionsPrecedent())) {
                return false;
            }
            if (!Objects.equals(this.substitution, _that.getSubstitution())) {
                return false;
            }
            if (!Objects.equals(this.disputeResolution, _that.getDisputeResolution())) {
                return false;
            }
            if (!Objects.equals(this.holdingAndUsingPostedCollateral, _that.getHoldingAndUsingPostedCollateral())) {
                return false;
            }
            if (!Objects.equals(this.rightsEvents, _that.getRightsEvents())) {
                return false;
            }
            if (!Objects.equals(this.custodyArrangements, _that.getCustodyArrangements())) {
                return false;
            }
            if (!Objects.equals(this.distributionAndInterestPayment, _that.getDistributionAndInterestPayment())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportOffsets, _that.getCreditSupportOffsets())) {
                return false;
            }
            if (!Objects.equals(this.additionalRepresentations, _that.getAdditionalRepresentations())) {
                return false;
            }
            if (!Objects.equals(this.otherEligibleAndPostedSupport, _that.getOtherEligibleAndPostedSupport())) {
                return false;
            }
            if (!Objects.equals(this.demandsAndNotices, _that.getDemandsAndNotices())) {
                return false;
            }
            if (!Objects.equals(this.addressesForTransfer, _that.getAddressesForTransfer())) {
                return false;
            }
            if (!Objects.equals(this.otherAgreements, _that.getOtherAgreements())) {
                return false;
            }
            if (!Objects.equals(this.terminationCurrencyAmendment, _that.getTerminationCurrencyAmendment())) {
                return false;
            }
            if (!Objects.equals(this.minimumTransferAmountAmendment, _that.getMinimumTransferAmountAmendment())) {
                return false;
            }
            if (!Objects.equals(this.interpretationTerms, _that.getInterpretationTerms())) {
                return false;
            }
            if (!Objects.equals(this.processAgent, _that.getProcessAgent())) {
                return false;
            }
            if (!Objects.equals(this.appropriatedCollateralValuation, _that.getAppropriatedCollateralValuation())) {
                return false;
            }
            if (!Objects.equals(this.jurisdictionRelatedTerms, _that.getJurisdictionRelatedTerms())) {
                return false;
            }
            if (!Objects.equals(this.additionalAmendments, _that.getAdditionalAmendments())) {
                return false;
            }
            if (!Objects.equals(this.additionalBespokeTerms, _that.getAdditionalBespokeTerms())) {
                return false;
            }
            if (!Objects.equals(this.trustSchemeAddendum, _that.getTrustSchemeAddendum())) {
                return false;
            }
            if (!Objects.equals(this.securityInterestForObligations, _that.getSecurityInterestForObligations())) {
                return false;
            }
            if (!Objects.equals(this.singlePostingParty, _that.getSinglePostingParty())) {
                return false;
            }
            if (!Objects.equals(this.datedAsOfDate, _that.getDatedAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.cass, _that.getCass())) {
                return false;
            }
            if (!Objects.equals(this.otherCSA, _that.getOtherCSA())) {
                return false;
            }
            if (!Objects.equals(this.legacyAdditionalRepresentations, _that.getLegacyAdditionalRepresentations())) {
                return false;
            }
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return Objects.equals(this.finalReturns, _that.getFinalReturns());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.regime != null ? this.regime.hashCode() : 0);
            _result = 31 * _result + (this.oneWayProvisions != null ? this.oneWayProvisions.hashCode() : 0);
            _result = 31 * _result + (this.generalSimmElections != null ? this.generalSimmElections.hashCode() : 0);
            _result = 31 * _result + (this.identifiedCrossCurrencySwap != null ? this.identifiedCrossCurrencySwap.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityMethodologies != null ? this.sensitivityMethodologies.hashCode() : 0);
            _result = 31 * _result + (this.fxHaircutCurrency != null ? this.fxHaircutCurrency.hashCode() : 0);
            _result = 31 * _result + (this.postingObligations != null ? this.postingObligations.hashCode() : 0);
            _result = 31 * _result + (this.substitutedRegime != null ? this.substitutedRegime.hashCode() : 0);
            _result = 31 * _result + (this.baseAndEligibleCurrency != null ? this.baseAndEligibleCurrency.hashCode() : 0);
            _result = 31 * _result + (this.additionalObligations != null ? this.additionalObligations.hashCode() : 0);
            _result = 31 * _result + (this.coveredTransactions != null ? this.coveredTransactions.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportObligations != null ? this.creditSupportObligations.hashCode() : 0);
            _result = 31 * _result + (this.exchangeDate != null ? this.exchangeDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationAndTiming != null ? this.calculationAndTiming.hashCode() : 0);
            _result = 31 * _result + (this.conditionsPrecedent != null ? this.conditionsPrecedent.hashCode() : 0);
            _result = 31 * _result + (this.substitution != null ? this.substitution.hashCode() : 0);
            _result = 31 * _result + (this.disputeResolution != null ? this.disputeResolution.hashCode() : 0);
            _result = 31 * _result + (this.holdingAndUsingPostedCollateral != null ? this.holdingAndUsingPostedCollateral.hashCode() : 0);
            _result = 31 * _result + (this.rightsEvents != null ? this.rightsEvents.hashCode() : 0);
            _result = 31 * _result + (this.custodyArrangements != null ? this.custodyArrangements.hashCode() : 0);
            _result = 31 * _result + (this.distributionAndInterestPayment != null ? this.distributionAndInterestPayment.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportOffsets != null ? this.creditSupportOffsets.hashCode() : 0);
            _result = 31 * _result + (this.additionalRepresentations != null ? this.additionalRepresentations.hashCode() : 0);
            _result = 31 * _result + (this.otherEligibleAndPostedSupport != null ? this.otherEligibleAndPostedSupport.hashCode() : 0);
            _result = 31 * _result + (this.demandsAndNotices != null ? this.demandsAndNotices.hashCode() : 0);
            _result = 31 * _result + (this.addressesForTransfer != null ? this.addressesForTransfer.hashCode() : 0);
            _result = 31 * _result + (this.otherAgreements != null ? this.otherAgreements.hashCode() : 0);
            _result = 31 * _result + (this.terminationCurrencyAmendment != null ? this.terminationCurrencyAmendment.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmountAmendment != null ? this.minimumTransferAmountAmendment.hashCode() : 0);
            _result = 31 * _result + (this.interpretationTerms != null ? this.interpretationTerms.hashCode() : 0);
            _result = 31 * _result + (this.processAgent != null ? this.processAgent.hashCode() : 0);
            _result = 31 * _result + (this.appropriatedCollateralValuation != null ? this.appropriatedCollateralValuation.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionRelatedTerms != null ? this.jurisdictionRelatedTerms.hashCode() : 0);
            _result = 31 * _result + (this.additionalAmendments != null ? this.additionalAmendments.hashCode() : 0);
            _result = 31 * _result + (this.additionalBespokeTerms != null ? this.additionalBespokeTerms.hashCode() : 0);
            _result = 31 * _result + (this.trustSchemeAddendum != null ? this.trustSchemeAddendum.hashCode() : 0);
            _result = 31 * _result + (this.securityInterestForObligations != null ? this.securityInterestForObligations.hashCode() : 0);
            _result = 31 * _result + (this.singlePostingParty != null ? this.singlePostingParty.hashCode() : 0);
            _result = 31 * _result + (this.datedAsOfDate != null ? this.datedAsOfDate.hashCode() : 0);
            _result = 31 * _result + (this.cass != null ? this.cass.hashCode() : 0);
            _result = 31 * _result + (this.otherCSA != null ? this.otherCSA.hashCode() : 0);
            _result = 31 * _result + (this.legacyAdditionalRepresentations != null ? this.legacyAdditionalRepresentations.hashCode() : 0);
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.finalReturns != null ? this.finalReturns.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportAgreementElections {regime=" + this.regime + ", oneWayProvisions=" + this.oneWayProvisions + ", generalSimmElections=" + this.generalSimmElections + ", identifiedCrossCurrencySwap=" + this.identifiedCrossCurrencySwap + ", sensitivityMethodologies=" + this.sensitivityMethodologies + ", fxHaircutCurrency=" + this.fxHaircutCurrency + ", postingObligations=" + this.postingObligations + ", substitutedRegime=" + this.substitutedRegime + ", baseAndEligibleCurrency=" + this.baseAndEligibleCurrency + ", additionalObligations=" + this.additionalObligations + ", coveredTransactions=" + this.coveredTransactions + ", creditSupportObligations=" + this.creditSupportObligations + ", exchangeDate=" + this.exchangeDate + ", calculationAndTiming=" + this.calculationAndTiming + ", conditionsPrecedent=" + this.conditionsPrecedent + ", substitution=" + this.substitution + ", disputeResolution=" + this.disputeResolution + ", holdingAndUsingPostedCollateral=" + this.holdingAndUsingPostedCollateral + ", rightsEvents=" + this.rightsEvents + ", custodyArrangements=" + this.custodyArrangements + ", distributionAndInterestPayment=" + this.distributionAndInterestPayment + ", creditSupportOffsets=" + this.creditSupportOffsets + ", additionalRepresentations=" + this.additionalRepresentations + ", otherEligibleAndPostedSupport=" + this.otherEligibleAndPostedSupport + ", demandsAndNotices=" + this.demandsAndNotices + ", addressesForTransfer=" + this.addressesForTransfer + ", otherAgreements=" + this.otherAgreements + ", terminationCurrencyAmendment=" + this.terminationCurrencyAmendment + ", minimumTransferAmountAmendment=" + this.minimumTransferAmountAmendment + ", interpretationTerms=" + this.interpretationTerms + ", processAgent=" + this.processAgent + ", appropriatedCollateralValuation=" + this.appropriatedCollateralValuation + ", jurisdictionRelatedTerms=" + this.jurisdictionRelatedTerms + ", additionalAmendments=" + this.additionalAmendments + ", additionalBespokeTerms=" + this.additionalBespokeTerms + ", trustSchemeAddendum=" + this.trustSchemeAddendum + ", securityInterestForObligations=" + this.securityInterestForObligations + ", singlePostingParty=" + this.singlePostingParty + ", datedAsOfDate=" + this.datedAsOfDate + ", cass=" + this.cass + ", otherCSA=" + this.otherCSA + ", legacyAdditionalRepresentations=" + this.legacyAdditionalRepresentations + ", value=" + this.value + ", finalReturns=" + this.finalReturns + '}';
        }
    }
}

