/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.processor;

import cdm.legaldocumentation.common.AgreementName;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementBase;
import cdm.legaldocumentation.common.LegalAgreementPublisherEnum;
import cdm.legaldocumentation.common.LegalAgreementTypeEnum;
import cdm.legaldocumentation.master.MasterAgreementTypeEnum;
import cdm.product.collateral.CreditSupportAgreementTypeEnum;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class RelatedAgreementMappingProcessor
extends MappingProcessor {
    public RelatedAgreementMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        LegalAgreement.LegalAgreementBuilder agreementTermsBuilder = (LegalAgreement.LegalAgreementBuilder)parent;
        this.getRelatedAgreement(synonymPath).ifPresent(agreementTermsBuilder::addRelatedAgreements);
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getRelatedAgreementForParty(synonymPath, (String)party).ifPresent(agreementTermsBuilder::addRelatedAgreements));
        this.associateIsdaMasterAgreement(synonymPath, builder.stream().map(LegalAgreement.LegalAgreementBuilder.class::cast).filter(this::isMasterAgreement).collect(Collectors.toList()));
    }

    private void associateIsdaMasterAgreement(Path synonymPath, List<LegalAgreement.LegalAgreementBuilder> relatedAgreementBuilders) {
        for (LegalAgreement.LegalAgreementBuilder relatedAgreementBuilder : relatedAgreementBuilders) {
            MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement("isda_master_agreement_form"), vintage -> {
                relatedAgreementBuilder.getOrCreateLegalAgreementIdentification().setVintage(Integer.valueOf(vintage));
                return true;
            }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
        }
    }

    private boolean isMasterAgreement(LegalAgreement.LegalAgreementBuilder relatedAgreementBuilder) {
        return Optional.of(relatedAgreementBuilder).map(LegalAgreementBase.LegalAgreementBaseBuilder::getLegalAgreementIdentification).map(a -> a.getAgreementName()).map(n -> n.getAgreementType()).map(LegalAgreementTypeEnum.MASTER_AGREEMENT::equals).orElse(false);
    }

    private Optional<LegalAgreement> getRelatedAgreement(Path synonymPath) {
        LegalAgreement.LegalAgreementBuilder legalAgreementBuilder = LegalAgreement.builder();
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement("collateral_transfer_agreement_date"), date -> this.setAgreementDetails(synonymPath, legalAgreementBuilder, (String)date), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement("master_agreement_date"), date -> this.setAgreementDetails(synonymPath, legalAgreementBuilder, (String)date), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return legalAgreementBuilder.hasData() ? Optional.of(legalAgreementBuilder.build()) : Optional.empty();
    }

    private Optional<LegalAgreement> getRelatedAgreementForParty(Path synonymPath, String party) {
        LegalAgreement.LegalAgreementBuilder relatedAgreementBuilder = LegalAgreement.builder();
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement(party + "_date_of_security_agreement"), date -> this.setAgreementDetails(synonymPath, relatedAgreementBuilder, (String)date), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return relatedAgreementBuilder.hasData() ? Optional.of(relatedAgreementBuilder.build()) : Optional.empty();
    }

    private Boolean setAgreementDetails(Path synonymPath, LegalAgreement.LegalAgreementBuilder legalAgreementBuilder, String date) {
        legalAgreementBuilder.setAgreementDate(Date.parse((String)date));
        switch (synonymPath.getLastElement().getPathName()) {
            case "collateral_transfer_agreement": 
            case "date_of_collateral_transfer_agreement": {
                legalAgreementBuilder.getOrCreateLegalAgreementIdentification().getOrCreateAgreementName().setAgreementType(LegalAgreementTypeEnum.CREDIT_SUPPORT_AGREEMENT).setCreditSupportAgreementTypeValue(CreditSupportAgreementTypeEnum.COLLATERAL_TRANSFER_AGREEMENT);
                return true;
            }
            case "date_of_isda_master_agreement": {
                legalAgreementBuilder.getOrCreateLegalAgreementIdentification().setPublisher(LegalAgreementPublisherEnum.ISDA).setAgreementName(AgreementName.builder().setAgreementType(LegalAgreementTypeEnum.MASTER_AGREEMENT).setMasterAgreementTypeValue(MasterAgreementTypeEnum.ISDA_MASTER));
                return true;
            }
            case "date_of_euroclear_security_agreement": {
                legalAgreementBuilder.getOrCreateLegalAgreementIdentification().setPublisher(LegalAgreementPublisherEnum.ISDA_EUROCLEAR).setAgreementName(AgreementName.builder().setAgreementType(LegalAgreementTypeEnum.SECURITY_AGREEMENT));
                return true;
            }
        }
        return false;
    }
}

