/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.workflowstep.functions;

import cdm.event.common.EventIntentEnum;
import cdm.ingest.fpml.confirmation.workflowstep.functions.MapOriginatingEventToIntent;
import cdm.ingest.fpml.confirmation.workflowstep.functions.MapTerminatingEventToIntent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.business.events.TerminatingEvent;
import fpml.consolidated.business.events.TradeAmendmentContent;
import fpml.consolidated.business.events.TradeNovationContent;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.shared.OriginatingEvent;
import javax.inject.Inject;

@ImplementedBy(value=GetIntentDefault.class)
public abstract class GetIntent
implements RosettaFunction {
    @Inject
    protected MapOriginatingEventToIntent mapOriginatingEventToIntent;
    @Inject
    protected MapTerminatingEventToIntent mapTerminatingEventToIntent;

    public EventIntentEnum evaluate(TradeNovationContent fpmlNovation, TradeAmendmentContent fpmlAmendment, OriginatingEvent fpmlOriginatingEvent, TerminatingEvent fpmlTerminatingEvent, Trade fpmlTrade) {
        EventIntentEnum intent = this.doEvaluate(fpmlNovation, fpmlAmendment, fpmlOriginatingEvent, fpmlTerminatingEvent, fpmlTrade);
        return intent;
    }

    protected abstract EventIntentEnum doEvaluate(TradeNovationContent var1, TradeAmendmentContent var2, OriginatingEvent var3, TerminatingEvent var4, Trade var5);

    protected abstract MapperS<Boolean> intentToAllocate(TradeNovationContent var1, TradeAmendmentContent var2, OriginatingEvent var3, TerminatingEvent var4, Trade var5);

    protected abstract MapperS<Boolean> intentToClear(TradeNovationContent var1, TradeAmendmentContent var2, OriginatingEvent var3, TerminatingEvent var4, Trade var5);

    public static class GetIntentDefault
    extends GetIntent {
        @Override
        protected EventIntentEnum doEvaluate(TradeNovationContent fpmlNovation, TradeAmendmentContent fpmlAmendment, OriginatingEvent fpmlOriginatingEvent, TerminatingEvent fpmlTerminatingEvent, Trade fpmlTrade) {
            EventIntentEnum intent = null;
            return this.assignOutput(intent, fpmlNovation, fpmlAmendment, fpmlOriginatingEvent, fpmlTerminatingEvent, fpmlTrade);
        }

        protected EventIntentEnum assignOutput(EventIntentEnum intent, TradeNovationContent fpmlNovation, TradeAmendmentContent fpmlAmendment, OriginatingEvent fpmlOriginatingEvent, TerminatingEvent fpmlTerminatingEvent, Trade fpmlTrade) {
            intent = (Boolean)this.intentToAllocate(fpmlNovation, fpmlAmendment, fpmlOriginatingEvent, fpmlTerminatingEvent, fpmlTrade).getOrDefault((Object)false) != false ? EventIntentEnum.ALLOCATION : ((Boolean)this.intentToClear(fpmlNovation, fpmlAmendment, fpmlOriginatingEvent, fpmlTerminatingEvent, fpmlTrade).getOrDefault((Object)false) != false ? EventIntentEnum.CLEARING : (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlNovation)).getOrDefault(Boolean.valueOf(false)) != false ? EventIntentEnum.NOVATION : (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlAmendment)).getOrDefault(Boolean.valueOf(false)) != false ? EventIntentEnum.CONTRACT_TERMS_AMENDMENT : (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Object)this.mapOriginatingEventToIntent.evaluate(fpmlOriginatingEvent)))).getOrDefault(Boolean.valueOf(false)) != false ? this.mapOriginatingEventToIntent.evaluate(fpmlOriginatingEvent) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Object)this.mapTerminatingEventToIntent.evaluate(fpmlTerminatingEvent)))).getOrDefault(Boolean.valueOf(false)) != false ? this.mapTerminatingEventToIntent.evaluate(fpmlTerminatingEvent) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlTrade)).getOrDefault(Boolean.valueOf(false)) != false ? EventIntentEnum.CONTRACT_FORMATION : null))))));
            return intent;
        }

        @Override
        protected MapperS<Boolean> intentToAllocate(TradeNovationContent fpmlNovation, TradeAmendmentContent fpmlAmendment, OriginatingEvent fpmlOriginatingEvent, TerminatingEvent fpmlTerminatingEvent, Trade fpmlTrade) {
            MapperC thenArg = MapperS.of((Object)fpmlTrade).map("getTradeHeader", trade -> trade.getTradeHeader()).mapC("getPartyTradeInformation", tradeHeader -> tradeHeader.getPartyTradeInformation()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getIntentToAllocate", partyTradeInformation -> partyTradeInformation.getIntentToAllocate()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get());
            return ExpressionOperators.exists((Mapper)thenArg).asMapper();
        }

        @Override
        protected MapperS<Boolean> intentToClear(TradeNovationContent fpmlNovation, TradeAmendmentContent fpmlAmendment, OriginatingEvent fpmlOriginatingEvent, TerminatingEvent fpmlTerminatingEvent, Trade fpmlTrade) {
            MapperC thenArg = MapperS.of((Object)fpmlTrade).map("getTradeHeader", trade -> trade.getTradeHeader()).mapC("getPartyTradeInformation", tradeHeader -> tradeHeader.getPartyTradeInformation()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getIntentToClear", partyTradeInformation -> partyTradeInformation.getIntentToClear()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get());
            return ExpressionOperators.exists((Mapper)thenArg).asMapper();
        }
    }
}

