/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.tradestate.functions;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.Trade;
import cdm.event.common.TradeIdentifier;
import cdm.ingest.fpml.confirmation.datetime.functions.MapIdentifiedDate;
import cdm.ingest.fpml.confirmation.header.functions.MapTradeIdentifierList;
import cdm.ingest.fpml.confirmation.legal.functions.MapContractDetails;
import cdm.ingest.fpml.confirmation.other.functions.MapNotionalAdjustmentEnum;
import cdm.ingest.fpml.confirmation.party.functions.MapAccountList;
import cdm.ingest.fpml.confirmation.party.functions.MapAncillaryPartyList;
import cdm.ingest.fpml.confirmation.party.functions.MapCounterpartyList;
import cdm.ingest.fpml.confirmation.party.functions.MapPartyList;
import cdm.ingest.fpml.confirmation.party.functions.MapPartyRoleList;
import cdm.ingest.fpml.confirmation.tradestate.functions.ExtractNotionalAdjustmentByLeg;
import cdm.ingest.fpml.confirmation.tradestate.functions.MapNonTransferableProduct;
import cdm.ingest.fpml.confirmation.tradestate.functions.MapTradeLotList;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.doc.TradeHeader;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapTradeDefault.class)
public abstract class MapTrade
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractNotionalAdjustmentByLeg extractNotionalAdjustmentByLeg;
    @Inject
    protected MapAccountList mapAccountList;
    @Inject
    protected MapAncillaryPartyList mapAncillaryPartyList;
    @Inject
    protected MapContractDetails mapContractDetails;
    @Inject
    protected MapCounterpartyList mapCounterpartyList;
    @Inject
    protected MapIdentifiedDate mapIdentifiedDate;
    @Inject
    protected MapNonTransferableProduct mapNonTransferableProduct;
    @Inject
    protected MapNotionalAdjustmentEnum mapNotionalAdjustmentEnum;
    @Inject
    protected MapPartyList mapPartyList;
    @Inject
    protected MapPartyRoleList mapPartyRoleList;
    @Inject
    protected MapTradeIdentifierList mapTradeIdentifierList;
    @Inject
    protected MapTradeLotList mapTradeLotList;

    public cdm.event.common.Trade evaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
        cdm.event.common.Trade trade;
        Trade.TradeBuilder tradeBuilder = this.doEvaluate(fpmlTrade, fpmlPartiesAndAccountsModel);
        if (tradeBuilder == null) {
            trade = null;
        } else {
            trade = tradeBuilder.build();
            this.objectValidator.validate(cdm.event.common.Trade.class, (RosettaModelObject)trade);
        }
        return trade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(Trade var1, PartiesAndAccountsModel var2);

    protected abstract MapperC<? extends Counterparty> counterpartyList(Trade var1, PartiesAndAccountsModel var2);

    public static class MapTradeDefault
    extends MapTrade {
        @Override
        protected Trade.TradeBuilder doEvaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            Trade.TradeBuilder trade = cdm.event.common.Trade.builder();
            return this.assignOutput(trade, fpmlTrade, fpmlPartiesAndAccountsModel);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            trade = (Trade.TradeBuilder)this.toBuilder(cdm.event.common.Trade.builder().setProduct(this.mapNonTransferableProduct.evaluate(fpmlTrade, this.counterpartyList(fpmlTrade, fpmlPartiesAndAccountsModel).getMulti())).setTradeLot(new ArrayList<TradeLot>(this.mapTradeLotList.evaluate(fpmlTrade, fpmlPartiesAndAccountsModel))).setCounterparty((List)new ArrayList(this.counterpartyList(fpmlTrade, fpmlPartiesAndAccountsModel).getMulti())).setAncillaryParty(new ArrayList<AncillaryParty>(this.mapAncillaryPartyList.evaluate(fpmlTrade))).setAdjustment(this.mapNotionalAdjustmentEnum.evaluate(this.extractNotionalAdjustmentByLeg.evaluate(fpmlTrade))).setTradeIdentifier(new ArrayList<TradeIdentifier>(this.mapTradeIdentifierList.evaluate((TradeHeader)MapperS.of((Object)fpmlTrade).map("getTradeHeader", _trade -> _trade.getTradeHeader()).get()))).setTradeDate(this.mapIdentifiedDate.evaluate((IdentifiedDate)MapperS.of((Object)fpmlTrade).map("getTradeHeader", _trade -> _trade.getTradeHeader()).map("getTradeDate", tradeHeader -> tradeHeader.getTradeDate()).get())).setParty(new ArrayList<Party>(this.mapPartyList.evaluate(MapperS.of((Object)fpmlPartiesAndAccountsModel).mapC("getParty", partiesAndAccountsModel -> partiesAndAccountsModel.getParty()).getMulti()))).setPartyRole(new ArrayList<PartyRole>(this.mapPartyRoleList.evaluate(fpmlTrade))).setContractDetails(this.mapContractDetails.evaluate(fpmlTrade, this.counterpartyList(fpmlTrade, fpmlPartiesAndAccountsModel).getMulti())).setAccount(new ArrayList<Account>(this.mapAccountList.evaluate(fpmlTrade, fpmlPartiesAndAccountsModel))).build());
            return Optional.ofNullable(trade).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends Counterparty> counterpartyList(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            return MapperC.of(this.mapCounterpartyList.evaluate(fpmlTrade));
        }
    }
}

