/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.varianceswap.functions;

import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapNotionalAmountToQuantityWithLocation;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapUnderlyerToObservableWithLocation;
import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.variance.swaps.VarianceLeg;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapVarianceLegToPriceQuantityDefault.class)
public abstract class MapVarianceLegToPriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapNotionalAmountToQuantityWithLocation mapNotionalAmountToQuantityWithLocation;
    @Inject
    protected MapUnderlyerToObservableWithLocation mapUnderlyerToObservableWithLocation;

    public PriceQuantity evaluate(VarianceLeg fpmlVarianceLeg) {
        PriceQuantity priceQuantity;
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(fpmlVarianceLeg);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(VarianceLeg var1);

    public static class MapVarianceLegToPriceQuantityDefault
    extends MapVarianceLegToPriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(VarianceLeg fpmlVarianceLeg) {
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, fpmlVarianceLeg);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, VarianceLeg fpmlVarianceLeg) {
            FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = this.mapNotionalAmountToQuantityWithLocation.evaluate((BigDecimal)MapperS.of((Object)fpmlVarianceLeg).map("getAmount", varianceLeg -> varianceLeg.getAmount()).map("getVariance", varianceAmount -> varianceAmount.getVariance()).map("getVarianceAmount", variance -> variance.getVarianceAmount()).map("getAmount", nonNegativeMoney -> nonNegativeMoney.getAmount()).get(), Collections.emptyList(), (Currency)MapperS.of((Object)fpmlVarianceLeg).map("getAmount", varianceLeg -> varianceLeg.getAmount()).map("getVariance", varianceAmount -> varianceAmount.getVariance()).map("getVarianceAmount", variance -> variance.getVarianceAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get(), fpmlVarianceLeg);
            priceQuantity = (PriceQuantity.PriceQuantityBuilder)this.toBuilder(PriceQuantity.builder().setQuantity(fieldWithMetaNonNegativeQuantitySchedule == null ? Collections.emptyList() : Collections.singletonList(fieldWithMetaNonNegativeQuantitySchedule)).setObservable(this.mapUnderlyerToObservableWithLocation.evaluate((Underlyer)MapperS.of((Object)fpmlVarianceLeg).map("getUnderlyer", varianceLeg -> varianceLeg.getUnderlyer()).get())).build());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }
    }
}

