/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.swap.functions;

import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapRateOptionToObservableWithLocation;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapCalculationPeriodAmountToPriceList;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapCalculationPeriodAmountToQuantityList;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.ird.CalculationPeriodAmount;
import fpml.consolidated.ird.InterestRateStream;
import fpml.consolidated.shared.Rate;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapSwapPriceQuantityDefault.class)
public abstract class MapSwapPriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCalculationPeriodAmountToPriceList mapCalculationPeriodAmountToPriceList;
    @Inject
    protected MapCalculationPeriodAmountToQuantityList mapCalculationPeriodAmountToQuantityList;
    @Inject
    protected MapRateOptionToObservableWithLocation mapRateOptionToObservableWithLocation;

    public PriceQuantity evaluate(InterestRateStream fpmlSwapStream) {
        PriceQuantity priceQuantity;
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(fpmlSwapStream);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(InterestRateStream var1);

    protected abstract MapperS<? extends CalculationPeriodAmount> calculationPeriodAmount(InterestRateStream var1);

    public static class MapSwapPriceQuantityDefault
    extends MapSwapPriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(InterestRateStream fpmlSwapStream) {
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, fpmlSwapStream);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, InterestRateStream fpmlSwapStream) {
            priceQuantity = (PriceQuantity.PriceQuantityBuilder)this.toBuilder(PriceQuantity.builder().setPrice(new ArrayList<FieldWithMetaPriceSchedule>(this.mapCalculationPeriodAmountToPriceList.evaluate((CalculationPeriodAmount)this.calculationPeriodAmount(fpmlSwapStream).get(), fpmlSwapStream))).setQuantity(new ArrayList<FieldWithMetaNonNegativeQuantitySchedule>(this.mapCalculationPeriodAmountToQuantityList.evaluate((CalculationPeriodAmount)this.calculationPeriodAmount(fpmlSwapStream).get(), fpmlSwapStream))).setObservable(this.mapRateOptionToObservableWithLocation.evaluate((Rate)this.calculationPeriodAmount(fpmlSwapStream).map("getCalculation", _calculationPeriodAmount -> _calculationPeriodAmount.getCalculation()).map("getRateCalculation", calculation -> calculation.getRateCalculation()).get(), fpmlSwapStream)).build());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends CalculationPeriodAmount> calculationPeriodAmount(InterestRateStream fpmlSwapStream) {
            return MapperS.of((Object)fpmlSwapStream).map("getCalculationPeriodAmount", interestRateStream -> interestRateStream.getCalculationPeriodAmount());
        }
    }
}

