/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.bondoption.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.common.functions.MapExerciseTerms;
import cdm.ingest.fpml.confirmation.party.functions.MapBuyerSeller;
import cdm.ingest.fpml.confirmation.party.functions.MapSellerAsPayerAndBuyerAsReceiver;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapAssetToObservableWithAddress;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapOptionBaseExtendedQuantityListWithAddress;
import cdm.ingest.fpml.confirmation.product.bondoption.functions.MapBondOptionStrikeToOptionStrike;
import cdm.ingest.fpml.confirmation.settlement.functions.MapOptionSettlementModelToSettlementTerms;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionTypeEnum;
import cdm.product.template.Payout;
import cdm.product.template.Underlier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.asset.Bond;
import fpml.consolidated.bond.option.BondOption;
import fpml.consolidated.bond.option.BondOptionStrike;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Exercise;
import fpml.consolidated.shared.ExerciseProcedure;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapBondOptionPayoutDefault.class)
public abstract class MapBondOptionPayout
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAssetToObservableWithAddress mapAssetToObservableWithAddress;
    @Inject
    protected MapBondOptionStrikeToOptionStrike mapBondOptionStrikeToOptionStrike;
    @Inject
    protected MapBuyerSeller mapBuyerSeller;
    @Inject
    protected MapExerciseTerms mapExerciseTerms;
    @Inject
    protected MapOptionBaseExtendedQuantityListWithAddress mapOptionBaseExtendedQuantityListWithAddress;
    @Inject
    protected MapOptionSettlementModelToSettlementTerms mapOptionSettlementModelToSettlementTerms;
    @Inject
    protected MapSellerAsPayerAndBuyerAsReceiver mapSellerAsPayerAndBuyerAsReceiver;

    public Payout evaluate(BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
        Payout payout;
        Payout.PayoutBuilder payoutBuilder = this.doEvaluate(fpmlBondOption, cdmCounterpartyList);
        if (payoutBuilder == null) {
            payout = null;
        } else {
            payout = payoutBuilder.build();
            this.objectValidator.validate(Payout.class, (RosettaModelObject)payout);
        }
        return payout;
    }

    protected abstract Payout.PayoutBuilder doEvaluate(BondOption var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends Bond> fpmlUnderlyingAsset(BondOption var1, List<? extends Counterparty> var2);

    public static class MapBondOptionPayoutDefault
    extends MapBondOptionPayout {
        @Override
        protected Payout.PayoutBuilder doEvaluate(BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            Payout.PayoutBuilder payout = Payout.builder();
            return this.assignOutput(payout, fpmlBondOption, cdmCounterpartyList);
        }

        protected Payout.PayoutBuilder assignOutput(Payout.PayoutBuilder payout, BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
            payout = (Payout.PayoutBuilder)this.toBuilder(Payout.builder().setOptionPayout(OptionPayout.builder().setPayerReceiver(this.mapSellerAsPayerAndBuyerAsReceiver.evaluate((BuyerSellerModel)MapperS.of((Object)fpmlBondOption).map("getBuyerSellerModel", bondOption -> bondOption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setPriceQuantity(ResolvablePriceQuantity.builder().setQuantitySchedule(this.mapOptionBaseExtendedQuantityListWithAddress.evaluate(fpmlBondOption)).build()).setSettlementTerms(this.mapOptionSettlementModelToSettlementTerms.evaluate((OptionSettlementModel)MapperS.of((Object)fpmlBondOption).map("getOptionSettlementModel", bondOption -> bondOption.getOptionSettlementModel()).get())).setBuyerSeller(this.mapBuyerSeller.evaluate((BuyerSellerModel)MapperS.of((Object)fpmlBondOption).map("getBuyerSellerModel", bondOption -> bondOption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setUnderlier(Underlier.builder().setObservable(this.mapAssetToObservableWithAddress.evaluate((Asset)this.fpmlUnderlyingAsset(fpmlBondOption, cdmCounterpartyList).get())).build()).setOptionType((OptionTypeEnum)((Object)MapperS.of((Object)fpmlBondOption).map("getOptionType", bondOption -> bondOption.getOptionType()).checkedMap("to-enum", e -> OptionTypeEnum.valueOf(e.name()), IllegalArgumentException.class).get())).setExerciseTerms(this.mapExerciseTerms.evaluate((Exercise)MapperS.of((Object)fpmlBondOption).map("getExercise", bondOption -> bondOption.getExercise()).get(), (ExerciseProcedure)MapperS.of((Object)fpmlBondOption).map("getExerciseProcedure", bondOption -> bondOption.getExerciseProcedure()).get(), null, (BuyerSellerModel)MapperS.of((Object)fpmlBondOption).map("getBuyerSellerModel", bondOption -> bondOption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setStrike(this.mapBondOptionStrikeToOptionStrike.evaluate((BondOptionStrike)MapperS.of((Object)fpmlBondOption).map("getStrike", bondOption -> bondOption.getStrike()).get())).build()).build());
            return Optional.ofNullable(payout).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Bond> fpmlUnderlyingAsset(BondOption fpmlBondOption, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)((Bond)MapperS.of((Object)fpmlBondOption).map("getBondChoiceModel", bondOption -> bondOption.getBondChoiceModel()).map("getBond", bondChoiceModel -> bondChoiceModel.getBond()).getOrDefault((Object)((Bond)MapperS.of((Object)fpmlBondOption).map("getBondChoiceModel", bondOption -> bondOption.getBondChoiceModel()).map("getConvertibleBond", bondChoiceModel -> bondChoiceModel.getConvertibleBond()).get()))));
        }
    }
}

