/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.ingest.fpml.confirmation.pricequantity.functions.CreatePriceKey;
import cdm.ingest.fpml.confirmation.pricequantity.functions.CreatePriceWithLocation;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapScheduleToInterestRatePriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Leg;
import fpml.consolidated.shared.Rate;
import fpml.consolidated.shared.Schedule;
import fpml.consolidated.shared.SpreadSchedule;
import fpml.custom.RateChoice;
import fpml.custom.functions.ToRateChoice;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapSpreadScheduleToPriceWithLocationDefault.class)
public abstract class MapSpreadScheduleToPriceWithLocation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CreatePriceKey createPriceKey;
    @Inject
    protected CreatePriceWithLocation createPriceWithLocation;
    @Inject
    protected MapScheduleToInterestRatePriceSchedule mapScheduleToInterestRatePriceSchedule;
    @Inject
    protected ToRateChoice toRateChoice;

    public List<? extends FieldWithMetaPriceSchedule> evaluate(Rate fpmlRate, Currency fpmlCurrency, Leg fpmlLeg) {
        List priceSchedule;
        List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceScheduleBuilder = this.doEvaluate(fpmlRate, fpmlCurrency, fpmlLeg);
        if (priceScheduleBuilder == null) {
            priceSchedule = null;
        } else {
            priceSchedule = priceScheduleBuilder.stream().map(FieldWithMetaPriceSchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(FieldWithMetaPriceSchedule.class, priceSchedule);
        }
        return priceSchedule;
    }

    protected abstract List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> doEvaluate(Rate var1, Currency var2, Leg var3);

    protected abstract MapperS<? extends RateChoice> rateChoice(Rate var1, Currency var2, Leg var3);

    protected abstract MapperC<? extends SpreadSchedule> spreadSchedule(Rate var1, Currency var2, Leg var3);

    public static class MapSpreadScheduleToPriceWithLocationDefault
    extends MapSpreadScheduleToPriceWithLocation {
        @Override
        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> doEvaluate(Rate fpmlRate, Currency fpmlCurrency, Leg fpmlLeg) {
            ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceSchedule = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
            return this.assignOutput(priceSchedule, fpmlRate, fpmlCurrency, fpmlLeg);
        }

        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> assignOutput(List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceSchedule, Rate fpmlRate, Currency fpmlCurrency, Leg fpmlLeg) {
            priceSchedule.addAll(this.toBuilder(this.spreadSchedule(fpmlRate, fpmlCurrency, fpmlLeg).mapItem(item -> MapperS.of((Object)this.createPriceWithLocation.evaluate(this.mapScheduleToInterestRatePriceSchedule.evaluate((Schedule)item.get(), fpmlCurrency, ArithmeticOperationEnum.ADD), this.createPriceKey.evaluate("spreadSchedule", fpmlLeg)))).getMulti()));
            return Optional.ofNullable(priceSchedule).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends RateChoice> rateChoice(Rate fpmlRate, Currency fpmlCurrency, Leg fpmlLeg) {
            return MapperS.of((Object)this.toRateChoice.evaluate(fpmlRate));
        }

        @Override
        protected MapperC<? extends SpreadSchedule> spreadSchedule(Rate fpmlRate, Currency fpmlCurrency, Leg fpmlLeg) {
            if (ExpressionOperators.exists((Mapper)this.rateChoice(fpmlRate, fpmlCurrency, fpmlLeg).map("getFloatingRateCalculation", _rateChoice -> _rateChoice.getFloatingRateCalculation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.rateChoice(fpmlRate, fpmlCurrency, fpmlLeg).map("getFloatingRateCalculation", _rateChoice -> _rateChoice.getFloatingRateCalculation()).map("getFloatingRateModel", floatingRateCalculation -> floatingRateCalculation.getFloatingRateModel()).mapC("getSpreadSchedule", floatingRateModel -> floatingRateModel.getSpreadSchedule());
            }
            if (ExpressionOperators.exists((Mapper)this.rateChoice(fpmlRate, fpmlCurrency, fpmlLeg).map("getInflationRateCalculation", _rateChoice -> _rateChoice.getInflationRateCalculation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.rateChoice(fpmlRate, fpmlCurrency, fpmlLeg).map("getInflationRateCalculation", _rateChoice -> _rateChoice.getInflationRateCalculation()).map("getFloatingRateModel", inflationRateCalculation -> inflationRateCalculation.getFloatingRateModel()).mapC("getSpreadSchedule", floatingRateModel -> floatingRateModel.getSpreadSchedule());
            }
            return MapperC.ofNull();
        }
    }
}

