/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapUnitTypeWithScheme;
import cdm.ingest.fpml.confirmation.other.functions.MapFrequencyToPeriodMultiplier;
import cdm.ingest.fpml.confirmation.other.functions.MapPeriodExtendedEnum;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapQuantityStepListToDatedValueList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.com.CommodityNotionalQuantity;
import fpml.consolidated.com.CommodityQuantityFrequency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapQuantityUnitAmountToQuantityDefault.class)
public abstract class MapQuantityUnitAmountToQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapFrequencyToPeriodMultiplier mapFrequencyToPeriodMultiplier;
    @Inject
    protected MapPeriodExtendedEnum mapPeriodExtendedEnum;
    @Inject
    protected MapQuantityStepListToDatedValueList mapQuantityStepListToDatedValueList;
    @Inject
    protected MapUnitTypeWithScheme mapUnitTypeWithScheme;

    public NonNegativeQuantitySchedule evaluate(BigDecimal fpmlAmount, List<? extends CommodityNotionalQuantity> fpmlQuantityStep, QuantityUnit fpmlQuantityUnit, CommodityQuantityFrequency fpmlFrequency) {
        NonNegativeQuantitySchedule nonNegativeQuantitySchedule;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantityScheduleBuilder = this.doEvaluate(fpmlAmount, fpmlQuantityStep, fpmlQuantityUnit, fpmlFrequency);
        if (nonNegativeQuantityScheduleBuilder == null) {
            nonNegativeQuantitySchedule = null;
        } else {
            nonNegativeQuantitySchedule = nonNegativeQuantityScheduleBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)nonNegativeQuantitySchedule);
        }
        return nonNegativeQuantitySchedule;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(BigDecimal var1, List<? extends CommodityNotionalQuantity> var2, QuantityUnit var3, CommodityQuantityFrequency var4);

    protected abstract MapperS<? extends UnitType> unit(BigDecimal var1, List<? extends CommodityNotionalQuantity> var2, QuantityUnit var3, CommodityQuantityFrequency var4);

    public static class MapQuantityUnitAmountToQuantityDefault
    extends MapQuantityUnitAmountToQuantity {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(BigDecimal fpmlAmount, List<? extends CommodityNotionalQuantity> fpmlQuantityStep, QuantityUnit fpmlQuantityUnit, CommodityQuantityFrequency fpmlFrequency) {
            if (fpmlQuantityStep == null) {
                fpmlQuantityStep = Collections.emptyList();
            }
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantitySchedule = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(nonNegativeQuantitySchedule, fpmlAmount, fpmlQuantityStep, fpmlQuantityUnit, fpmlFrequency);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder nonNegativeQuantitySchedule, BigDecimal fpmlAmount, List<? extends CommodityNotionalQuantity> fpmlQuantityStep, QuantityUnit fpmlQuantityUnit, CommodityQuantityFrequency fpmlFrequency) {
            nonNegativeQuantitySchedule = ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlAmount)).getOrDefault(Boolean.valueOf(false)) != false ? (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder(NonNegativeQuantitySchedule.builder().setValue(fpmlAmount).setDatedValue(new ArrayList<DatedValue>(this.mapQuantityStepListToDatedValueList.evaluate(fpmlQuantityStep))).setUnit((UnitType)this.unit(fpmlAmount, fpmlQuantityStep, fpmlQuantityUnit, fpmlFrequency).get()).setFrequency(Frequency.builder().setPeriod(this.mapPeriodExtendedEnum.evaluate((String)MapperS.of((Object)fpmlFrequency).map("getValue", commodityQuantityFrequency -> commodityQuantityFrequency.getValue()).get())).setPeriodMultiplier(this.mapFrequencyToPeriodMultiplier.evaluate((String)MapperS.of((Object)fpmlFrequency).map("getValue", commodityQuantityFrequency -> commodityQuantityFrequency.getValue()).get())).build()).build()) : null;
            return Optional.ofNullable(nonNegativeQuantitySchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends UnitType> unit(BigDecimal fpmlAmount, List<? extends CommodityNotionalQuantity> fpmlQuantityStep, QuantityUnit fpmlQuantityUnit, CommodityQuantityFrequency fpmlFrequency) {
            return MapperS.of((Object)this.mapUnitTypeWithScheme.evaluate((String)MapperS.of((Object)fpmlQuantityUnit).map("getValue", quantityUnit -> quantityUnit.getValue()).get(), (String)MapperS.of((Object)fpmlQuantityUnit).map("getQuantityUnitScheme", quantityUnit -> quantityUnit.getQuantityUnitScheme()).get()));
        }
    }
}

