/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.ingest.fpml.confirmation.pricequantity.functions.GetFpmlExchangedCurrency;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapCurrencyToObservableCashWithLocation;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapFxCoreDetailsModelPriceListWithLocation;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapFxCoreDetailsModelQuantityListWithLocation;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.fx.FxCoreDetailsModel;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Leg;
import fpml.consolidated.shared.Payment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapFxCoreDetailsModelPriceQuantityListDefault.class)
public abstract class MapFxCoreDetailsModelPriceQuantityList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetFpmlExchangedCurrency getFpmlExchangedCurrency;
    @Inject
    protected MapCurrencyToObservableCashWithLocation mapCurrencyToObservableCashWithLocation;
    @Inject
    protected MapFxCoreDetailsModelPriceListWithLocation mapFxCoreDetailsModelPriceListWithLocation;
    @Inject
    protected MapFxCoreDetailsModelQuantityListWithLocation mapFxCoreDetailsModelQuantityListWithLocation;

    public List<? extends PriceQuantity> evaluate(FxCoreDetailsModel fpmlFxCoreDetailsModel, Leg fpmlLeg) {
        List priceQuantityList;
        List<PriceQuantity.PriceQuantityBuilder> priceQuantityListBuilder = this.doEvaluate(fpmlFxCoreDetailsModel, fpmlLeg);
        if (priceQuantityListBuilder == null) {
            priceQuantityList = null;
        } else {
            priceQuantityList = priceQuantityListBuilder.stream().map(PriceQuantity::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceQuantity.class, priceQuantityList);
        }
        return priceQuantityList;
    }

    protected abstract List<PriceQuantity.PriceQuantityBuilder> doEvaluate(FxCoreDetailsModel var1, Leg var2);

    protected abstract MapperS<? extends Payment> exchangedCurrency(FxCoreDetailsModel var1, Leg var2);

    public static class MapFxCoreDetailsModelPriceQuantityListDefault
    extends MapFxCoreDetailsModelPriceQuantityList {
        @Override
        protected List<PriceQuantity.PriceQuantityBuilder> doEvaluate(FxCoreDetailsModel fpmlFxCoreDetailsModel, Leg fpmlLeg) {
            ArrayList<PriceQuantity.PriceQuantityBuilder> priceQuantityList = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            return this.assignOutput(priceQuantityList, fpmlFxCoreDetailsModel, fpmlLeg);
        }

        protected List<PriceQuantity.PriceQuantityBuilder> assignOutput(List<PriceQuantity.PriceQuantityBuilder> priceQuantityList, FxCoreDetailsModel fpmlFxCoreDetailsModel, Leg fpmlLeg) {
            PriceQuantity priceQuantity = PriceQuantity.builder().setPrice(new ArrayList<FieldWithMetaPriceSchedule>(this.mapFxCoreDetailsModelPriceListWithLocation.evaluate(fpmlFxCoreDetailsModel, fpmlLeg))).setQuantity(new ArrayList<FieldWithMetaNonNegativeQuantitySchedule>(this.mapFxCoreDetailsModelQuantityListWithLocation.evaluate(fpmlFxCoreDetailsModel, fpmlLeg))).setObservable(this.mapCurrencyToObservableCashWithLocation.evaluate((Currency)this.exchangedCurrency(fpmlFxCoreDetailsModel, fpmlLeg).map("getPaymentAmount", payment -> payment.getPaymentAmount()).map("getCurrency", nonNegativeMoney -> nonNegativeMoney.getCurrency()).get(), fpmlLeg)).build();
            if (priceQuantity == null) {
                priceQuantityList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                priceQuantityList.addAll(this.toBuilder(Collections.singletonList(priceQuantity)));
            }
            return Optional.ofNullable(priceQuantityList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Payment> exchangedCurrency(FxCoreDetailsModel fpmlFxCoreDetailsModel, Leg fpmlLeg) {
            return MapperS.of((Object)this.getFpmlExchangedCurrency.evaluate(fpmlFxCoreDetailsModel));
        }
    }
}

