/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapStringWithScheme;
import cdm.ingest.fpml.confirmation.common.functions.MapUnitTypeWithScheme;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.CashPriceTypeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.com.CommodityFixedPrice;
import fpml.consolidated.com.CommodityPriceModel;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommmodityFixedPriceToPriceScheduleDefault.class)
public abstract class MapCommmodityFixedPriceToPriceSchedule
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapStringWithScheme mapStringWithScheme;
    @Inject
    protected MapUnitTypeWithScheme mapUnitTypeWithScheme;

    public PriceSchedule evaluate(CommodityFixedPrice fpmlCommodityFixedPrice) {
        PriceSchedule priceSchedule;
        PriceSchedule.PriceScheduleBuilder priceScheduleBuilder = this.doEvaluate(fpmlCommodityFixedPrice);
        if (priceScheduleBuilder == null) {
            priceSchedule = null;
        } else {
            priceSchedule = priceScheduleBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)priceSchedule);
        }
        return priceSchedule;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(CommodityFixedPrice var1);

    protected abstract MapperS<? extends CommodityPriceModel> commodityPriceModel(CommodityFixedPrice var1);

    protected abstract MapperS<? extends UnitType> unit(CommodityFixedPrice var1);

    protected abstract MapperS<? extends UnitType> perUnitOf(CommodityFixedPrice var1);

    public static class MapCommmodityFixedPriceToPriceScheduleDefault
    extends MapCommmodityFixedPriceToPriceSchedule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(CommodityFixedPrice fpmlCommodityFixedPrice) {
            PriceSchedule.PriceScheduleBuilder priceSchedule = PriceSchedule.builder();
            return this.assignOutput(priceSchedule, fpmlCommodityFixedPrice);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder priceSchedule, CommodityFixedPrice fpmlCommodityFixedPrice) {
            priceSchedule = (PriceSchedule.PriceScheduleBuilder)this.toBuilder(PriceSchedule.builder().setValue((BigDecimal)MapperS.of((Object)fpmlCommodityFixedPrice).map("getPrice", commodityFixedPrice -> commodityFixedPrice.getPrice()).get()).setUnit((UnitType)this.unit(fpmlCommodityFixedPrice).get()).setPerUnitOf((UnitType)this.perUnitOf(fpmlCommodityFixedPrice).get()).setPriceType(PriceTypeEnum.CASH_PRICE).setCashPrice(CashPrice.builder().setCashPriceType(CashPriceTypeEnum.FEE).build()).build());
            return Optional.ofNullable(priceSchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends CommodityPriceModel> commodityPriceModel(CommodityFixedPrice fpmlCommodityFixedPrice) {
            return MapperS.of((Object)fpmlCommodityFixedPrice).map("getCommodityPriceModel", commodityFixedPrice -> commodityFixedPrice.getCommodityPriceModel());
        }

        @Override
        protected MapperS<? extends UnitType> unit(CommodityFixedPrice fpmlCommodityFixedPrice) {
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapStringWithScheme.evaluate((String)this.commodityPriceModel(fpmlCommodityFixedPrice).map("getPriceCurrency", _commodityPriceModel -> _commodityPriceModel.getPriceCurrency()).map("getValue", currency -> currency.getValue()).get(), (String)this.commodityPriceModel(fpmlCommodityFixedPrice).map("getPriceCurrency", _commodityPriceModel -> _commodityPriceModel.getPriceCurrency()).map("getCurrencyScheme", currency -> currency.getCurrencyScheme()).get())).build());
        }

        @Override
        protected MapperS<? extends UnitType> perUnitOf(CommodityFixedPrice fpmlCommodityFixedPrice) {
            return MapperS.of((Object)this.mapUnitTypeWithScheme.evaluate((String)this.commodityPriceModel(fpmlCommodityFixedPrice).map("getPriceUnit", _commodityPriceModel -> _commodityPriceModel.getPriceUnit()).map("getValue", quantityUnit -> quantityUnit.getValue()).get(), (String)this.commodityPriceModel(fpmlCommodityFixedPrice).map("getPriceUnit", _commodityPriceModel -> _commodityPriceModel.getPriceUnit()).map("getQuantityUnitScheme", quantityUnit -> quantityUnit.getQuantityUnitScheme()).get()));
        }
    }
}

