/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.payment.functions;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Money;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapMoneyToTransferCashAssetDefault.class)
public abstract class MapMoneyToTransferCashAsset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Asset evaluate(Money fpmMoney) {
        Asset asset;
        Asset.AssetBuilder assetBuilder = this.doEvaluate(fpmMoney);
        if (assetBuilder == null) {
            asset = null;
        } else {
            asset = assetBuilder.build();
            this.objectValidator.validate(Asset.class, (RosettaModelObject)asset);
        }
        return asset;
    }

    protected abstract Asset.AssetBuilder doEvaluate(Money var1);

    public static class MapMoneyToTransferCashAssetDefault
    extends MapMoneyToTransferCashAsset {
        @Override
        protected Asset.AssetBuilder doEvaluate(Money fpmMoney) {
            Asset.AssetBuilder asset = Asset.builder();
            return this.assignOutput(asset, fpmMoney);
        }

        protected Asset.AssetBuilder assignOutput(Asset.AssetBuilder asset, Money fpmMoney) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmMoney)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                AssetIdentifier assetIdentifier = AssetIdentifier.builder().setIdentifierValue((String)MapperS.of((Object)fpmMoney).map("getCurrency", money -> money.getCurrency()).map("getValue", currency -> currency.getValue()).get()).setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE).build();
                asset = (Asset.AssetBuilder)this.toBuilder(Asset.builder().setCash(Cash.builder().setIdentifier(assetIdentifier == null ? Collections.emptyList() : Collections.singletonList(assetIdentifier)).build()).build());
            } else {
                asset = null;
            }
            return Optional.ofNullable(asset).map(o -> o.prune()).orElse(null);
        }
    }
}

