/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.legal.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.legal.functions.MapLegalAgreement;
import cdm.ingest.fpml.confirmation.legal.functions.MapMasterAgreementTypeEnumWithScheme;
import cdm.legaldocumentation.common.AgreementName;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.consolidated.shared.MasterAgreement;
import fpml.consolidated.shared.MasterAgreementType;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapMasterAgreementDefault.class)
public abstract class MapMasterAgreement
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapLegalAgreement mapLegalAgreement;
    @Inject
    protected MapMasterAgreementTypeEnumWithScheme mapMasterAgreementTypeEnumWithScheme;

    public LegalAgreement evaluate(MasterAgreement fpmlMasterAgreement, List<? extends Counterparty> cdmCounterpartyList) {
        LegalAgreement legalAgreement;
        LegalAgreement.LegalAgreementBuilder legalAgreementBuilder = this.doEvaluate(fpmlMasterAgreement, cdmCounterpartyList);
        if (legalAgreementBuilder == null) {
            legalAgreement = null;
        } else {
            legalAgreement = legalAgreementBuilder.build();
            this.objectValidator.validate(LegalAgreement.class, (RosettaModelObject)legalAgreement);
        }
        return legalAgreement;
    }

    protected abstract LegalAgreement.LegalAgreementBuilder doEvaluate(MasterAgreement var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends AgreementName> cdmAgreementName(MasterAgreement var1, List<? extends Counterparty> var2);

    public static class MapMasterAgreementDefault
    extends MapMasterAgreement {
        @Override
        protected LegalAgreement.LegalAgreementBuilder doEvaluate(MasterAgreement fpmlMasterAgreement, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            LegalAgreement.LegalAgreementBuilder legalAgreement = LegalAgreement.builder();
            return this.assignOutput(legalAgreement, fpmlMasterAgreement, cdmCounterpartyList);
        }

        protected LegalAgreement.LegalAgreementBuilder assignOutput(LegalAgreement.LegalAgreementBuilder legalAgreement, MasterAgreement fpmlMasterAgreement, List<? extends Counterparty> cdmCounterpartyList) {
            legalAgreement = (LegalAgreement.LegalAgreementBuilder)this.toBuilder(this.mapLegalAgreement.evaluate((Date)MapperS.of((Object)fpmlMasterAgreement).map("getMasterAgreementDate", masterAgreement -> masterAgreement.getMasterAgreementDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get(), cdmCounterpartyList, (AgreementName)this.cdmAgreementName(fpmlMasterAgreement, cdmCounterpartyList).get(), (Integer)MapperS.of((Object)fpmlMasterAgreement).map("getMasterAgreementVersion", masterAgreement -> masterAgreement.getMasterAgreementVersion()).map("getValue", masterAgreementVersion -> masterAgreementVersion.getValue()).checkedMap("to-int", Integer::parseInt, NumberFormatException.class).get()));
            return Optional.ofNullable(legalAgreement).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends AgreementName> cdmAgreementName(MasterAgreement fpmlMasterAgreement, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)AgreementName.builder().setMasterAgreementType(this.mapMasterAgreementTypeEnumWithScheme.evaluate((MasterAgreementType)MapperS.of((Object)fpmlMasterAgreement).map("getMasterAgreementType", masterAgreement -> masterAgreement.getMasterAgreementType()).get())).setAgreementType(LegalAgreementTypeEnum.MASTER_AGREEMENT).build());
        }
    }
}

