/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.datetime.functions;

import cdm.ingest.fpml.confirmation.datetime.functions.MapPeriodToFrequency;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.consolidated.cd.PeriodicPayment;
import fpml.consolidated.shared.Period;
import java.time.LocalDate;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapPeriodicPaymentToPaymentDatesDefault.class)
public abstract class MapPeriodicPaymentToPaymentDates
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapPeriodToFrequency mapPeriodToFrequency;

    public PaymentDates evaluate(PeriodicPayment fpmlPeriodicPayment) {
        PaymentDates paymentFrequency;
        PaymentDates.PaymentDatesBuilder paymentFrequencyBuilder = this.doEvaluate(fpmlPeriodicPayment);
        if (paymentFrequencyBuilder == null) {
            paymentFrequency = null;
        } else {
            paymentFrequency = paymentFrequencyBuilder.build();
            this.objectValidator.validate(PaymentDates.class, (RosettaModelObject)paymentFrequency);
        }
        return paymentFrequency;
    }

    protected abstract PaymentDates.PaymentDatesBuilder doEvaluate(PeriodicPayment var1);

    public static class MapPeriodicPaymentToPaymentDatesDefault
    extends MapPeriodicPaymentToPaymentDates {
        @Override
        protected PaymentDates.PaymentDatesBuilder doEvaluate(PeriodicPayment fpmlPeriodicPayment) {
            PaymentDates.PaymentDatesBuilder paymentFrequency = PaymentDates.builder();
            return this.assignOutput(paymentFrequency, fpmlPeriodicPayment);
        }

        protected PaymentDates.PaymentDatesBuilder assignOutput(PaymentDates.PaymentDatesBuilder paymentFrequency, PeriodicPayment fpmlPeriodicPayment) {
            paymentFrequency = (PaymentDates.PaymentDatesBuilder)this.toBuilder(PaymentDates.builder().setPaymentFrequency(this.mapPeriodToFrequency.evaluate((Period)MapperS.of((Object)fpmlPeriodicPayment).map("getPaymentFrequency", periodicPayment -> periodicPayment.getPaymentFrequency()).get())).setFirstPaymentDate((Date)MapperS.of((Object)fpmlPeriodicPayment).map("getFirstPaymentDate", periodicPayment -> periodicPayment.getFirstPaymentDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setLastRegularPaymentDate((Date)MapperS.of((Object)fpmlPeriodicPayment).map("getLastRegularPaymentDate", periodicPayment -> periodicPayment.getLastRegularPaymentDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).build());
            return Optional.ofNullable(paymentFrequency).map(o -> o.prune()).orElse(null);
        }
    }
}

