/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.datetime.functions;

import cdm.base.datetime.DateTimeList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapFpmlDateTimeListToDateTimeListDefault.class)
public abstract class MapFpmlDateTimeListToDateTimeList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends DateTimeList> evaluate(fpml.consolidated.shared.DateTimeList fpmldateTime) {
        List zonedDateTime;
        List<DateTimeList.DateTimeListBuilder> zonedDateTimeBuilder = this.doEvaluate(fpmldateTime);
        if (zonedDateTimeBuilder == null) {
            zonedDateTime = null;
        } else {
            zonedDateTime = zonedDateTimeBuilder.stream().map(DateTimeList::build).collect(Collectors.toList());
            this.objectValidator.validate(DateTimeList.class, zonedDateTime);
        }
        return zonedDateTime;
    }

    protected abstract List<DateTimeList.DateTimeListBuilder> doEvaluate(fpml.consolidated.shared.DateTimeList var1);

    public static class MapFpmlDateTimeListToDateTimeListDefault
    extends MapFpmlDateTimeListToDateTimeList {
        @Override
        protected List<DateTimeList.DateTimeListBuilder> doEvaluate(fpml.consolidated.shared.DateTimeList fpmldateTime) {
            ArrayList<DateTimeList.DateTimeListBuilder> zonedDateTime = new ArrayList<DateTimeList.DateTimeListBuilder>();
            return this.assignOutput(zonedDateTime, fpmldateTime);
        }

        protected List<DateTimeList.DateTimeListBuilder> assignOutput(List<DateTimeList.DateTimeListBuilder> zonedDateTime, fpml.consolidated.shared.DateTimeList fpmldateTime) {
            DateTimeList dateTimeList = DateTimeList.builder().setDateTime(MapperS.of((Object)fpmldateTime).mapC("getDateTime", _dateTimeList -> _dateTimeList.getDateTime()).getMulti()).build();
            if (dateTimeList == null) {
                zonedDateTime.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                zonedDateTime.addAll(this.toBuilder(Collections.singletonList(dateTimeList)));
            }
            return Optional.ofNullable(zonedDateTime).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

