/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.qualification.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.functions.FilterClosedTradeStates;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaObservable;
import cdm.product.template.EconomicTerms;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_OnDemandRateChangeDefault.class)
public abstract class Qualify_OnDemandRateChange
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected FilterClosedTradeStates filterClosedTradeStates;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract MapperS<? extends Trade> beforeTrade(BusinessEvent var1);

    protected abstract MapperS<? extends NonTransferableProduct> beforeProduct(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent var1);

    protected abstract MapperS<? extends Trade> openTrade(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent var1);

    protected abstract MapperC<? extends TradeState> closedTradeState(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> openPriceQuantityRateOnly(BusinessEvent var1);

    protected abstract MapperC<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent var1);

    protected abstract MapperC<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_OnDemandRateChangeDefault
    extends Qualify_OnDemandRateChange {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperators.exists(this.beforeEconomicterms(businessEvent)).and(ExpressionOperators.exists(this.openEconomicTerms(businessEvent))).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.closedTradeState(businessEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)this.openEconomicTerms(businessEvent).map("getCollateral", economicTerms -> economicTerms.getCollateral()), (Mapper)this.beforeEconomicterms(businessEvent).map("getCollateral", economicTerms -> economicTerms.getCollateral()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.beforePriceQuantityRateOnly(businessEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.openPriceQuantityRateOnly(businessEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)((BigDecimal)this.beforePriceQuantityRateOnly(businessEvent).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.openPriceQuantityRateOnly(businessEvent).get())), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.areEqual(this.beforePriceQuantityNoRate(businessEvent), this.openPriceQuantityNoRate(businessEvent), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected MapperS<? extends Trade> beforeTrade(BusinessEvent businessEvent) {
            return MapperS.of((Object)((Instruction)MapperS.of((Object)businessEvent).mapC("getInstruction", _businessEvent -> _businessEvent.getInstruction()).get())).map("getBefore", instruction -> instruction.getBefore()).map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState == null ? null : referenceWithMetaTradeState.getValue()).map("getTrade", tradeState -> tradeState.getTrade());
        }

        @Override
        protected MapperS<? extends NonTransferableProduct> beforeProduct(BusinessEvent businessEvent) {
            return this.beforeTrade(businessEvent).map("getProduct", trade -> trade.getProduct());
        }

        @Override
        protected MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
            return this.beforeProduct(businessEvent).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }

        @Override
        protected MapperS<? extends Trade> openTrade(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeState)MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get())).map("getTrade", tradeState -> tradeState.getTrade());
        }

        @Override
        protected MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
            return this.openTrade(businessEvent).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms());
        }

        @Override
        protected MapperC<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
            return MapperC.of(this.filterClosedTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
        }

        @Override
        protected MapperC<BigDecimal> beforePriceQuantityRateOnly(BusinessEvent businessEvent) {
            MapperListOfLists thenArg0 = MapperS.of((Object)((TradeLot)this.beforeTrade(businessEvent).mapC("getTradeLot", trade -> trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
            MapperC thenArg1 = thenArg0.flattenList();
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg2.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
        }

        @Override
        protected MapperC<BigDecimal> openPriceQuantityRateOnly(BusinessEvent businessEvent) {
            MapperListOfLists thenArg0 = MapperS.of((Object)((TradeLot)this.openTrade(businessEvent).mapC("getTradeLot", trade -> trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItemToList(item -> item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()));
            MapperC thenArg1 = thenArg0.flattenList();
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg2.mapItem(item -> item.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()));
        }

        @Override
        protected MapperC<? extends PriceQuantity> beforePriceQuantityNoRate(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)this.beforeTrade(businessEvent).mapC("getTradeLot", trade -> trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItem(item -> MapperS.of((Object)PriceQuantity.builder().setPrice(item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(p -> ExpressionOperators.notEqual((Mapper)p.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.Any).get()).getMulti()).setQuantity(item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).getMulti()).setObservable((FieldWithMetaObservable)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).get()).build()));
        }

        @Override
        protected MapperC<? extends PriceQuantity> openPriceQuantityNoRate(BusinessEvent businessEvent) {
            return MapperS.of((Object)((TradeLot)this.openTrade(businessEvent).mapC("getTradeLot", trade -> trade.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapItem(item -> MapperS.of((Object)PriceQuantity.builder().setPrice(item.mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).filterItemNullSafe(p -> ExpressionOperators.notEqual((Mapper)p.map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule == null ? null : fieldWithMetaPriceSchedule.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.Any).get()).getMulti()).setQuantity(item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).getMulti()).setObservable((FieldWithMetaObservable)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).get()).build()));
        }
    }
}

