/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.validation.datarule;

import cdm.event.position.PositionBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PositionBaseProductOrAsset")
@ImplementedBy(value=Default.class)
public interface PositionBaseProductOrAsset
extends Validator<PositionBase> {
    public static final String NAME = "PositionBaseProductOrAsset";
    public static final String DEFINITION = "required choice product, asset";

    public static class NoOp
    implements PositionBaseProductOrAsset {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PositionBase positionBase) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PositionBaseProductOrAsset {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PositionBase positionBase) {
            ComparisonResult result = this.executeDataRule(positionBase);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PositionBaseProductOrAsset.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PositionBase", (RosettaPath)path, (String)PositionBaseProductOrAsset.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PositionBaseProductOrAsset.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PositionBase", (RosettaPath)path, (String)PositionBaseProductOrAsset.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PositionBase positionBase) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)positionBase), Arrays.asList("product", "asset"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

