/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.event.common.ContractDetails;
import cdm.event.common.ExecutionDetails;
import cdm.event.common.metafields.ReferenceWithMetaContractDetails;
import cdm.event.common.metafields.ReferenceWithMetaExecutionDetails;
import cdm.event.position.meta.ContractBaseMeta;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.metafields.ReferenceWithMetaCollateral;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ContractBase", builder=ContractBaseBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ContractBase", model="cdm", builder=ContractBaseBuilderImpl.class, version="7.0.0-dev.52")
public interface ContractBase
extends RosettaModelObject {
    public static final ContractBaseMeta metaData = new ContractBaseMeta();

    public ReferenceWithMetaContractDetails getContractDetails();

    public ReferenceWithMetaExecutionDetails getExecutionDetails();

    public ReferenceWithMetaCollateral getCollateral();

    public ContractBase build();

    public ContractBaseBuilder toBuilder();

    public static ContractBaseBuilder builder() {
        return new ContractBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends ContractBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ContractBase> getType() {
        return ContractBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contractDetails"), processor, ReferenceWithMetaContractDetails.class, this.getContractDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionDetails"), processor, ReferenceWithMetaExecutionDetails.class, this.getExecutionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, ReferenceWithMetaCollateral.class, this.getCollateral(), new AttributeMeta[0]);
    }

    public static class ContractBaseBuilderImpl
    implements ContractBaseBuilder {
        protected ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder contractDetails;
        protected ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder executionDetails;
        protected ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder collateral;

        @Override
        @RosettaAttribute(value="contractDetails")
        @RuneAttribute(value="contractDetails")
        public ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder getContractDetails() {
            return this.contractDetails;
        }

        @Override
        public ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder getOrCreateContractDetails() {
            ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder result = this.contractDetails != null ? this.contractDetails : (this.contractDetails = ReferenceWithMetaContractDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        @RuneAttribute(value="executionDetails")
        public ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        public ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder getOrCreateExecutionDetails() {
            ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder result = this.executionDetails != null ? this.executionDetails : (this.executionDetails = ReferenceWithMetaExecutionDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder getOrCreateCollateral() {
            ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = ReferenceWithMetaCollateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        @RuneAttribute(value="contractDetails")
        public ContractBaseBuilder setContractDetails(ReferenceWithMetaContractDetails _contractDetails) {
            this.contractDetails = _contractDetails == null ? null : _contractDetails.toBuilder();
            return this;
        }

        @Override
        public ContractBaseBuilder setContractDetailsValue(ContractDetails _contractDetails) {
            this.getOrCreateContractDetails().setValue(_contractDetails);
            return this;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        @RuneAttribute(value="executionDetails")
        public ContractBaseBuilder setExecutionDetails(ReferenceWithMetaExecutionDetails _executionDetails) {
            this.executionDetails = _executionDetails == null ? null : _executionDetails.toBuilder();
            return this;
        }

        @Override
        public ContractBaseBuilder setExecutionDetailsValue(ExecutionDetails _executionDetails) {
            this.getOrCreateExecutionDetails().setValue(_executionDetails);
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public ContractBaseBuilder setCollateral(ReferenceWithMetaCollateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        public ContractBaseBuilder setCollateralValue(Collateral _collateral) {
            this.getOrCreateCollateral().setValue(_collateral);
            return this;
        }

        @Override
        public ContractBase build() {
            return new ContractBaseImpl(this);
        }

        @Override
        public ContractBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public ContractBaseBuilder prune() {
            if (this.contractDetails != null && !this.contractDetails.prune().hasData()) {
                this.contractDetails = null;
            }
            if (this.executionDetails != null && !this.executionDetails.prune().hasData()) {
                this.executionDetails = null;
            }
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getContractDetails() != null && this.getContractDetails().hasData()) {
                return true;
            }
            if (this.getExecutionDetails() != null && this.getExecutionDetails().hasData()) {
                return true;
            }
            return this.getCollateral() != null && this.getCollateral().hasData();
        }

        public ContractBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ContractBaseBuilder o = (ContractBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContractDetails(), (RosettaModelObjectBuilder)o.getContractDetails(), this::setContractDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionDetails(), (RosettaModelObjectBuilder)o.getExecutionDetails(), this::setExecutionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractBase _that = this.getType().cast(o);
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            return Objects.equals(this.collateral, _that.getCollateral());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractBaseBuilder {contractDetails=" + this.contractDetails + ", executionDetails=" + this.executionDetails + ", collateral=" + this.collateral + '}';
        }
    }

    public static interface ContractBaseBuilder
    extends ContractBase,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder getOrCreateContractDetails();

        @Override
        public ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder getContractDetails();

        public ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder getOrCreateExecutionDetails();

        @Override
        public ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder getExecutionDetails();

        public ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder getOrCreateCollateral();

        @Override
        public ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder getCollateral();

        public ContractBaseBuilder setContractDetails(ReferenceWithMetaContractDetails var1);

        public ContractBaseBuilder setContractDetailsValue(ContractDetails var1);

        public ContractBaseBuilder setExecutionDetails(ReferenceWithMetaExecutionDetails var1);

        public ContractBaseBuilder setExecutionDetailsValue(ExecutionDetails var1);

        public ContractBaseBuilder setCollateral(ReferenceWithMetaCollateral var1);

        public ContractBaseBuilder setCollateralValue(Collateral var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contractDetails"), processor, ReferenceWithMetaContractDetails.ReferenceWithMetaContractDetailsBuilder.class, this.getContractDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionDetails"), processor, ReferenceWithMetaExecutionDetails.ReferenceWithMetaExecutionDetailsBuilder.class, this.getExecutionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, ReferenceWithMetaCollateral.ReferenceWithMetaCollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
        }

        public ContractBaseBuilder prune();
    }

    public static class ContractBaseImpl
    implements ContractBase {
        private final ReferenceWithMetaContractDetails contractDetails;
        private final ReferenceWithMetaExecutionDetails executionDetails;
        private final ReferenceWithMetaCollateral collateral;

        protected ContractBaseImpl(ContractBaseBuilder builder) {
            this.contractDetails = Optional.ofNullable(builder.getContractDetails()).map(f -> f.build()).orElse(null);
            this.executionDetails = Optional.ofNullable(builder.getExecutionDetails()).map(f -> f.build()).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="contractDetails")
        @RuneAttribute(value="contractDetails")
        public ReferenceWithMetaContractDetails getContractDetails() {
            return this.contractDetails;
        }

        @Override
        @RosettaAttribute(value="executionDetails")
        @RuneAttribute(value="executionDetails")
        public ReferenceWithMetaExecutionDetails getExecutionDetails() {
            return this.executionDetails;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public ReferenceWithMetaCollateral getCollateral() {
            return this.collateral;
        }

        @Override
        public ContractBase build() {
            return this;
        }

        @Override
        public ContractBaseBuilder toBuilder() {
            ContractBaseBuilder builder = ContractBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ContractBaseBuilder builder) {
            Optional.ofNullable(this.getContractDetails()).ifPresent(builder::setContractDetails);
            Optional.ofNullable(this.getExecutionDetails()).ifPresent(builder::setExecutionDetails);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ContractBase _that = this.getType().cast(o);
            if (!Objects.equals(this.contractDetails, _that.getContractDetails())) {
                return false;
            }
            if (!Objects.equals(this.executionDetails, _that.getExecutionDetails())) {
                return false;
            }
            return Objects.equals(this.collateral, _that.getCollateral());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contractDetails != null ? this.contractDetails.hashCode() : 0);
            _result = 31 * _result + (this.executionDetails != null ? this.executionDetails.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ContractBase {contractDetails=" + this.contractDetails + ", executionDetails=" + this.executionDetails + ", collateral=" + this.collateral + '}';
        }
    }
}

