/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.TradeState;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractOpenEconomicTermsDefault.class)
public abstract class ExtractOpenEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public EconomicTerms evaluate(BusinessEvent businessEvent) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(businessEvent);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(BusinessEvent var1);

    public static class ExtractOpenEconomicTermsDefault
    extends ExtractOpenEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(BusinessEvent businessEvent) {
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, businessEvent);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, BusinessEvent businessEvent) {
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((TradeState)MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).get())).map("getTrade", tradeState -> tradeState.getTrade()).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).get());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

