/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.MarginCallBase;
import cdm.event.common.MarginCallExposure;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallIssuanceMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import cdm.product.collateral.EligibleCollateralCriteria;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MarginCallIssuance", builder=MarginCallIssuanceBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="MarginCallIssuance", model="cdm", builder=MarginCallIssuanceBuilderImpl.class, version="7.0.0-dev.52")
public interface MarginCallIssuance
extends MarginCallBase {
    public static final MarginCallIssuanceMeta metaData = new MarginCallIssuanceMeta();

    public Money getCallAmountInBaseCurrency();

    public List<? extends EligibleCollateralCriteria> getRecallNonCashCollateralDescription();

    @Override
    public MarginCallIssuance build();

    @Override
    public MarginCallIssuanceBuilder toBuilder();

    public static MarginCallIssuanceBuilder builder() {
        return new MarginCallIssuanceBuilderImpl();
    }

    default public RosettaMetaData<? extends MarginCallIssuance> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MarginCallIssuance> getType() {
        return MarginCallIssuance.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.class, this.getInstructionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.class, this.getClearingBroker(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.class, this.getCallIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.class, this.getCallAgreementType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.class, this.getAgreementThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.class, this.getAgreementRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAmountInBaseCurrency"), processor, Money.class, this.getCallAmountInBaseCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("recallNonCashCollateralDescription"), processor, EligibleCollateralCriteria.class, this.getRecallNonCashCollateralDescription(), new AttributeMeta[0]);
    }

    public static class MarginCallIssuanceBuilderImpl
    extends MarginCallBase.MarginCallBaseBuilderImpl
    implements MarginCallIssuanceBuilder {
        protected Money.MoneyBuilder callAmountInBaseCurrency;
        protected List<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> recallNonCashCollateralDescription = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency", isRequired=true)
        @RuneAttribute(value="callAmountInBaseCurrency", isRequired=true)
        public Money.MoneyBuilder getCallAmountInBaseCurrency() {
            return this.callAmountInBaseCurrency;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCallAmountInBaseCurrency() {
            Money.MoneyBuilder result = this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency : (this.callAmountInBaseCurrency = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        @RuneAttribute(value="recallNonCashCollateralDescription")
        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getRecallNonCashCollateralDescription() {
            return this.recallNonCashCollateralDescription;
        }

        @Override
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateRecallNonCashCollateralDescription(int index) {
            if (this.recallNonCashCollateralDescription == null) {
                this.recallNonCashCollateralDescription = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
            }
            return (EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder)this.getIndex(this.recallNonCashCollateralDescription, index, () -> {
                EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder newRecallNonCashCollateralDescription = EligibleCollateralCriteria.builder();
                return newRecallNonCashCollateralDescription;
            });
        }

        @Override
        @RosettaAttribute(value="instructionType", isRequired=true)
        @RuneAttribute(value="instructionType", isRequired=true)
        public MarginCallIssuanceBuilder setInstructionType(MarginCallInstructionType _instructionType) {
            this.instructionType = _instructionType == null ? null : _instructionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public MarginCallIssuanceBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public MarginCallIssuanceBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public MarginCallIssuanceBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole _partyRole, int idx) {
            this.getIndex(this.partyRole, idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public MarginCallIssuanceBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        @RuneAttribute(value="clearingBroker")
        public MarginCallIssuanceBuilder setClearingBroker(Party _clearingBroker) {
            this.clearingBroker = _clearingBroker == null ? null : _clearingBroker.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        @RuneAttribute(value="callIdentifier")
        public MarginCallIssuanceBuilder setCallIdentifier(Identifier _callIdentifier) {
            this.callIdentifier = _callIdentifier == null ? null : _callIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callAgreementType", isRequired=true)
        @RuneAttribute(value="callAgreementType", isRequired=true)
        public MarginCallIssuanceBuilder setCallAgreementType(AgreementName _callAgreementType) {
            this.callAgreementType = _callAgreementType == null ? null : _callAgreementType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        @RuneAttribute(value="agreementMinimumTransferAmount")
        public MarginCallIssuanceBuilder setAgreementMinimumTransferAmount(Money _agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = _agreementMinimumTransferAmount == null ? null : _agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        @RuneAttribute(value="agreementThreshold")
        public MarginCallIssuanceBuilder setAgreementThreshold(Money _agreementThreshold) {
            this.agreementThreshold = _agreementThreshold == null ? null : _agreementThreshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        @RuneAttribute(value="agreementRounding")
        public MarginCallIssuanceBuilder setAgreementRounding(Money _agreementRounding) {
            this.agreementRounding = _agreementRounding == null ? null : _agreementRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regMarginType", isRequired=true)
        @RuneAttribute(value="regMarginType", isRequired=true)
        public MarginCallIssuanceBuilder setRegMarginType(RegMarginTypeEnum _regMarginType) {
            this.regMarginType = _regMarginType == null ? null : _regMarginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        @RuneAttribute(value="regIMRole")
        public MarginCallIssuanceBuilder setRegIMRole(RegIMRoleEnum _regIMRole) {
            this.regIMRole = _regIMRole == null ? null : _regIMRole;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        @RuneAttribute(value="baseCurrencyExposure")
        public MarginCallIssuanceBuilder setBaseCurrencyExposure(MarginCallExposure _baseCurrencyExposure) {
            this.baseCurrencyExposure = _baseCurrencyExposure == null ? null : _baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public MarginCallIssuanceBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio _collateralPortfolio) {
            this.collateralPortfolio = _collateralPortfolio == null ? null : _collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolioValue(CollateralPortfolio _collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(_collateralPortfolio);
            return this;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        @RuneAttribute(value="independentAmountBalance")
        public MarginCallIssuanceBuilder setIndependentAmountBalance(CollateralBalance _independentAmountBalance) {
            this.independentAmountBalance = _independentAmountBalance == null ? null : _independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency", isRequired=true)
        @RuneAttribute(value="callAmountInBaseCurrency", isRequired=true)
        public MarginCallIssuanceBuilder setCallAmountInBaseCurrency(Money _callAmountInBaseCurrency) {
            this.callAmountInBaseCurrency = _callAmountInBaseCurrency == null ? null : _callAmountInBaseCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        @RuneAttribute(value="recallNonCashCollateralDescription")
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria _recallNonCashCollateralDescription) {
            if (_recallNonCashCollateralDescription != null) {
                this.recallNonCashCollateralDescription.add(_recallNonCashCollateralDescription.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria _recallNonCashCollateralDescription, int idx) {
            this.getIndex(this.recallNonCashCollateralDescription, idx, () -> _recallNonCashCollateralDescription.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescriptions) {
            if (recallNonCashCollateralDescriptions != null) {
                for (EligibleCollateralCriteria eligibleCollateralCriteria : recallNonCashCollateralDescriptions) {
                    this.recallNonCashCollateralDescription.add(eligibleCollateralCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="recallNonCashCollateralDescription")
        public MarginCallIssuanceBuilder setRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescriptions) {
            this.recallNonCashCollateralDescription = recallNonCashCollateralDescriptions == null ? new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>() : (List)recallNonCashCollateralDescriptions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallIssuance build() {
            return new MarginCallIssuanceImpl(this);
        }

        @Override
        public MarginCallIssuanceBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder prune() {
            super.prune();
            if (this.callAmountInBaseCurrency != null && !this.callAmountInBaseCurrency.prune().hasData()) {
                this.callAmountInBaseCurrency = null;
            }
            this.recallNonCashCollateralDescription = this.recallNonCashCollateralDescription.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCallAmountInBaseCurrency() != null && this.getCallAmountInBaseCurrency().hasData()) {
                return true;
            }
            return this.getRecallNonCashCollateralDescription() != null && this.getRecallNonCashCollateralDescription().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public MarginCallIssuanceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MarginCallIssuanceBuilder o = (MarginCallIssuanceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallAmountInBaseCurrency(), (RosettaModelObjectBuilder)o.getCallAmountInBaseCurrency(), this::setCallAmountInBaseCurrency);
            merger.mergeRosetta(this.getRecallNonCashCollateralDescription(), o.getRecallNonCashCollateralDescription(), this::getOrCreateRecallNonCashCollateralDescription);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallIssuance _that = (MarginCallIssuance)this.getType().cast(o);
            if (!Objects.equals(this.callAmountInBaseCurrency, _that.getCallAmountInBaseCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.recallNonCashCollateralDescription, _that.getRecallNonCashCollateralDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.recallNonCashCollateralDescription != null ? this.recallNonCashCollateralDescription.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallIssuanceBuilder {callAmountInBaseCurrency=" + this.callAmountInBaseCurrency + ", recallNonCashCollateralDescription=" + this.recallNonCashCollateralDescription + '}' + " " + super.toString();
        }
    }

    public static interface MarginCallIssuanceBuilder
    extends MarginCallIssuance,
    MarginCallBase.MarginCallBaseBuilder {
        public Money.MoneyBuilder getOrCreateCallAmountInBaseCurrency();

        @Override
        public Money.MoneyBuilder getCallAmountInBaseCurrency();

        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateRecallNonCashCollateralDescription(int var1);

        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getRecallNonCashCollateralDescription();

        @Override
        public MarginCallIssuanceBuilder setInstructionType(MarginCallInstructionType var1);

        @Override
        public MarginCallIssuanceBuilder addParty(Party var1);

        @Override
        public MarginCallIssuanceBuilder addParty(Party var1, int var2);

        @Override
        public MarginCallIssuanceBuilder addParty(List<? extends Party> var1);

        @Override
        public MarginCallIssuanceBuilder setParty(List<? extends Party> var1);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole var1);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole var1, int var2);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallIssuanceBuilder setPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallIssuanceBuilder setClearingBroker(Party var1);

        @Override
        public MarginCallIssuanceBuilder setCallIdentifier(Identifier var1);

        @Override
        public MarginCallIssuanceBuilder setCallAgreementType(AgreementName var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementMinimumTransferAmount(Money var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementThreshold(Money var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementRounding(Money var1);

        @Override
        public MarginCallIssuanceBuilder setRegMarginType(RegMarginTypeEnum var1);

        @Override
        public MarginCallIssuanceBuilder setRegIMRole(RegIMRoleEnum var1);

        @Override
        public MarginCallIssuanceBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        @Override
        public MarginCallIssuanceBuilder setIndependentAmountBalance(CollateralBalance var1);

        public MarginCallIssuanceBuilder setCallAmountInBaseCurrency(Money var1);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria var1);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria var1, int var2);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> var1);

        public MarginCallIssuanceBuilder setRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.MarginCallInstructionTypeBuilder.class, (RosettaModelObjectBuilder)this.getInstructionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.PartyBuilder.class, (RosettaModelObjectBuilder)this.getClearingBroker(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.IdentifierBuilder.class, (RosettaModelObjectBuilder)this.getCallIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.AgreementNameBuilder.class, (RosettaModelObjectBuilder)this.getCallAgreementType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAgreementRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.MarginCallExposureBuilder.class, (RosettaModelObjectBuilder)this.getBaseCurrencyExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, (RosettaModelObjectBuilder)this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, (RosettaModelObjectBuilder)this.getIndependentAmountBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAmountInBaseCurrency"), processor, Money.MoneyBuilder.class, this.getCallAmountInBaseCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("recallNonCashCollateralDescription"), processor, EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder.class, this.getRecallNonCashCollateralDescription(), new AttributeMeta[0]);
        }

        @Override
        public MarginCallIssuanceBuilder prune();
    }

    public static class MarginCallIssuanceImpl
    extends MarginCallBase.MarginCallBaseImpl
    implements MarginCallIssuance {
        private final Money callAmountInBaseCurrency;
        private final List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescription;

        protected MarginCallIssuanceImpl(MarginCallIssuanceBuilder builder) {
            super(builder);
            this.callAmountInBaseCurrency = Optional.ofNullable(builder.getCallAmountInBaseCurrency()).map(f -> f.build()).orElse(null);
            this.recallNonCashCollateralDescription = Optional.ofNullable(builder.getRecallNonCashCollateralDescription()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency", isRequired=true)
        @RuneAttribute(value="callAmountInBaseCurrency", isRequired=true)
        public Money getCallAmountInBaseCurrency() {
            return this.callAmountInBaseCurrency;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        @RuneAttribute(value="recallNonCashCollateralDescription")
        public List<? extends EligibleCollateralCriteria> getRecallNonCashCollateralDescription() {
            return this.recallNonCashCollateralDescription;
        }

        @Override
        public MarginCallIssuance build() {
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder toBuilder() {
            MarginCallIssuanceBuilder builder = MarginCallIssuance.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallIssuanceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCallAmountInBaseCurrency()).ifPresent(builder::setCallAmountInBaseCurrency);
            Optional.ofNullable(this.getRecallNonCashCollateralDescription()).ifPresent(builder::setRecallNonCashCollateralDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallIssuance _that = (MarginCallIssuance)this.getType().cast(o);
            if (!Objects.equals(this.callAmountInBaseCurrency, _that.getCallAmountInBaseCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.recallNonCashCollateralDescription, _that.getRecallNonCashCollateralDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.recallNonCashCollateralDescription != null ? this.recallNonCashCollateralDescription.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallIssuance {callAmountInBaseCurrency=" + this.callAmountInBaseCurrency + ", recallNonCashCollateralDescription=" + this.recallNonCashCollateralDescription + '}' + " " + super.toString();
        }
    }
}

