/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.datetime.AdjustableOrAdjustedDate;
import cdm.base.datetime.BusinessCenterTime;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.meta.ExerciseInstructionMeta;
import cdm.product.template.OptionPayout;
import cdm.product.template.metafields.ReferenceWithMetaOptionPayout;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExerciseInstruction", builder=ExerciseInstructionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="ExerciseInstruction", model="cdm", builder=ExerciseInstructionBuilderImpl.class, version="7.0.0-dev.52")
public interface ExerciseInstruction
extends RosettaModelObject {
    public static final ExerciseInstructionMeta metaData = new ExerciseInstructionMeta();

    public PrimitiveInstruction getExerciseQuantity();

    public ReferenceWithMetaOptionPayout getExerciseOption();

    public AdjustableOrAdjustedDate getExerciseDate();

    public BusinessCenterTime getExerciseTime();

    public List<? extends TradeIdentifier> getReplacementTradeIdentifier();

    public ExerciseInstruction build();

    public ExerciseInstructionBuilder toBuilder();

    public static ExerciseInstructionBuilder builder() {
        return new ExerciseInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ExerciseInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExerciseInstruction> getType() {
        return ExerciseInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("exerciseQuantity"), processor, PrimitiveInstruction.class, this.getExerciseQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseOption"), processor, ReferenceWithMetaOptionPayout.class, this.getExerciseOption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseDate"), processor, AdjustableOrAdjustedDate.class, this.getExerciseDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseTime"), processor, BusinessCenterTime.class, this.getExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("replacementTradeIdentifier"), processor, TradeIdentifier.class, this.getReplacementTradeIdentifier(), new AttributeMeta[0]);
    }

    public static class ExerciseInstructionBuilderImpl
    implements ExerciseInstructionBuilder {
        protected PrimitiveInstruction.PrimitiveInstructionBuilder exerciseQuantity;
        protected ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder exerciseOption;
        protected AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder exerciseDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder exerciseTime;
        protected List<TradeIdentifier.TradeIdentifierBuilder> replacementTradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();

        @Override
        @RosettaAttribute(value="exerciseQuantity", isRequired=true)
        @RuneAttribute(value="exerciseQuantity", isRequired=true)
        public PrimitiveInstruction.PrimitiveInstructionBuilder getExerciseQuantity() {
            return this.exerciseQuantity;
        }

        @Override
        public PrimitiveInstruction.PrimitiveInstructionBuilder getOrCreateExerciseQuantity() {
            PrimitiveInstruction.PrimitiveInstructionBuilder result = this.exerciseQuantity != null ? this.exerciseQuantity : (this.exerciseQuantity = PrimitiveInstruction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseOption")
        @RuneAttribute(value="exerciseOption")
        public ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder getExerciseOption() {
            return this.exerciseOption;
        }

        @Override
        public ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder getOrCreateExerciseOption() {
            ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder result = this.exerciseOption != null ? this.exerciseOption : (this.exerciseOption = ReferenceWithMetaOptionPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseDate")
        @RuneAttribute(value="exerciseDate")
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getExerciseDate() {
            return this.exerciseDate;
        }

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateExerciseDate() {
            AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder result = this.exerciseDate != null ? this.exerciseDate : (this.exerciseDate = AdjustableOrAdjustedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseTime")
        @RuneAttribute(value="exerciseTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getExerciseTime() {
            return this.exerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.exerciseTime != null ? this.exerciseTime : (this.exerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="replacementTradeIdentifier")
        @RuneAttribute(value="replacementTradeIdentifier")
        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getReplacementTradeIdentifier() {
            return this.replacementTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateReplacementTradeIdentifier(int index) {
            if (this.replacementTradeIdentifier == null) {
                this.replacementTradeIdentifier = new ArrayList<TradeIdentifier.TradeIdentifierBuilder>();
            }
            return (TradeIdentifier.TradeIdentifierBuilder)this.getIndex(this.replacementTradeIdentifier, index, () -> {
                TradeIdentifier.TradeIdentifierBuilder newReplacementTradeIdentifier = TradeIdentifier.builder();
                return newReplacementTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="exerciseQuantity", isRequired=true)
        @RuneAttribute(value="exerciseQuantity", isRequired=true)
        public ExerciseInstructionBuilder setExerciseQuantity(PrimitiveInstruction _exerciseQuantity) {
            this.exerciseQuantity = _exerciseQuantity == null ? null : _exerciseQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseOption")
        @RuneAttribute(value="exerciseOption")
        public ExerciseInstructionBuilder setExerciseOption(ReferenceWithMetaOptionPayout _exerciseOption) {
            this.exerciseOption = _exerciseOption == null ? null : _exerciseOption.toBuilder();
            return this;
        }

        @Override
        public ExerciseInstructionBuilder setExerciseOptionValue(OptionPayout _exerciseOption) {
            this.getOrCreateExerciseOption().setValue(_exerciseOption);
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseDate")
        @RuneAttribute(value="exerciseDate")
        public ExerciseInstructionBuilder setExerciseDate(AdjustableOrAdjustedDate _exerciseDate) {
            this.exerciseDate = _exerciseDate == null ? null : _exerciseDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseTime")
        @RuneAttribute(value="exerciseTime")
        public ExerciseInstructionBuilder setExerciseTime(BusinessCenterTime _exerciseTime) {
            this.exerciseTime = _exerciseTime == null ? null : _exerciseTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="replacementTradeIdentifier")
        @RuneAttribute(value="replacementTradeIdentifier")
        public ExerciseInstructionBuilder addReplacementTradeIdentifier(TradeIdentifier _replacementTradeIdentifier) {
            if (_replacementTradeIdentifier != null) {
                this.replacementTradeIdentifier.add(_replacementTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ExerciseInstructionBuilder addReplacementTradeIdentifier(TradeIdentifier _replacementTradeIdentifier, int idx) {
            this.getIndex(this.replacementTradeIdentifier, idx, () -> _replacementTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public ExerciseInstructionBuilder addReplacementTradeIdentifier(List<? extends TradeIdentifier> replacementTradeIdentifiers) {
            if (replacementTradeIdentifiers != null) {
                for (TradeIdentifier tradeIdentifier : replacementTradeIdentifiers) {
                    this.replacementTradeIdentifier.add(tradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="replacementTradeIdentifier")
        public ExerciseInstructionBuilder setReplacementTradeIdentifier(List<? extends TradeIdentifier> replacementTradeIdentifiers) {
            this.replacementTradeIdentifier = replacementTradeIdentifiers == null ? new ArrayList<TradeIdentifier.TradeIdentifierBuilder>() : (List)replacementTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ExerciseInstruction build() {
            return new ExerciseInstructionImpl(this);
        }

        @Override
        public ExerciseInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseInstructionBuilder prune() {
            if (this.exerciseQuantity != null && !this.exerciseQuantity.prune().hasData()) {
                this.exerciseQuantity = null;
            }
            if (this.exerciseOption != null && !this.exerciseOption.prune().hasData()) {
                this.exerciseOption = null;
            }
            if (this.exerciseDate != null && !this.exerciseDate.prune().hasData()) {
                this.exerciseDate = null;
            }
            if (this.exerciseTime != null && !this.exerciseTime.prune().hasData()) {
                this.exerciseTime = null;
            }
            this.replacementTradeIdentifier = this.replacementTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getExerciseQuantity() != null && this.getExerciseQuantity().hasData()) {
                return true;
            }
            if (this.getExerciseOption() != null && this.getExerciseOption().hasData()) {
                return true;
            }
            if (this.getExerciseDate() != null && this.getExerciseDate().hasData()) {
                return true;
            }
            if (this.getExerciseTime() != null && this.getExerciseTime().hasData()) {
                return true;
            }
            return this.getReplacementTradeIdentifier() != null && this.getReplacementTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ExerciseInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExerciseInstructionBuilder o = (ExerciseInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseQuantity(), (RosettaModelObjectBuilder)o.getExerciseQuantity(), this::setExerciseQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseOption(), (RosettaModelObjectBuilder)o.getExerciseOption(), this::setExerciseOption);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseDate(), (RosettaModelObjectBuilder)o.getExerciseDate(), this::setExerciseDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseTime(), (RosettaModelObjectBuilder)o.getExerciseTime(), this::setExerciseTime);
            merger.mergeRosetta(this.getReplacementTradeIdentifier(), o.getReplacementTradeIdentifier(), this::getOrCreateReplacementTradeIdentifier);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.exerciseQuantity, _that.getExerciseQuantity())) {
                return false;
            }
            if (!Objects.equals(this.exerciseOption, _that.getExerciseOption())) {
                return false;
            }
            if (!Objects.equals(this.exerciseDate, _that.getExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTime, _that.getExerciseTime())) {
                return false;
            }
            return ListEquals.listEquals(this.replacementTradeIdentifier, _that.getReplacementTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exerciseQuantity != null ? this.exerciseQuantity.hashCode() : 0);
            _result = 31 * _result + (this.exerciseOption != null ? this.exerciseOption.hashCode() : 0);
            _result = 31 * _result + (this.exerciseDate != null ? this.exerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTime != null ? this.exerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.replacementTradeIdentifier != null ? this.replacementTradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseInstructionBuilder {exerciseQuantity=" + this.exerciseQuantity + ", exerciseOption=" + this.exerciseOption + ", exerciseDate=" + this.exerciseDate + ", exerciseTime=" + this.exerciseTime + ", replacementTradeIdentifier=" + this.replacementTradeIdentifier + '}';
        }
    }

    public static interface ExerciseInstructionBuilder
    extends ExerciseInstruction,
    RosettaModelObjectBuilder {
        public PrimitiveInstruction.PrimitiveInstructionBuilder getOrCreateExerciseQuantity();

        @Override
        public PrimitiveInstruction.PrimitiveInstructionBuilder getExerciseQuantity();

        public ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder getOrCreateExerciseOption();

        @Override
        public ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder getExerciseOption();

        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateExerciseDate();

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getExerciseDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExerciseTime();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateReplacementTradeIdentifier(int var1);

        public List<? extends TradeIdentifier.TradeIdentifierBuilder> getReplacementTradeIdentifier();

        public ExerciseInstructionBuilder setExerciseQuantity(PrimitiveInstruction var1);

        public ExerciseInstructionBuilder setExerciseOption(ReferenceWithMetaOptionPayout var1);

        public ExerciseInstructionBuilder setExerciseOptionValue(OptionPayout var1);

        public ExerciseInstructionBuilder setExerciseDate(AdjustableOrAdjustedDate var1);

        public ExerciseInstructionBuilder setExerciseTime(BusinessCenterTime var1);

        public ExerciseInstructionBuilder addReplacementTradeIdentifier(TradeIdentifier var1);

        public ExerciseInstructionBuilder addReplacementTradeIdentifier(TradeIdentifier var1, int var2);

        public ExerciseInstructionBuilder addReplacementTradeIdentifier(List<? extends TradeIdentifier> var1);

        public ExerciseInstructionBuilder setReplacementTradeIdentifier(List<? extends TradeIdentifier> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("exerciseQuantity"), processor, PrimitiveInstruction.PrimitiveInstructionBuilder.class, this.getExerciseQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseOption"), processor, ReferenceWithMetaOptionPayout.ReferenceWithMetaOptionPayoutBuilder.class, this.getExerciseOption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseDate"), processor, AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder.class, this.getExerciseDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("replacementTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, this.getReplacementTradeIdentifier(), new AttributeMeta[0]);
        }

        public ExerciseInstructionBuilder prune();
    }

    public static class ExerciseInstructionImpl
    implements ExerciseInstruction {
        private final PrimitiveInstruction exerciseQuantity;
        private final ReferenceWithMetaOptionPayout exerciseOption;
        private final AdjustableOrAdjustedDate exerciseDate;
        private final BusinessCenterTime exerciseTime;
        private final List<? extends TradeIdentifier> replacementTradeIdentifier;

        protected ExerciseInstructionImpl(ExerciseInstructionBuilder builder) {
            this.exerciseQuantity = Optional.ofNullable(builder.getExerciseQuantity()).map(f -> f.build()).orElse(null);
            this.exerciseOption = Optional.ofNullable(builder.getExerciseOption()).map(f -> f.build()).orElse(null);
            this.exerciseDate = Optional.ofNullable(builder.getExerciseDate()).map(f -> f.build()).orElse(null);
            this.exerciseTime = Optional.ofNullable(builder.getExerciseTime()).map(f -> f.build()).orElse(null);
            this.replacementTradeIdentifier = Optional.ofNullable(builder.getReplacementTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exerciseQuantity", isRequired=true)
        @RuneAttribute(value="exerciseQuantity", isRequired=true)
        public PrimitiveInstruction getExerciseQuantity() {
            return this.exerciseQuantity;
        }

        @Override
        @RosettaAttribute(value="exerciseOption")
        @RuneAttribute(value="exerciseOption")
        public ReferenceWithMetaOptionPayout getExerciseOption() {
            return this.exerciseOption;
        }

        @Override
        @RosettaAttribute(value="exerciseDate")
        @RuneAttribute(value="exerciseDate")
        public AdjustableOrAdjustedDate getExerciseDate() {
            return this.exerciseDate;
        }

        @Override
        @RosettaAttribute(value="exerciseTime")
        @RuneAttribute(value="exerciseTime")
        public BusinessCenterTime getExerciseTime() {
            return this.exerciseTime;
        }

        @Override
        @RosettaAttribute(value="replacementTradeIdentifier")
        @RuneAttribute(value="replacementTradeIdentifier")
        public List<? extends TradeIdentifier> getReplacementTradeIdentifier() {
            return this.replacementTradeIdentifier;
        }

        @Override
        public ExerciseInstruction build() {
            return this;
        }

        @Override
        public ExerciseInstructionBuilder toBuilder() {
            ExerciseInstructionBuilder builder = ExerciseInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseInstructionBuilder builder) {
            Optional.ofNullable(this.getExerciseQuantity()).ifPresent(builder::setExerciseQuantity);
            Optional.ofNullable(this.getExerciseOption()).ifPresent(builder::setExerciseOption);
            Optional.ofNullable(this.getExerciseDate()).ifPresent(builder::setExerciseDate);
            Optional.ofNullable(this.getExerciseTime()).ifPresent(builder::setExerciseTime);
            Optional.ofNullable(this.getReplacementTradeIdentifier()).ifPresent(builder::setReplacementTradeIdentifier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.exerciseQuantity, _that.getExerciseQuantity())) {
                return false;
            }
            if (!Objects.equals(this.exerciseOption, _that.getExerciseOption())) {
                return false;
            }
            if (!Objects.equals(this.exerciseDate, _that.getExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTime, _that.getExerciseTime())) {
                return false;
            }
            return ListEquals.listEquals(this.replacementTradeIdentifier, _that.getReplacementTradeIdentifier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exerciseQuantity != null ? this.exerciseQuantity.hashCode() : 0);
            _result = 31 * _result + (this.exerciseOption != null ? this.exerciseOption.hashCode() : 0);
            _result = 31 * _result + (this.exerciseDate != null ? this.exerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTime != null ? this.exerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.replacementTradeIdentifier != null ? this.replacementTradeIdentifier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseInstruction {exerciseQuantity=" + this.exerciseQuantity + ", exerciseOption=" + this.exerciseOption + ", exerciseDate=" + this.exerciseDate + ", exerciseTime=" + this.exerciseTime + ", replacementTradeIdentifier=" + this.replacementTradeIdentifier + '}';
        }
    }
}

