/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.math.Quantity;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import cdm.event.common.meta.CalculateTransferInstructionMeta;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculateTransferInstruction", builder=CalculateTransferInstructionBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CalculateTransferInstruction", model="cdm", builder=CalculateTransferInstructionBuilderImpl.class, version="7.0.0-dev.52")
public interface CalculateTransferInstruction
extends RosettaModelObject {
    public static final CalculateTransferInstructionMeta metaData = new CalculateTransferInstructionMeta();

    public TradeState getTradeState();

    public ReferenceWithMetaPayout getPayout();

    public List<? extends Reset> getResets();

    public PayerReceiver getPayerReceiver();

    public Quantity getQuantity();

    public Date getDate();

    public CalculateTransferInstruction build();

    public CalculateTransferInstructionBuilder toBuilder();

    public static CalculateTransferInstructionBuilder builder() {
        return new CalculateTransferInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculateTransferInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculateTransferInstruction> getType() {
        return CalculateTransferInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeState"), processor, TradeState.class, this.getTradeState(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.class, this.getPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resets"), processor, Reset.class, this.getResets(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, Quantity.class, this.getQuantity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), Date.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculateTransferInstructionBuilderImpl
    implements CalculateTransferInstructionBuilder {
        protected TradeState.TradeStateBuilder tradeState;
        protected ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder payout;
        protected List<Reset.ResetBuilder> resets = new ArrayList<Reset.ResetBuilder>();
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected Quantity.QuantityBuilder quantity;
        protected Date date;

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public TradeState.TradeStateBuilder getTradeState() {
            return this.tradeState;
        }

        @Override
        public TradeState.TradeStateBuilder getOrCreateTradeState() {
            TradeState.TradeStateBuilder result = this.tradeState != null ? this.tradeState : (this.tradeState = TradeState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout() {
            return this.payout;
        }

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout() {
            ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder result = this.payout != null ? this.payout : (this.payout = ReferenceWithMetaPayout.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resets")
        @RuneAttribute(value="resets")
        public List<? extends Reset.ResetBuilder> getResets() {
            return this.resets;
        }

        @Override
        public Reset.ResetBuilder getOrCreateResets(int index) {
            if (this.resets == null) {
                this.resets = new ArrayList<Reset.ResetBuilder>();
            }
            return (Reset.ResetBuilder)this.getIndex(this.resets, index, () -> {
                Reset.ResetBuilder newResets = Reset.builder();
                return newResets;
            });
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public Quantity.QuantityBuilder getQuantity() {
            return this.quantity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateQuantity() {
            Quantity.QuantityBuilder result = this.quantity != null ? this.quantity : (this.quantity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public Date getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public CalculateTransferInstructionBuilder setTradeState(TradeState _tradeState) {
            this.tradeState = _tradeState == null ? null : _tradeState.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public CalculateTransferInstructionBuilder setPayout(ReferenceWithMetaPayout _payout) {
            this.payout = _payout == null ? null : _payout.toBuilder();
            return this;
        }

        @Override
        public CalculateTransferInstructionBuilder setPayoutValue(Payout _payout) {
            this.getOrCreatePayout().setValue(_payout);
            return this;
        }

        @Override
        @RosettaAttribute(value="resets")
        @RuneAttribute(value="resets")
        public CalculateTransferInstructionBuilder addResets(Reset _resets) {
            if (_resets != null) {
                this.resets.add(_resets.toBuilder());
            }
            return this;
        }

        @Override
        public CalculateTransferInstructionBuilder addResets(Reset _resets, int idx) {
            this.getIndex(this.resets, idx, () -> _resets.toBuilder());
            return this;
        }

        @Override
        public CalculateTransferInstructionBuilder addResets(List<? extends Reset> resetss) {
            if (resetss != null) {
                for (Reset reset : resetss) {
                    this.resets.add(reset.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="resets")
        public CalculateTransferInstructionBuilder setResets(List<? extends Reset> resetss) {
            this.resets = resetss == null ? new ArrayList<Reset.ResetBuilder>() : (List)resetss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public CalculateTransferInstructionBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public CalculateTransferInstructionBuilder setQuantity(Quantity _quantity) {
            this.quantity = _quantity == null ? null : _quantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public CalculateTransferInstructionBuilder setDate(Date _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        public CalculateTransferInstruction build() {
            return new CalculateTransferInstructionImpl(this);
        }

        @Override
        public CalculateTransferInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculateTransferInstructionBuilder prune() {
            if (this.tradeState != null && !this.tradeState.prune().hasData()) {
                this.tradeState = null;
            }
            if (this.payout != null && !this.payout.prune().hasData()) {
                this.payout = null;
            }
            this.resets = this.resets.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.quantity != null && !this.quantity.prune().hasData()) {
                this.quantity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeState() != null && this.getTradeState().hasData()) {
                return true;
            }
            if (this.getPayout() != null && this.getPayout().hasData()) {
                return true;
            }
            if (this.getResets() != null && this.getResets().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().hasData()) {
                return true;
            }
            return this.getDate() != null;
        }

        public CalculateTransferInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculateTransferInstructionBuilder o = (CalculateTransferInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeState(), (RosettaModelObjectBuilder)o.getTradeState(), this::setTradeState);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayout(), (RosettaModelObjectBuilder)o.getPayout(), this::setPayout);
            merger.mergeRosetta(this.getResets(), o.getResets(), this::getOrCreateResets);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantity(), (RosettaModelObjectBuilder)o.getQuantity(), this::setQuantity);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculateTransferInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeState, _that.getTradeState())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resets, _that.getResets())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.resets != null ? this.resets.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculateTransferInstructionBuilder {tradeState=" + this.tradeState + ", payout=" + this.payout + ", resets=" + this.resets + ", payerReceiver=" + this.payerReceiver + ", quantity=" + this.quantity + ", date=" + this.date + '}';
        }
    }

    public static interface CalculateTransferInstructionBuilder
    extends CalculateTransferInstruction,
    RosettaModelObjectBuilder {
        public TradeState.TradeStateBuilder getOrCreateTradeState();

        @Override
        public TradeState.TradeStateBuilder getTradeState();

        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout();

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getPayout();

        public Reset.ResetBuilder getOrCreateResets(int var1);

        public List<? extends Reset.ResetBuilder> getResets();

        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public Quantity.QuantityBuilder getOrCreateQuantity();

        @Override
        public Quantity.QuantityBuilder getQuantity();

        public CalculateTransferInstructionBuilder setTradeState(TradeState var1);

        public CalculateTransferInstructionBuilder setPayout(ReferenceWithMetaPayout var1);

        public CalculateTransferInstructionBuilder setPayoutValue(Payout var1);

        public CalculateTransferInstructionBuilder addResets(Reset var1);

        public CalculateTransferInstructionBuilder addResets(Reset var1, int var2);

        public CalculateTransferInstructionBuilder addResets(List<? extends Reset> var1);

        public CalculateTransferInstructionBuilder setResets(List<? extends Reset> var1);

        public CalculateTransferInstructionBuilder setPayerReceiver(PayerReceiver var1);

        public CalculateTransferInstructionBuilder setQuantity(Quantity var1);

        public CalculateTransferInstructionBuilder setDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeState"), processor, TradeState.TradeStateBuilder.class, this.getTradeState(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resets"), processor, Reset.ResetBuilder.class, this.getResets(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, Quantity.QuantityBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), Date.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculateTransferInstructionBuilder prune();
    }

    public static class CalculateTransferInstructionImpl
    implements CalculateTransferInstruction {
        private final TradeState tradeState;
        private final ReferenceWithMetaPayout payout;
        private final List<? extends Reset> resets;
        private final PayerReceiver payerReceiver;
        private final Quantity quantity;
        private final Date date;

        protected CalculateTransferInstructionImpl(CalculateTransferInstructionBuilder builder) {
            this.tradeState = Optional.ofNullable(builder.getTradeState()).map(f -> f.build()).orElse(null);
            this.payout = Optional.ofNullable(builder.getPayout()).map(f -> f.build()).orElse(null);
            this.resets = Optional.ofNullable(builder.getResets()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).map(f -> f.build()).orElse(null);
            this.date = builder.getDate();
        }

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public TradeState getTradeState() {
            return this.tradeState;
        }

        @Override
        @RosettaAttribute(value="payout", isRequired=true)
        @RuneAttribute(value="payout", isRequired=true)
        public ReferenceWithMetaPayout getPayout() {
            return this.payout;
        }

        @Override
        @RosettaAttribute(value="resets")
        @RuneAttribute(value="resets")
        public List<? extends Reset> getResets() {
            return this.resets;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public Quantity getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="date")
        @RuneAttribute(value="date")
        public Date getDate() {
            return this.date;
        }

        @Override
        public CalculateTransferInstruction build() {
            return this;
        }

        @Override
        public CalculateTransferInstructionBuilder toBuilder() {
            CalculateTransferInstructionBuilder builder = CalculateTransferInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculateTransferInstructionBuilder builder) {
            Optional.ofNullable(this.getTradeState()).ifPresent(builder::setTradeState);
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getResets()).ifPresent(builder::setResets);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculateTransferInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeState, _that.getTradeState())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!ListEquals.listEquals(this.resets, _that.getResets())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.date, _that.getDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.resets != null ? this.resets.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculateTransferInstruction {tradeState=" + this.tradeState + ", payout=" + this.payout + ", resets=" + this.resets + ", payerReceiver=" + this.payerReceiver + ", quantity=" + this.quantity + ", date=" + this.date + '}';
        }
    }
}

