/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.confirmation.X509Data;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class X509DataOnlyExistsValidator
implements ValidatorWithArg<X509Data, Set<String>> {
    public <T2 extends X509Data> ValidationResult<X509Data> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"x509DataTypeSequence", (Object)ExistenceChecker.isSet(o.getX509DataTypeSequence())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"X509Data", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"X509Data", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"X509Data", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"X509Data", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

