/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.confirmation.Swaption;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SwaptionOnlyExistsValidator
implements ValidatorWithArg<Swaption, Set<String>> {
    public <T2 extends Swaption> ValidationResult<Swaption> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"productModel", (Object)ExistenceChecker.isSet((Object)o.getProductModel())).put((Object)"id", (Object)ExistenceChecker.isSet((Object)o.getId())).put((Object)"buyerSellerModel", (Object)ExistenceChecker.isSet((Object)o.getBuyerSellerModel())).put((Object)"premium", (Object)ExistenceChecker.isSet(o.getPremium())).put((Object)"exercise", (Object)ExistenceChecker.isSet((Object)o.getExercise())).put((Object)"exerciseProcedure", (Object)ExistenceChecker.isSet((Object)o.getExerciseProcedure())).put((Object)"calculationAgent", (Object)ExistenceChecker.isSet((Object)o.getCalculationAgent())).put((Object)"cashSettlement", (Object)ExistenceChecker.isSet((Object)o.getCashSettlement())).put((Object)"physicalSettlement", (Object)ExistenceChecker.isSet((Object)o.getPhysicalSettlement())).put((Object)"swaptionStraddle", (Object)ExistenceChecker.isSet((Object)o.getSwaptionStraddle())).put((Object)"earlyTerminationProvision", (Object)ExistenceChecker.isSet((Object)o.getEarlyTerminationProvision())).put((Object)"swaptionAdjustedDates", (Object)ExistenceChecker.isSet((Object)o.getSwaptionAdjustedDates())).put((Object)"swap", (Object)ExistenceChecker.isSet((Object)o.getSwap())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"Swaption", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"Swaption", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"Swaption", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"Swaption", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

