/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.confirmation.Metal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetalOnlyExistsValidator
implements ValidatorWithArg<Metal, Set<String>> {
    public <T2 extends Metal> ValidationResult<Metal> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"material", (Object)ExistenceChecker.isSet((Object)o.getMaterial())).put((Object)"shape", (Object)ExistenceChecker.isSet(o.getShape())).put((Object)"brand", (Object)ExistenceChecker.isSet(o.getBrand())).put((Object)"grade", (Object)ExistenceChecker.isSet(o.getGrade())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"Metal", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"Metal", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"Metal", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"Metal", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

