/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import fpml.confirmation.DigestMethod;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DigestMethodOnlyExistsValidator
implements ValidatorWithArg<DigestMethod, Set<String>> {
    public <T2 extends DigestMethod> ValidationResult<DigestMethod> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"anyContents", (Object)ExistenceChecker.isSet(o.getAnyContents())).put((Object)"algorithm", (Object)ExistenceChecker.isSet((Object)o.getAlgorithm())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"DigestMethod", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"DigestMethod", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"DigestMethod", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"DigestMethod", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

