/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.VolatilityRepresentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="VolatilityRepresentationChoice")
@ImplementedBy(value=Default.class)
public interface VolatilityRepresentationChoice
extends Validator<VolatilityRepresentation> {
    public static final String NAME = "VolatilityRepresentationChoice";
    public static final String DEFINITION = "required choice asset, yieldCurveReference";

    public static class NoOp
    implements VolatilityRepresentationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityRepresentation volatilityRepresentation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements VolatilityRepresentationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityRepresentation volatilityRepresentation) {
            ComparisonResult result = this.executeDataRule(volatilityRepresentation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)VolatilityRepresentationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityRepresentation", (RosettaPath)path, (String)VolatilityRepresentationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)VolatilityRepresentationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityRepresentation", (RosettaPath)path, (String)VolatilityRepresentationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(VolatilityRepresentation volatilityRepresentation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)volatilityRepresentation), Arrays.asList("asset", "yieldCurveReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

